<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("DisableService", "function Disable(id, status){
    var r = confirm((status == 'Y') ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
    if(r==true)
    {
        jQuery.ajax({
            'type'  : 'post',
            'datatype' : 'json',
            'data'  : 'id=' + id + '&status=' + status,
            'url'   : $('#liveSite').val()+'index.php?r=sales/masServices/Disable',
            'cache' : false,
            'success': function(data){
                if(data.status=='fail'){
                    t8.error('Error while updating status');
                } else {
                    $('#tbl_services').DataTable().ajax.reload();
                    t8.success('Success!');
                }
            }
        });
    }
};", CClientScript::POS_HEAD);

$baseUrl = Yii::app()->baseUrl;
?>

<script>
$(document).ready(function () {
    var table_id = "#tbl_services";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
        data.display_type = $("#display_type").val();
        return data;
    }).DataTable({
        scrollY: "645px",
        pageLength: 50,
        processing: true,
        ajax: {
            url: "<?php echo Yii::app()->createUrl('sales/masServices/GetServicesList') ?>",
            type: "POST",
            cache: false
        },
        serverSide: true,
        fixedColumns: true,
        "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
        },
        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            if (aData[3].status == "N") {
                $("td", nRow).addClass("bg-danger");
            }
            AddContextMenu(nRow, aData);
        }
    });
});

function AddContextMenu(row, datas) {
    var items = {};

    <?php if (isset(Yii::app()->user->havePermissionOn['sales_master_service_edit']) || Yii::app()->user->authorised_user == 1) { ?>
        items["edit"] = {
            name: "Edit",
            icon: "edit",
            accesskey: "e",
            callback: function () {
                loadPopupModal("sales/masServices/create&id=" + datas[3].id, datas[1], "lg");
            }
        };
    <?php } ?>

    <?php if (isset(Yii::app()->user->havePermissionOn['sales_master_service_disable']) || Yii::app()->user->authorised_user == 1) { ?>
        items["Disable_Enable"] = {
            name: (datas[3].status == "Y") ? "Disable" : "Enable",
            icon: "edit",
            accesskey: "d",
            callback: function () {
                Disable(datas[3].id, datas[3].status);
            }
        };
    <?php } ?>

    if (Object.keys(items).length > 0) {
        $(row).contextMenu({
            selector: 'td',
            items: items
        });
    }
}
</script>

<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        Services
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['sales_master_service_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn" onclick="loadPopupModal('sales/masServices/create', 'Add New Service', 'lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                        class="pluss-ad">
                        <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                        <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                    </svg>
                </a>
            <?php } ?>
        </div>
    </header>

    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_services">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Code</th>
                        <th>Name</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
