<?php /** @var CActiveForm $form */ ?>
<div class="table-responsive">
    <table class="table table-bordered table-striped" id="returnMachineTable">
        <thead>
            <tr>
                <th style="width:40px;">#</th>
                <th><input type="checkbox" id="selectAllMachines" /></th>
                <th>Machine</th>
                <th>Serial No</th>
                <th>Outlet</th>
                <th>Location</th>
                <!-- <th>Return Technician</th> -->
                <th>Return Remarks</th>
            </tr>
        </thead>
        <tbody>
            <?php $sl = 1; ?>
            <?php foreach ($machineList as $machine): ?>
                <?php
                $serialNo = $machine->serial_no ?: '-';
                $machine_name = $machine->product_name ?: '-';
                $outletName = isset($machine->inventorygoodsissue->outlet_id) && !empty($machine->inventorygoodsissue->outlet->outlet_location) ? $machine->inventorygoodsissue->outlet->outlet_location : '-';
                $locationName = isset($machine->location_id) && !empty($machine->location->location_name) ? $machine->location->location_name : '-'; ?>
                <tr>
                    <td><?= $sl++; ?></td>
                    <td><input type="checkbox" name="InventoryGoodsReceiptItem[<?= $machine->id; ?>][selected]" value="<?= $machine->id; ?>" class="" /></td>
                    <td><?= CHtml::encode($machine_name); ?></td>
                    <td><?= CHtml::encode($serialNo); ?></td>
                    <td><?= CHtml::encode($outletName); ?></td>
                    <td><?= CHtml::encode($locationName); ?></td>
                    <?php /*<td>
                        <?= CHtml::dropDownList(
                            "InventoryGoodsReceiptItem[{$machine->id}][return_lead_owner_id]",
                            '', // default value
                            User::getUser(), // list of users
                            [ 'prompt' => '-- Select Lead Owner --', 'class' => 'form-control returnLeadOwnerDropdown' ] ); ?>
                    </td>*/?>
                    <td><?= CHtml::textField( "InventoryGoodsReceiptItem[{$machine->id}][return_remarks]", '', [ 'class' => 'form-control', 'placeholder' => 'Enter remarks', ] ); ?></td>
                    <!-- Hidden fields for backend processing -->
                    <?= CHtml::hiddenField("InventoryGoodsReceiptItem[{$machine->id}][product_id]", $machine->product_id); ?>
                    <?= CHtml::hiddenField("InventoryGoodsReceiptItem[{$machine->id}][serial_no]", $machine->serial_no); ?>
                    <?= CHtml::hiddenField("InventoryGoodsReceiptItem[{$machine->id}][goods_issue_id]", $machine->goods_issue_id); ?>
                    <?/*= CHtml::hiddenField("InventoryGoodsReceiptItem[{$machine->id}][stock_ledger_id]", $machine->stock_ledger_id);*/ ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<script>
    // Select/Deselect all checkboxes
    $('#selectAllMachines').on('click', function () {
        $('.machineSelect').prop('checked', this.checked);
    });
</script>