<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'machines-apporve-return-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
)); ?>
<ul class="clearfix form-ul material">
    <?php echo $form->hiddenField($model, 'id'); ?>
    <?php $customer_name = '';
    if ($model->customer_id > 0) {
        $customer_name = $model->customer->customer_name;
    } ?>
    <li class="col-sm-4">
        <?php echo $form->textField($model, 'customer_name', array('class' => 'tooltipster', 'title' => 'Customer', 'data-label' => 'Customer <span style="color:red">*</span>', 'readonly' => true,'value'=>$customer_name)); ?>
        <?php echo $form->hiddenField($model, 'customer_id'); ?>
    </li>
    <li class="col-sm-4">
        <?php
        if ($model->outlet_id > 0) {
            echo $form->dropDownList($model, 'outlet_id', CustomerOutletLocation::getShippingLocation($model->customer_id), array(
                'options' => array($model->outlet_id => array('selected' => true)),
                'readonly' => true,
                'data-label' => 'Outlet Location',
                'prompt' => 'Select',
                'disabled' => true
            ));
            echo $form->hiddenField($model, 'outlet_id');
        } else {
            echo $form->dropDownList($model, 'outlet_id', array(), array('readonly' => true, 'data-label' => 'Outlet Location', 'prompt' => 'Select'));
        } ?>
    </li>
    <li class="col-sm-4">
        <?php echo $form->dropDownList($model, 'lead_owner_id', User::getUser(), array(
            'class' => 'tooltipster',
            'title' => 'Lead Owner',
            'data-label' => 'Returning Lead Owner  <span style="color:red">*</span>',
            'data-search' => true,
            'empty' => '--Select--',
            'disabled' => true
        )); ?>
    </li>
</ul>
<div class="table-responsive">
    <table class="table table-hover table-bordered" id="tbl_repair_request">
        <thead>
            <tr>
                <th style="width:5%;">#</th>
                <th style="width:20%;">Serial Number</th>
                <th style="width:20%;">Machine</th>
                <th style="width:20%;">Location</th>
                <th style="width:25%;">Return Remarks</th>
            </tr>
        </thead>
        <tbody>
            <?php $m = 1;
            foreach ($modelIssueItem as $i => $eachmachine): ?>
                <tr data-index="<?php echo $i; ?>">
                    <td class="srno">
                        <?php echo $m++; ?>&nbsp;
                        <?php
                        if ($eachmachine->isApproved == 'N') {
                            echo CHtml::checkBox(
                                "InventoryGoodsReceiptItem[{$i}][selected]", // name for tabular form
                                false, // default unchecked
                                [
                                    'value' => $eachmachine->id ?? $i,  // checkbox value (e.g., machine ID or index)
                                    'class' => 'machine-check',         // optional class for JS use
                                    'data-label' => "Select Machine #{$m}"
                                ]
                            );
                        }
                        echo $form->hiddenField($eachmachine, "[$i]id"); ?>
                    </td>
                    <td id="div_leadownermachinesserialno_<?php echo $i; ?>">
                        <?php
                        echo $form->textField($eachmachine, "[$i]serial_no", [
                            'class' => 'form-control',
                            'title' => 'Machine Serial No',
                            'readonly' => true
                        ]); ?>
                    </td>
                    <td id="div_leadownermachines_<?php echo $i; ?>">
                        <?php
                        echo $form->textField($eachmachine, "[$i]product_name", [
                            'class' => 'form-control',
                            'title' => 'Machine Serial No',
                            'readonly' => true
                        ]);
                        echo $form->hiddenField($eachmachine, "[$i]product_id"); ?>
                    </td>
                    <td id="div_customerlocation_<?php echo $i; ?>">
                        <?php
                        echo $form->dropDownList(
                            $eachmachine,
                            "[$i]location_id",
                            ($model->customer_id > 0)
                            ? ServiceCustomerLocation::getLocationCustomerByOutlet(
                                $model->customer_id,
                                $model->outlet_id
                            )
                            : [],
                            [
                                'class' => 'form-control',
                                'title' => 'Customer Location',
                                'data-label' => 'Customer Location <span style="color:red">*</span>',
                                'data-search' => true,
                                'empty' => '--Select--',
                                'disabled' => true
                            ]
                        ); ?>
                    </td>
                    <td>
                        <?php echo $form->textField(
                            $eachmachine,
                            "[$i]description",
                            [
                                'class' => 'form-control',
                                'placeholder' => 'Return Remarks',
                                'readonly' => true
                            ]
                        ); ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="machine_close" data-dismiss="modal">Close</button>&nbsp;&nbsp;
    <div class="text-center mt-3" style="float: right;">
        <?php echo CHtml::ajaxSubmitButton(
            'Approve',
            Yii::app()->createUrl('sales/Inventorygoodsreceipt/SaveApprovel'),
            [
                'type' => 'POST',
                'dataType' => 'json',
                'success' => 'function(response){
                    if(response.status == "success"){
                        event.preventDefault();
                        t8.success(response.message);
                        $(".close").click();
                        reloadTable("#tbl_to_be_returned_machines");
                        reloadTable("#tbl_returned_machines");
                        //window.location.reload();
                    } else {
                        t8.error(response.message);
                    }
                }',
            ],
            ['class' => 'btn btn-primary']
        ); ?>
    </div>
</div>
<?php $this->endWidget(); ?>