<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="material-icons">assignment_return</i> Returned Machines
        <div class="pull-right">
            <?php if ((isset(Yii::app()->user->havePermissionOn['machine_replacement_add']) || Yii::app()->user->authorised_user == 1)) { ?>

                <button class="btn btn-sm btn-theme"
                    onclick="loadPopupModal('sales/Inventorygoodsissue/returnForm','Add Machine Return','xl')"><i
                        class="fa fa-plus"></i> ADD</button>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered" id="tbl_returned_machines" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Sl.No</th>
                        <th>Customer</th>
                        <th>Assigned User</th>
                        <th>Location</th>
                        <th>Serial No</th>
                        <th>Machine</th>
                        <th>Action</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>

<script>
    $(document).ready(function () {
        $('#tbl_returned_machines').DataTable({
            pageLength: 50,
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('sales/Inventorygoodsissue/GetReturnList'); ?>",
                type: "POST",
            },
            columnDefs: [
                { "orderable": false, "targets": [6] }
            ],
            order: [[0, 'DESC']],
        });
    });

    function viewReturn(id) {
        loadPopupModal('sales/Inventorygoodsissue/CreateReturn&type=returnview&id=' + id, 'View Returned Machine', 'xl');
    }
</script>