<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'machines-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
$readonly = false;
$disabled = false;
$modMasIssueType = new MasIssueType();
$arr_MasIssueType = $modMasIssueType->getMachineIssueType();
echo $form->hiddenField($model, 'id'); ?>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#general_tab" data-toggle="tab">General</a></li>
    <li><a href="#machine_tab" data-toggle="tab">Machine</a></li>
</ul>
<div class="tab-content">
    <div class="tab-pane fade in active" id="general_tab">
        <?php
        $this->renderPartial('general', array( 'model' => $model, 'form' => $form, 'type' => $type )); ?>
    </div>
    <div class="tab-pane fade" id="machine_tab">
        <?php
        $this->renderPartial('machine_list', array( 'model' => $model, 'form' => $form, 'modelIssueItem' => $modelIssueItem, 'type' => $type, 'arr_MasIssueType' => $arr_MasIssueType, 'readonly' => $readonly, 'disabled' => $disabled )); ?>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="machine_close" data-dismiss="modal">Close</button>
    <?php
    if ($type != 'view') {
        $url = Yii::app()->createUrl('sales/Inventorygoodsissue/Save');
        echo CHtml::ajaxSubmitButton('Save', $url, array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();                                         
                if(data.status=="success"){  
                    t8.success("Saved Successfully!");
                    $("#machine_close").click();
                    reloadTable("#tbl_machines_details");
                } else { 
                    $("#machines-form .machine-save-btn").prop("disabled", false);   
                    $("#machines-form .machine-save-btn").addClass("btn-theme").removeClass("btn_loding");
                    $.each(data, function(key, val) {
                        $("#machines-form #"+key+"_em_").text(val).show(); 
                        t8.error(""+val+""); 
                    }); 
                } 
            }',
            'beforeSend' => 'function(){
                $("#loader").show();
                $("#machines-form .machine-save-btn").prop("disabled", true);                      
                $("#machines-form .machine-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
                $(".toast8-error").hide(); 
            }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'machine-save-btn btn btn-theme'));
    } ?>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("leadownerMachinesInvoice", "function leadownerMachinesInvoice(field_id, frm) {
    var lead_owner_id = $('#InventoryGoodsIssue_lead_owner_id').val();
    var customer_id = $('#InventoryGoodsIssue_customer_id').val();
    if ( customer_id=='') {
        t8.error('Please choose a Customer');
        $('#serial_no').val('');
        return false;
    } else {
        jQuery.ajax({
            data: { 'lead_owner_id': lead_owner_id, 'customer_id': customer_id, 'columnWidth': 4 },
            dataType: 'json',
            type: 'get',
            url: '" . Yii::app()->createUrl('sales/Inventorygoodsissue/GetInvoiceDropdown') . "',
            success: function(data) {
                $('#div_InvoiceFileList').html(data.dropdown);
                window.salesGroupMap = data.sales_groups || {};
                window.assignedUser = data.assigned_users || {};
            }
        });
        return true;
    }
}
", CClientScript::POS_END);
$cs->registerScript("autoCompleteMachineCustomer", "function autoCompleteMachineCustomer(field_id, frm) {
    var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "' + '&frm=' + frm;
    $('#' + field_id).autocomplete({
        minLength: 1,
        source: function (request, response) {
            autoCompleteSource(request, response, url);
        },
        select: function (event, ui) {
            event.preventDefault();
            var customer_id = ui.item.value;
            $('#InventoryGoodsIssue_customer_id').val(customer_id);
            $('#customer_name').val(ui.item.label);
            // Loop through each row in the table and update Outlet dropdowns
            $('#tbl_repair_request tbody tr').each(function (index, tr) {
                var row = $(tr);
                var rowIndex = row.data('index') || index;
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: '" . Yii::app()->createUrl('sales/Inventorygoodsissue/getCustomerShippingdetails') . "',
                    data: { id: customer_id, row_index: rowIndex },
                    success: function (data) {
                        $('#div_customershippimg').html(data.dtship);
                        getOutletLocationDetails();
                    }
                });
                leadownerMachinesInvoice(this);
            });
        }
    });
}
", CClientScript::POS_END);
$cs->registerScript("autoCompleteinvoicefileid", "function autoCompleteinvoicefileid(field_id, frm){
    var customer_id = $('#InventoryGoodsIssue_customer_id').val();
    var lead_owner_id = $('#InventoryGoodsIssue_lead_owner_id').val();
    var type_of_invoice = 'service';
    if(customer_id==''){
        t8.error('Select Customer');
    } else {
        var url = '" . Yii::app()->createUrl('invoice/GetinvoicedetailsAjax') . "' + 
            '&frm=' + frm + '&customer_id=' + customer_id + '&type_of_invoice=' + type_of_invoice;
        $('#' + field_id).autocomplete({
            minLength: 1,
            source: function (request, response) {
                autoCompleteSource(request, response, url);
            },
            focus: function(event, ui) {
                $(this).val(ui.item.file_id);
                return false;
            },
            select: function(event, ui) {
                event.preventDefault();
                console.log(ui.item);
                $('#InventoryGoodsIssue_file_id').val(ui.item.file_id);
                $('#InventoryGoodsIssue_production_order_id').val(ui.item.value);
            }
        });
    }
}
", CClientScript::POS_END); ?>
<script>
    function getMachineDetailsList() {
        var leadOwnerId = $('#InventoryGoodsIssue_lead_owner_id').val();
        var customerId = $('#InventoryGoodsIssue_customer_id').val();
        var file_id = $('#InventoryGoodsIssue_file_id').val();
        var filterText = $('#machineFilter').val(); // Optional textbox for filtering
        $('#tbl_repair_request tbody tr').each(function (index, tr) {
            $.ajax({
                url: 'index.php?r=sales/Inventorygoodsissue/GetLeadownerMachineDetails',
                type: 'GET',
                dataType: 'json',
                data: {
                    lead_owner_id: leadOwnerId,
                    customer_id: customerId,
                    file_id: file_id,
                    row_index: index,
                    filter_text: filterText // <-- added
                },
                success: function (data) {
                    if (data.status === 'success') {
                        $('#div_leadownermachinesserialno_' + index).html(data.dt);
                        updateSerialDropdowns();
                    }
                }
            });
        });
    }
</script>
<script>
    function changeType(el) {
        console.log(window.salesGroupMap);
        if (typeof window.salesGroupMap === 'undefined') return;
        var selectedId = $(el).val();
        var salesGroupId = window.salesGroupMap[selectedId];
        var issueTypeField = $('#InventoryGoodsIssue_issue_type');
        // Reset selection first
        issueTypeField.multiselect('deselectAll', false).multiselect('refresh');
        if (salesGroupId) {
            issueTypeField.multiselect('select', salesGroupId);
        } else {
            // leave blank — no selection
            issueTypeField.multiselect('refresh');
        }
        console.log(window.assignedUser);
        if (typeof window.assignedUser === 'undefined') return;
        console.log(window.assignedUser);
        var leadOwnerId = window.assignedUser[selectedId];
        var leadOwnerField = $('#InventoryGoodsIssue_lead_owner_id');
        // Reset selection first
        leadOwnerField.multiselect('deselectAll', false).multiselect('refresh');
        if (leadOwnerId) {
            leadOwnerField.multiselect('select', leadOwnerId);
        } else {
            // leave blank — no selection
            leadOwnerField.multiselect('refresh');
        }
        getMachineDetailsList();
    }
</script>