<?php

class ScheduleController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'login', 'error', 'logout'
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated users with isMember() to perform 'index' and 'create'
                'actions' => array('index', 'create', 'getlist', 'GetCustomerMachines', 'Save', 'printSchedule', 'isComplated', 'getCustomerShippingdetails', 'Getmachinedetails', 'getLocationdetails', 'GetLocationdetailsAjax', 'MarkasComplete'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionCreate()
    {
        $model = new SaleRepairRequest();
        $modelMachine = array(new SalesRepairRequestItem);
        $id = (int) Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $condition = '';

            if ($type == 'C') {
                $condition = ' AND is_completed != "Y" AND status_id != "2"';
            }

            $modelMachine = SalesRepairRequestItem::model()
                ->with('machine')
                ->findAll(array(
                    'condition' => 'header_id = "' . $id . '"' . $condition,
                ));

            if (empty($modelMachine)) {
                $modelMachine = array(new SalesRepairRequestItem());
            }
        }

        if (isset($_REQUEST['customer_id']) && !empty($_REQUEST['customer_id'])) {
            $model->customer_id = $_REQUEST['customer_id'];
            $custModel = Customer::model()->findByPk($_REQUEST['customer_id']);
            $model->customer_name = $custModel->customer_name;
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('create', array('model' => $model, 'modelMachine' => $modelMachine, 'type' => $type), false, true);
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    public function actionGetList()
    {
        $model = new SaleRepairRequest();

        $draw = isset($_POST['draw']) ? (int) $_POST['draw'] : 1;
        $offset = isset($_POST['start']) ? (int) $_POST['start'] : 0;
        $limit = isset($_POST['length']) ? (int) $_POST['length'] : 10;
        $user_id = isset($_POST['user_id']) ? (int) $_POST['user_id'] : 0;
        $status_id = isset($_POST['status_id']) ? (int) $_POST['status_id'] : 0;
        $schedule_date = isset($_POST['schedule_date']) ? $_POST['schedule_date'] : '';
        $request_date = isset($_POST['request_date']) ? $_POST['request_date'] : '';

        $columns = [
            0 => 't.id',
            1 => 'sales_cust.customer_name',
            2 => 't.schedule_date',
            3 => 'status.status_name'
        ];

        $orderColumnIndex = isset($_POST['order'][0]['column']) ? (int) $_POST['order'][0]['column'] : 0;
        $orderDirection = isset($_POST['order'][0]['dir']) ? strtolower($_POST['order'][0]['dir']) : 'asc';
        $orderDirection = $orderDirection === 'desc' ? 'desc' : 'asc';
        $filterColumn = isset($columns[$orderColumnIndex]) ? $columns[$orderColumnIndex] : 't.id';
        $orderBy = 't.id desc';

        $condition = "1=1";

        // Restrict data by user permissions
        if (Yii::app()->user->authorised_user != 1) {
            $condition .= " AND (t.assigned_id = " . (int) Yii::app()->user->id . " OR t.created_by = " . (int) Yii::app()->user->id . ")";
        }

        if ($user_id > 0) {
            $condition .= " AND t.assigned_id = {$user_id}";
        }


        if ($status_id > 0) {
            $condition .= " AND t.status_id = {$status_id}";
        }

        if (!empty($schedule_date)) {
            $schedule_date = addslashes($schedule_date);
            $condition .= " AND (t.schedule_date = '{$schedule_date}')";
        }

        if (!empty($request_date)) {
            $request_date = addslashes($request_date);
            $condition .= " AND (t.request_date = '{$request_date}')";
        }

        // echo $condition;
        // Search filter
        if (!empty($_POST['search']['value'])) {
            $search = trim($_POST['search']['value']);
            $condition .= " AND (
            sales_cust.customer_name LIKE :search 
            OR sales_cust.customer_phone_no LIKE :search
            OR t.remark LIKE :search
        )";
        }

        $count = $model->with(['sales_cust', 'status'])->count([
            'condition' => $condition,
            'params' => !empty($search) ? [':search' => "%$search%"] : []
        ]);

        $records = $model->with(['sales_cust', 'status'])->findAll([
            'condition' => $condition,
            'params' => !empty($search) ? [':search' => "%$search%"] : [],
            'limit' => $limit,
            'offset' => $offset,
            'order' => $orderBy,
        ]);

        $rowData = [];
        $m = 1;
        foreach ($records as $key => $row) {
            if ($row->request_from != 'MI') {
                $scheduleDate = (!empty($row->schedule_date) && $row->schedule_date != '0000-00-00')
                    ? date('d/m/Y', strtotime($row->schedule_date))
                    : '';
            } else {
                $scheduleDate = '';
            }

            $actualDate = (!empty($row->completed_date) && $row->completed_date != '0000-00-00')
                ? date('d/m/Y', strtotime($row->completed_date))
                : (!empty($row->completed_date_time && $row->completed_date_time != '0000-00-00 00:00:00') ? date('d/m/Y', strtotime($row->completed_date_time)) : '');



            $statusIcon = '';

            if ($row->status->name == 'Completed') {
                $statusIcon = '<img src="uploads/correct.png" height="20" width="20" title="Completed" style="color:red;"/>';
            } elseif ($row->status->name == 'Pending') {
                $statusIcon = '<img src="uploads/stop.png" height="20" width="20" title="Pending"/>';
            } elseif ($row->status->name == 'Working') {
                $statusIcon = '<img src="uploads/tools.png" height="20" width="20" title="Working"/>';
            }
            $assigned_to = (!empty($row->assigned_id) && $row->assigned) ? $row->assigned->first_name . ' ' . $row->assigned->last_name : '';

            $rowData[] = [
                $m++, // 0 => slno
                CHtml::encode($row->sales_cust->customer_name), // 1=>customer name
                CHtml::encode($row->service ? $row->service->name : ''), // 2 => service type
                $scheduleDate, // 3=> planned date
                $actualDate, // 4=> actual date
                $assigned_to, //  5 = > status icons
                $statusIcon, //  6 = > status icons
                json_encode(['customer_id' => $row->customer_id, 'type_id' => $row->type_id, 'status' => $row->status->name, 'id' => $row->id]) // 7=> array
            ];
        }

        echo json_encode([
            'draw' => $draw,
            'recordsTotal' => $count,
            'recordsFiltered' => $count,
            'data' => $rowData
        ]);
    }




    public function actionGetCustomerMachines()
    {
        $searchTerm = Yii::app()->request->getParam('term', '');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');

        if (empty($customer_id)) {
            echo CJSON::encode([]);
            Yii::app()->end();
        }

        $criteria = new CDbCriteria();
        $criteria->alias = 's';
        $criteria->select = '
        s.id,
        s.serial_no,
        s.product_id,
        s.product_name,
        s.product_description,
        s.brand_name,
        s.warehouse_name,
        s.rack_name,
        s.bin_name,
        s.unit_name,
        s.quantity,
        s.transaction_type,
        s.transaction_date
    ';

        // ✅ Combine all conditions properly
        $criteria->condition = "
        s.transaction_from LIKE :transaction_from 
        AND s.transaction_type = :transaction_type 
        AND s.customer_vendor_id = :customer_id 
        AND s.serial_no != ''
    ";
        $criteria->params = [
            ':transaction_from' => 'GOODS_ISSUE',
            ':transaction_type' => 'OUT',
            ':customer_id' => $customer_id
        ];

        // Optional search term filter
        if (!empty($searchTerm)) {
            $criteria->addSearchCondition('s.serial_no', $searchTerm, true, 'AND');
        }

        $criteria->order = 's.serial_no ASC';
        $criteria->limit = 50;

        // Fetch data
        $machines = StockLedger::model()->findAll($criteria);

        $data = [];
        foreach ($machines as $machine) {
            $data[] = [
                'value' => $machine->id,
                'label' => $machine->product_name,
                'stockledger_id' => $machine->id,
                'serial_no' => $machine->serial_no,
                'product_id' => $machine->product_id,
                'product_name' => $machine->product_name,
                'product_description' => $machine->product->description,
                'brand_name' => $machine->brand_name,
                'warehouse_name' => $machine->warehouse_name,
                'rack_name' => $machine->rack_name,
                'bin_name' => $machine->bin_name,
                'unit_name' => $machine->unit_name,
                'quantity' => $machine->quantity,
                'transaction_type' => $machine->transaction_type,
                'transaction_date' => $machine->transaction_date,
            ];
        }

        echo CJSON::encode($data);
        Yii::app()->end();
    }


    public function actionSave()
    {

        // die;
        try {
            $postData = $_POST['SaleRepairRequest'] ?? [];
            $itemData = $_POST['SalesRepairRequestItem'] ?? [];

            if (empty($postData)) {
                echo CJSON::encode(['status' => 'error', 'message' => ['Invalid request data']]);
                Yii::app()->end();
            }

            // --- HEADER SAVE / FIND ---
            if (!empty($postData['id']) && (int) $postData['id'] > 0) {
                $model = SaleRepairRequest::model()->findByPk((int) $postData['id']);
                if (!$model) {
                    echo CJSON::encode(['status' => 'error', 'message' => ['Record not found']]);
                    Yii::app()->end();
                }
            } else {
                $model = new SaleRepairRequest();
                $model->created_by = Yii::app()->user->id;
            }

            // --- ASSIGN HEADER ATTRIBUTES ---
            $model->attributes = $postData;
            $model->customer_shipping_id = $postData['customer_shipping_id'] ?? null;
            $model->type_id = 2;
            $model->status_id = 3;
            $model->service_id = $postData['service_id'];
            $model->schedule_status = 'M';
            $model->completed_date = DateModel::toSqlDate($postData['completed_date'] ?? null);
            $model->schedule_date = DateModel::toSqlDate($postData['schedule_date'] ?? null);
            $model->start_time = date('Y-m-d H:i:s');

            if (!empty($postData['request_date'])) {
                $model->request_date = date('Y-m-d', strtotime(str_replace('/', '-', $postData['request_date'])));
            }

            // --- VALIDATE HEADER ---
            if (!$model->validate()) {
                echo CJSON::encode(['status' => 'error', 'message' => $model->getErrors()]);
                Yii::app()->end();
            }

            // --- SAVE HEADER ---
            if (!$model->save()) {
                echo CJSON::encode(['status' => 'error', 'message' => $model->getErrors()]);
                Yii::app()->end();
            }

            $header_id = $model->id;

            // --- FILTER ONLY CHECKED ITEMS ---
            $selectedItems = [];
            foreach ($itemData as $item) {
                if (isset($item['selected'])) { // checkbox is checked
                    $selectedItems[] = $item;
                }
            }


            // print_r($selectedItems);
            // die;
            if (empty($selectedItems)) {
                echo CJSON::encode([
                    'status' => 'error',
                    'message' => ['item_error' => ['Please select at least one machine.']]
                ]);
                Yii::app()->end();
            }

            // --- SAVE ONLY SELECTED ITEMS ---
            $existingItems = CHtml::listData(
                SalesRepairRequestItem::model()->findAllByAttributes(['header_id' => $header_id]),
                'id',
                'id'
            );

            $savedItemIds = [];

            foreach ($selectedItems as $item) {

                $item_id = isset($item['id']) ? (int) $item['id'] : 0;

                if ($item_id > 0) {
                    $modelItem = SalesRepairRequestItem::model()->findByPk($item_id);
                    if (!$modelItem)
                        continue;
                } else {
                    $modelItem = new SalesRepairRequestItem();
                    $modelItem->header_id = $header_id;
                }

                // Assign attributes
                $modelItem->machine_id = (int) ($item['machine_id'] ?? null);
                $modelItem->serial_no = $item['serial_no'] ?? null;
                $modelItem->fragrance_id = $item['fragrance_id'] ?? null;
                $modelItem->new_fragrance_id = $item['new_fragrance_id'] ?? null;
                $modelItem->service_type = $item['service_type'] ?? null;
                $modelItem->liquid_id = $item['liquid_id'] ?? null;
                $modelItem->status_id = 3;
                $modelItem->service_id = (int) ($item['service_id'] ?? null);
                $modelItem->location_id = (int) ($item['location_id'] ?? null);
                $modelItem->remark = trim($item['remark'] ?? '');
                $modelItem->date = $model->schedule_date;

                if (!$modelItem->save()) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => ['item_error' => ['Failed to save item: ' . json_encode($modelItem->getErrors())]]
                    ]);
                    Yii::app()->end();
                }

                $savedItemIds[] = $modelItem->id;
            }

            // --- DELETE UNSELECTED ITEMS ---
            $toDelete = array_diff($existingItems, $savedItemIds);
            if (!empty($toDelete)) {
                $criteria = new CDbCriteria();
                $criteria->addInCondition('id', $toDelete);
                SalesRepairRequestItem::model()->deleteAll($criteria);
            }

            // --- SUCCESS ---
            echo CJSON::encode([
                'status' => 'success',
                'message' => 'Saved successfully',
                'id' => $header_id
            ]);
            Yii::app()->end();

        } catch (Exception $e) {
            echo CJSON::encode(['status' => 'error', 'message' => $e->getMessage()]);
            Yii::app()->end();
        }
    }




    public function actionprintSchedule()
    {
        $model = new SaleRepairRequest();
        $id = (int) Yii::app()->request->getParam('id');
        $type = (int) Yii::app()->request->getParam('type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if ($type == 2) {
            $page = "print_customer_wise";
        } else {
            $page = "print";
        }
        $mPDF1->WriteHTML($this->renderPartial($page, array('id' => $id), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionIsComplated()
    {
        $machineIds = Yii::app()->request->getParam('machine_id', []);
        $serialNos = Yii::app()->request->getParam('serial_no', []);
        $headerId = Yii::app()->request->getParam('header_id');
        $customerId = Yii::app()->request->getParam('customer_id');
        if (empty($machineIds) || !$headerId) {
            echo CJSON::encode(['status' => 'fail', 'message' => 'Invalid parameters.']);
            Yii::app()->end();
        }

        $transaction = Yii::app()->db->beginTransaction();
        try {
       

            // ✅ 1. Mark the selected SalesRepairRequestItem records as completed
            $criteriaItems = new CDbCriteria();
            $criteriaItems->addInCondition('id', $machineIds);
            $criteriaItems->addCondition('header_id = :headerId');
            $criteriaItems->params[':headerId'] = $headerId;

            SalesRepairRequestItem::model()->updateAll(
                ['is_completed' => 'Y', 'status_id' => 2],
                $criteriaItems
            );

            // echo 'hii';

            // ✅ 2. If all items under this header are completed, update the main SaleRepairRequest
            $remainingItems = SalesRepairRequestItem::model()->count(
                'header_id = :headerId AND is_completed != "Y"',
                [':headerId' => $headerId]
            );

            if ($remainingItems == 0) {
                $saleRequest = SaleRepairRequest::model()->findByPk($headerId);
                if ($saleRequest) {
                    $saleRequest->status_id = 2; // Completed
                    $saleRequest->is_Visited = 'Y';
                    $saleRequest->schedule_status = 'C';
                    $saleRequest->copy_id = 0;
                    $saleRequest->end_time = date('Y-m-d H:i:s');
                    $saleRequest->completed_date = date('Y-m-d');
                    $saleRequest->save(false);

                    // ✅ 4. Update Customer last service info
                    $modelCust = Customer::model()->findByPk($saleRequest->customer_id);
                    if ($modelCust) {
                        $modelCust->last_service = date('Y-m-d');
                        $modelCust->last_service_emp = $saleRequest->assigned_id;
                        $modelCust->active_request = 'N';
                        $modelCust->save(false);
                    }
                }
            }

            $transaction->commit();
            echo CJSON::encode(['status' => 'success']);
        } catch (Exception $e) {
            $transaction->rollback();
            echo CJSON::encode(['status' => 'fail', 'message' => $e->getMessage()]);
        }
    }






    public function actiongetCustomerShippingdetails()
    {
        $id = Yii::app()->request->getparam("id");
        $models = CustomerOutletLocation::getShippingLocation($id);
        $drop = '<li class="col-sm-3">';
        $model = new SaleRepairRequest;
        $drop .= CHtml::activedropDownList($model, 'customer_shipping_id', $models, array('class' => 'tooltipster', 'title' => 'Please Select Outlet', 'data-label' => 'Outlet Location', 'data-search' => true, 'onchange' => 'machinedetails()'));
        $drop .= '</li>';
        $status = array("dt" => $drop);
        echo CJSON::encode($status);
    }

    public function actionGetmachinedetails()
    {
        $customer = (int) $_POST['id'];
        $outlet = (int) $_POST['outlet_id'];
        $modelrepair = new SalesRepairRequestItem();

        // 1️⃣ Get all header records for this customer/outlet
        $criteria = new CDbCriteria();
        $criteria->addCondition('customer_id = :customer');
        $criteria->params[':customer'] = $customer;
        $criteria->addCondition('isActive = "Y"');
        $criteria->addCondition('return_stock_ledger_id = 0');

        if ($outlet > 0) {
            $criteria->addCondition('customer_shipping_id = :outlet');
            $criteria->params[':outlet'] = $outlet;
        }

        $headers = ServiceMasCustomerMachines::model()->findAll($criteria);
        $headerIds = array_map(fn($h) => $h->id, $headers);
        $items = [];
        if (!empty($headerIds)) {
            $criteriaItems = new CDbCriteria();
            $criteriaItems->addInCondition('header_id', $headerIds);
            $criteriaItems->addCondition('is_active = "Y"');
            $items = ServiceMasCustomerMachinesItem::model()->findAll($criteriaItems);
        }
        Yii::app()->clientScript->scriptMap = [
            '*jquery.js' => false,
            '*jquery.min.js' => false,
            'jquery.min.js' => false,
            '*jquery-ui.js' => false,
            '*jquery-ui.min.js' => false,
            'jquery-2.1.4.js' => false
        ];

        $this->render('request_machine_details', [
            'modelrepair' => $modelrepair,
            'modelmachine' => $items, // <-- now this is the item list, not headers
        ], false, true);
    }


    public function actiongetLocationdetails()
    {
        $id = Yii::app()->request->getparam("id");
        $outlet = Yii::app()->request->getparam("outlet_id");
        $index = 0;
        $models = ServiceCustomerLocation::getLocationCustomerByOutlet($id, $outlet);
        // $drop = '<li class="col-sm-3">';
        $model = new SalesRepairRequestItem;
        $drop = CHtml::activedropDownList($model, "[$index]location_id", $models, array('class' => 'tooltipster form-control', 'title' => 'Please Select Location', 'data-label' => 'Outlet Location', 'data-search' => true));
        // $drop .= '</li>';
        $status = array("dt" => $drop);
        echo CJSON::encode($status);
    }

    public function actionGetLocationdetailsAjax()
    {
        // Get request parameters safely
        $customerId = Yii::app()->request->getParam('customer');
        $outletId = Yii::app()->request->getParam('outlet_id');

        // Get location list (should return an array like [id => name])
        $locations = ServiceCustomerLocation::getLocationCustomerByOutlet($customerId, $outletId);

        // Return JSON response
        header('Content-Type: application/json');
        echo CJSON::encode($locations);
        Yii::app()->end();
    }


    public function actionMarkasComplete()
    {
        $id = Yii::app()->request->getPost('id');
        $customer_id = Yii::app()->request->getPost('customer_id');
        $customer_name = Yii::app()->request->getPost('customer_name');

        if (empty($id)) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid request.']);
            Yii::app()->end();
        }

        $model = SaleRepairRequest::model()->findByPk((int) $id);
        // print_r($model);
        if (!$model) {
            echo json_encode(['status' => 'error', 'message' => 'Record not found.']);
            Yii::app()->end();
        }

        try {
            $model->is_completed = 'Y';
            $model->is_Visited = 'Y';
            $model->status_id = '2';
            $model->completed_by = Yii::app()->user->id;
            $model->completed_date_time = date('Y-m-d H:i:s');
            $model->completed_date = date('Y-m-d');

            if ($model->save(false)) {
                echo json_encode([
                    'status' => 'success',
                    'message' => 'Service request marked as completed successfully.'
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Failed to update the record.'
                ]);
            }
        } catch (Exception $e) {
            echo json_encode([
                'status' => 'error',
                'message' => 'An error occurred: ' . $e->getMessage()
            ]);
        }

        Yii::app()->end();
    }


}