<?php

class MasServicesController extends Controller
{
    public function accessRules()
    {
        return array(
            array('allow',
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow',
                'actions' => array('Index','Create','GetServicesList','SaveService','DeleteService','Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny',
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array('accessControl');
    }

    public function actionIndex()
    {
        if (Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['masters_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['sales_master_service_view']) &&
                Yii::app()->user->havePermissionOn['masters_menu_view'] &&
                Yii::app()->user->havePermissionOn['sales_master_service_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end();
        }
    }

    public function actionCreate()
    {
        $model = new MasServices();
        $id = (int) Yii::app()->request->getParam('id');
        $from = Yii::app()->request->getParam('from');

        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array(
            '*jquery.js' => false,
            '*jquery.min.js' => false,
            '*jquery-ui.js' => false,
            '*jquery-ui.min.js' => false,
            'jquery.min.js' => false,
            'jquery-2.1.4.min.js' => false
        );

        $this->render('create', array('model' => $model, 'from' => $from), false, true);
    }

    public function actionGetServicesList()
    {
        $model = new MasServices();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];

        $columns = array(
            0 => 'code',
            1 => 'name',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (code LIKE '%" . $searchString . "%' OR name LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $data = array();
        $data['draw'] = $draw;
        $data['recordsTotal'] = $count;
        $data['recordsFiltered'] = $count;

        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_master_service_add_edit"])) {
                // edit button (you can uncomment later)
                // $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'masservices/create&id=' . $row['id'] . '\',\'Edit Service\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_master_service_delete"])) {
                // delete button (you can uncomment later)
                // $div .= ' <a href="#" class="btn btn-danger btn-xs" onclick="deleteService(' . $row['id'] . ')"><i class="fa fa-trash-o"></i></a>';
            }

            $rowData[] = array(
                $m,
                $row['code'],
                $row['name'],
                array('id' => $row['id'], 'status' => $row->isActive)
            );
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionSaveService()
    {
        $model = new MasServices();

        if (isset($_POST['MasServices'])) {
            $id = (int) @$_POST['MasServices']['id'];

            if ($id > 0) {
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $audit_type = 'CREATED';
            }

            $model->attributes = $_POST['MasServices'];

            if ($model->validate()) {
                $model->save();

                // Audit Log
                AuditLog::saveAuditLogs(
                    'SERVICES_MASTER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with code: - {$model->code}, name: - {$model->name}"
                );

                echo CJSON::encode(array(
                    'status' => 'success',
                    'id' => $model->id,
                    'from' => $_POST['from'],
                ));
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }

    public function actionDeleteService()
    {
        $id = (int) $_POST['id'];
        $model = MasServices::model()->findByPk($id);

        if ($model) {
            $model->delete();

            // Audit Log
            AuditLog::saveAuditLogs(
                'SERVICES_MASTER',
                Yii::app()->user->id,
                'DELETED',
                " with code: - {$model->code}, name: - {$model->name}"
            );

            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionDisable()
    {
        $id = Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');

        $model = MasServices::model()->findByPk($id);
        $model->isActive = ($status == "Y") ? "N" : "Y";
        $model->save();

        echo json_encode(array("status" => "success"));
    }
}
