<?php

class InventorygoodsreceiptController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetList',
                    'Create',
                    'getCustomerShippingdetailsReturn',
                    'getReturnMachines',
                    'ReturnMachineMultiple',
                    'View',
                    'getReturnMachinesByLeadOwner',







                    //'ReturnMachine',

                    
                    //'GetInvoiceDropdown',
                    //'getCustomerShippingdetails',
                    //'getOutletLocationDetails',
                    //'GetLeadownerMachineDetails',
                    //'GetLeadownerMachineDetailsbyserailNo',
                    //'Save',


                    //'ReturnIndex',
                    //'GetReturnList',
                    //'CreateReturn',
                    
                    //'GetMachineserailNumbersonly',
                    //'GetMachineDetails',
                    //'GetLeadownerMachineSerialnoDetails',
                    //'getCustomerShippingdetailsReturn',
                    
                    
                    //'returnForm',
                    
                    
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public $title = "Service Customer Machine";
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    public function actionGetList()
    {
        $model = new InventoryGoodsReceiptItem();
        $draw = (int) $_POST['draw'];
        $offset = (int) $_POST['start'];
        $limit = (int) $_POST['length'];
        $columns = [
            0 => 't.id',
            1 => 'inventorygoodsreceipt.customer_id',
            2 => 'inventorygoodsreceipt.lead_owner_id',
            3 => 'inventorygoodsreceipt.outlet_id',
            4 => 't.serial_no',
            5 => 't.product_name',
        ];
        $orderColumnIndex = (int) $_POST['order'][0]['column'];
        $orderDirection = $_POST['order'][0]['dir'] === 'desc' ? 'DESC' : 'ASC';
        $orderBy = 't.id DESC';
        $condition = " inventorygoodsreceipt.receipt_type = 'MH'  ";
        if (Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (inventorygoodsreceipt.lead_owner_id = "' . Yii::app()->user->id . '" OR t.created_by = "' . Yii::app()->user->id . '")';
        }
        $params = array();
        if (!empty($_POST['search']['value'])) {
            $search = trim($_POST['search']['value']);
            $condition .= " AND (t.serial_no LIKE :search)";
            $params[':search'] = '%' . $search . '%';
        }
        $criteria = new CDbCriteria;
        $criteria->condition = $condition;
        $criteria->params = $params;
        $criteria->limit = $limit;
        $criteria->offset = $offset;
        $criteria->order = $orderBy;
        $criteria->with = array('inventorygoodsreceipt');//inventorygoodsreceipt
        $criteria->together = true;
        $recordsTotal = $model->count($criteria);
        $rows = $model->findAll($criteria);
        $data = array();
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsTotal;
        $rowData = array();
        $m = 1;
        foreach ($rows as $row) {
            $buttons = '<button class="btn btn-primary btn-xs" onclick="viewReturn(' . $row->inventorygoodsreceipt->id . ')"><i class="fa fa-eye"></i></button>';
            //$sales_group_id = Order::model()->findByPk($row->reference_id)->sales_group_id;
            $rowData[] = array(
                $m,
                isset($row->inventorygoodsreceipt->customer_id) ? $row->inventorygoodsreceipt->customer->customer_name : '',
                isset($row->inventorygoodsreceipt->lead_owner_id) ? $row->inventorygoodsreceipt->owner->first_name . ' ' . $row->inventorygoodsreceipt->owner->last_name : '',
                isset($row->inventorygoodsreceipt->outlet_id) ? $row->inventorygoodsreceipt->outlet->outlet_location : '',
                isset($row->serial_no) ? $row->serial_no : '',
                isset($row->product_name) ? $row->product_name : '',
                //isset($sales_group_id) ? MasSalesGroup::model()->findByPk($sales_group_id)->group_name: '',
                '<div class="btn-wrap">' . $buttons . '</div>',
                $row->inventorygoodsreceipt->isActive,
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryGoodsReceipt();
        $modelIssueItem = [new InventoryGoodsReceiptItem()];
        if ($id > 0) {
            $existingModel = InventoryGoodsReceipt::model()->findByPk($id);
            if ($existingModel !== null) {
                $model = $existingModel;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }
            // ✅ Fetch only items not yet returned (return_stock_ledger_id = 0)
            $criteria = new CDbCriteria();
            $criteria->addCondition('goods_receipt_id = :header_id');
            //$criteria->addCondition('return_stock_ledger_id = 0');
            $criteria->params = [':header_id' => $id];
            $existingIssueItems = InventoryGoodsReceiptItem::model()->findAll($criteria);
            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }
        Yii::app()->clientScript->scriptMap = ['*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false ];
        // ✅ Render partial view
        $this->renderPartial('create', [ 'model' => $model, 'modelIssueItem' => $modelIssueItem, 'type' => $type ], false, true);
    }

    public function actiongetCustomerShippingdetailsReturn()
    {
        $id = Yii::app()->request->getparam("id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $model = new InventoryGoodsIssue();
        $models = CustomerOutletLocation::getShippingLocation($id);
        $drop = '<li class="col-sm-4">';
        $drop .= CHtml::activedropDownList($model, "outlet_id", $models, array('class' => '', 'title' => 'Please Select Outlet', 'data-label' => 'Outlet Location', 'data-search' => true, 'empty' => '--Choose Outlet--'));
        $drop .= '</li>';
        $status = array("dtship" => $drop);
        echo CJSON::encode($status);
    }

    public function actionGetReturnMachines()
    {
        $customer_id = Yii::app()->request->getPost('InventoryGoodsReceipt')['customer_id'] ?? null;
        $outlet_id = (int) Yii::app()->request->getPost('outlet_id') ?? null;
        // $lead_owner_ids = Yii::app()->request->getPost('InventoryGoodsReceipt')['lead_owner_id'] ?? [];

        // if (empty($customer_id) || empty($lead_owner_ids)) {
        //     echo "<div class='alert alert-warning'>Please select both Customer and at least one Lead Owner.</div>";
        //     Yii::app()->end();
        // }

        $criteria = new CDbCriteria();
        $criteria->alias = 't';
        $criteria->addCondition('is_issued = :is_issued');
        $criteria->params[':is_issued'] = 'Y';
        $criteria->addCondition('inventorygoodsissue.issue_type = :issue_type');
        $criteria->params[':issue_type'] = "MH";
        $criteria->addCondition('inventorygoodsissue.customer_id = :customer_id');
        $criteria->params[':customer_id'] = $customer_id;
        if ($outlet_id > 0) {
            $criteria->addCondition('inventorygoodsissue.outlet_id = :outlet_id');
            $criteria->params[':outlet_id'] = $outlet_id;
        }
        // ✅ Handle multiple lead owners
        // $criteria->addInCondition('t.lead_owner_id', (array) $lead_owner_ids);
        //$criteria->addCondition('t.return_stock_ledger_id = 0');
        $criteria->with = ['inventorygoodsissue', 'location'];
        $criteria->group = 'inventorygoodsissue.id, t.product_id';
        $machineList = InventoryGoodsIssueItem::model()->findAll($criteria);
        if (empty($machineList)) {
            echo "<div class='alert alert-info'>No machines available for return under this customer and selected lead owner(s).</div>";
            Yii::app()->end();
        }
        $form = new CActiveForm(); // reuse form helpers
        $this->renderPartial('return_machine_table', [ 'machineList' => $machineList, 'form' => $form ], false, true);
    }

    public function actionReturnMachineMultiple()
    {
        $model = new InventoryGoodsReceipt();
        if (!isset($_POST['InventoryGoodsReceipt'])) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid request.']);
            Yii::app()->end();
        }
        $model->attributes = $_POST['InventoryGoodsReceipt'];
        $customer_name = $_POST['InventoryGoodsReceipt']['customer_name'];
        $model_id = $_POST['InventoryGoodsReceipt']['id'];
        $customer_id = (int) $model->customer_id;
        $lead_owner_ids = (array) ($_POST['InventoryGoodsReceipt']['lead_owner_id'] ?? []);
        $lead_owner_id = (int) ($_POST['InventoryGoodsReceipt']['lead_owner_id'] ?? '');
        $outlet_id = $_POST['InventoryGoodsIssue']['outlet_id'];
        $selectedItems = $_POST['InventoryGoodsReceiptItem'] ?? [];
        if (!$customer_name) {
            echo CJSON::encode(['status' => 'error', 'message' => 'No customer selected for return.']);
            Yii::app()->end();
        }
        if (!$lead_owner_id) {
            echo CJSON::encode(['status' => 'error', 'message' => 'No user selected for return.']);
            Yii::app()->end();
        }
        if (!$outlet_id) {
            echo CJSON::encode(['status' => 'error', 'message' => 'No outlet selected for return.']);
            Yii::app()->end();
        }
        if (($selectedItems)) {
            $itemSelected = false;
            foreach ($selectedItems as $id => $item) {
                if (($item['selected'])) {
                    $itemSelected = true;
                    continue;
                }
            }
            if (empty($itemSelected)) {
                echo CJSON::encode(['status' => 'error', 'message' => 'No machines selected for return.']);
                Yii::app()->end();
            }
        } else {
            echo CJSON::encode(['status' => 'error', 'message' => 'No machines selected for return.']);
            Yii::app()->end();
        }
        // Get warehouse (return location)
        $warehouse = MasInventoryWarehouse::model()->getWarehouseIdByCode('RUW');
        $warehouseName = MasInventoryWarehouse::model()->getWarehouseName($warehouse);
        if (!$warehouse) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Return warehouse not configured (RUW missing).']);
            Yii::app()->end();
        }
        $rack = new MasInvRack();
        $bin = new MasInvBin();
        $defaultRackId = $rack->getDefaultRackId();
        $defaultBinId = $bin->getDefaultBinId();


        $modelReceipt = new InventoryGoodsReceipt();
        $modelReceipt->goods_receipt_date = date('Y-m-d');
        //$modelReceipt->file_id = $model->file_id;
        $modelReceipt->customer_id = $customer_id;
        $modelReceipt->warehouse_id = $warehouse;
        $modelReceipt->outlet_id = $outlet_id;
        $modelReceipt->reference = 'MACHINE_RETURN';
        $modelReceipt->receipt_type = 'MH';
        $modelReceipt->reference_id = $model->reference_id;
        $modelReceipt->lead_owner_id = $lead_owner_id;
        $modelReceipt->created_by = Yii::app()->user->id;
        $modelReceipt->created_date_time = date('Y-m-d H:i:s');
        if (!$modelReceipt->save(false)) {
            echo '<pre>';
            print_r($modelReceipt->getErrors());
            echo '</pre>';
            Yii::app()->end();
        }
        foreach ($selectedItems as $id => $item) {
            $modelReceiptItem = new InventoryGoodsReceiptItem();
            if (empty($item['selected'])) {
                continue;
            }
            $machineModel = InventoryGoodsIssueItem::model()->findByPk($id);
            if (!$machineModel) {
                echo CJSON::encode(['status' => 'error', 'message' => "Machine record not found for item ID {$id}."]);
                Yii::app()->end();
            }
            $machineModel->updateByPk($machineModel->id, [
                'is_issued' => 'N',
                'updated_by' => Yii::app()->user->id,
                'updated_date_time' => date('Y-m-d H:i:s'),
            ]);
            // if ($machineModel->return_stock_ledger_id > 0) {
            //     echo CJSON::encode(['status' => 'error', 'message' => "Machine serial <b>{$machineModel->serial_no}</b> already returned."]);
            //     Yii::app()->end();
            // }
            
            $SQL = 'SELECT id FROM `erp_stock_ledger` WHERE serial_no = "' . $machineModel->serial_no .'" ORDER BY master_stock_ledger_id DESC LIMIT 1 ';
            $stock_ledger_id = Yii::app()->db->createCommand($SQL)->queryScalar();
            $existingLedger = StockLedger::model()->findByPk($stock_ledger_id);
            if (!$existingLedger) {
                echo CJSON::encode(['status' => 'error', 'message' => "No stock ledger found for machine <b>{$machineModel->serial_no}</b>."]);
                Yii::app()->end();
            }
            $remarks = trim($item['return_remarks']) ? trim($item['return_remarks']) : 'MACHINE_RETURN/'.$machineModel->goods_issue_id.'/'.$existingLedger->customer_vendor_name;
            $return_lead_owner_id = (int) ($item['return_lead_owner_id'] ?? 0);
            if (empty($return_lead_owner_id) && !empty($lead_owner_ids)) {
                $return_lead_owner_id = reset($lead_owner_ids);
            }
            $modelReceiptItem->product_id = $machineModel->product_id;
            $modelReceiptItem->product_name = $machineModel->product_name;
            $modelReceiptItem->description = $machineModel->description;
            $modelReceiptItem->serial_no = $machineModel->serial_no;
            $modelReceiptItem->unit = $machineModel->unit;
            $modelReceiptItem->rate = $machineModel->rate;
            $modelReceiptItem->picked_qty = $machineModel->picked_qty;
            $modelReceiptItem->location_id = $machineModel->location_id;
            $modelReceiptItem->goods_receipt_id = $modelReceipt->id;
            $modelReceiptItem->created_by = Yii::app()->user->id;
            $modelReceiptItem->created_date_time = date('Y-m-d H:i:s');
            if (!$modelReceiptItem->save(false)) {
                echo '<pre>';
                print_r($modelReceiptItem->getErrors());
                echo '</pre>';
                Yii::app()->end();
            }
            // Create stock ledger entry (IN - Return)
            $stock = new StockLedger();
            $stock->attributes = [
                'file_id' => $modelReceipt->id,
                'header_id' => $modelReceipt->id,
                'header_item_id' => $modelReceiptItem->id,
                'customer_vendor_id' => $existingLedger->customer_vendor_id,
                'customer_vendor_name' => $existingLedger->customer_vendor_name,
                'product_id' => $machineModel->product_id,
                'product_name' => $machineModel->product_name,
                'product_description' => $machineModel->description,
                'brand_id' => $existingLedger->brand_id,
                'brand_name' => $existingLedger->brand_name,
                'warehouse_id' => $warehouse,
                'warehouse_name' => $warehouseName,
                'rack_id' => $defaultRackId,
                'rack_name' => $rack->getRackName($defaultRackId),
                'bin_id' => $defaultBinId,
                'bin_name' => $bin->getBinName($defaultBinId),
                'unit_id' => $existingLedger->unit_id,
                'unit_name' => $existingLedger->unit_name,
                'unit_factor' => $existingLedger->unit_factor,
                'quantity' => 1,
                'available_status' => 'A',
                'batch_no' => $existingLedger->batch_no,
                'serial_no' => $machineModel->serial_no,
                'cost_price' => 0,
                'transaction_date' => date('Y-m-d'),
                'transaction_from' => 'MACHINE_RETURN',
                'transaction_type' => 'IN',
                'master_stock_ledger_id' => $existingLedger->id,
                'stock_updated' => 'Y',
                'created_by' => Yii::app()->user->id,
                'created_date' => date('Y-m-d H:i:s'),
                'remarks' => $remarks,
                'lead_owner_id' => $return_lead_owner_id,
            ];
            if (!$stock->save(false)) {
                echo CJSON::encode(['status' => 'error', 'message' => "Failed to save return stock for serial <b>{$machineModel->serial_no}</b>."]);
                Yii::app()->end();
            }
            // var_dump($stock->id);
            // Update machine item as returned
            /*$machineModel->updateByPk($machineModel->id, [
                //'return_stock_ledger_id' => $stock->id,
                'description' => $remarks,
                //'returned_by' => $return_lead_owner_id,
                //'returned_date_time' => date('Y-m-d H:i:s'),
            ]);
            // Update header if fully returned
            //'goods_issue_id = :hid AND (return_stock_ledger_id = 0 OR return_stock_ledger_id IS NULL)',
            $pendingCount = InventoryGoodsIssueItem::model()->count(
                'goods_issue_id = :hid',
                [':hid' => $machineModel->goods_issue_id]
            );
            if ($pendingCount == 0) {
                $model->updateByPk($machineModel->goods_issue_id, [
                    // 'is_return_fully' => 'Y',
                    'lead_owner_id' => $return_lead_owner_id,
                    'goods_receipt_date' => date('Y-m-d'),
                    'updated_by' => Yii::app()->user->id,
                    'updated_date' => date('Y-m-d H:i:s'),
                ]);
            }*/
        }
        echo CJSON::encode(['status' => 'success', 'message' => 'Selected machines returned successfully.']);
        Yii::app()->end();
    }

    public function actionView()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryGoodsReceipt();
        $modelIssueItem = [new InventoryGoodsReceiptItem()];
        if ($id > 0) {
            $existingModel = InventoryGoodsReceipt::model()->findByPk($id);
            if ($existingModel !== null) {
                $model = $existingModel;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }
            // ✅ Fetch only items not yet returned (return_stock_ledger_id = 0)
            $criteria = new CDbCriteria();
            $criteria->addCondition('goods_receipt_id = :header_id');
            //$criteria->addCondition('return_stock_ledger_id = 0');
            $criteria->params = [':header_id' => $id];
            $existingIssueItems = InventoryGoodsReceiptItem::model()->findAll($criteria);
            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }
        Yii::app()->clientScript->scriptMap = ['*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false ];
        // ✅ Render partial view
        $this->renderPartial('view', [ 'model' => $model, 'modelIssueItem' => $modelIssueItem, 'type' => $type ], false, true);
    }

    public function actiongetReturnMachinesByLeadOwner()
    {
        $model = new InventoryDirectTransfer();
        $model_items = array(new InventoryDirectTransferItem());
        $warehouse_id = Yii::app()->request->getPost('warehouse_id') ?? null;
        $lead_owner_id = (int) Yii::app()->request->getPost('lead_owner_id') ?? null;
        // $lead_owner_ids = Yii::app()->request->getPost('InventoryGoodsReceipt')['lead_owner_id'] ?? [];

        // if (empty($customer_id) || empty($lead_owner_ids)) {
        //     echo "<div class='alert alert-warning'>Please select both Customer and at least one Lead Owner.</div>";
        //     Yii::app()->end();
        // }

        $criteria = new CDbCriteria();
        $criteria->alias = 't';
        $criteria->addCondition('is_received = :is_received');
        $criteria->params[':is_received'] = 'N';
        $criteria->addCondition('inventorygoodsreceipt.receipt_type = :receipt_type');
        $criteria->params[':receipt_type'] = "MH";
        $criteria->addCondition('inventorygoodsreceipt.warehouse_id = :warehouse_id');
        $criteria->params[':warehouse_id'] = $warehouse_id;
        if ($lead_owner_id > 0) {
            $criteria->addCondition('inventorygoodsreceipt.lead_owner_id = :lead_owner_id');
            $criteria->params[':lead_owner_id'] = $lead_owner_id;
        }
        // ✅ Handle multiple lead owners
        // $criteria->addInCondition('t.lead_owner_id', (array) $lead_owner_ids);
        //$criteria->addCondition('t.return_stock_ledger_id = 0');
        $criteria->with = ['inventorygoodsreceipt', 'location'];
        $criteria->group = 'inventorygoodsreceipt.id, t.product_id';
        $machineList = InventoryGoodsReceiptItem::model()->findAll($criteria);
        if (empty($machineList)) {
            echo "<div class='alert alert-info'>No machines available for return under this customer and selected lead owner(s).</div>";
            Yii::app()->end();
        }
        foreach ($machineList as $mKey => $machine) {
            $modelProduct = Store::model()->findByPk($machine->product_id);
            $model_items[$mKey]->item_id = $machine->product_id;
            $model_items[$mKey]->item_name = $machine->product_name;
            $model_items[$mKey]->item_description = $machine->description;
            $model_items[$mKey]->transfer_qty = $machine->picked_qty;
            $model_items[$mKey]->available_qty = $machine->picked_qty;
            $model_items[$mKey]->unit = $machine->unit;
            $model_items[$mKey]->bar_code = $modelProduct->bar_code;
        }
        $form = new CActiveForm(); // reuse form helpers
        $this->renderPartial('transfer_machine_table', [ 'model' => $model, 'model_items' => $model_items, 'form' => $form ], false, true);
    }































    public function actionCreate1()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryGoodsReceipt();
        $modelIssueItem = [new InventoryGoodsReceiptItem()];
        if ($id > 0) {
            $existingModel = InventoryGoodsReceipt::model()->findByPk($id);
            if ($existingModel !== null) {
                $model = $existingModel;
                $sales_group_id = Order::model()->findByPk($existingModel->production_order_id)->sales_group_id;
                $model->receipt_type = $sales_group_id;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }
            // Condition based on type
            $criteria = new CDbCriteria();
            $criteria->addCondition('goods_issue_id = :goods_issue_id');
            $criteria->params[':goods_issue_id'] = $id;
            /*if ($type === 'returnview') {
                // For view mode → show only returned machines
                $criteria->addCondition('return_stock_ledger_id > 0');
            } else {
                // For other modes → show all or pending return items
                // You can customize this if you only want pending ones
                $criteria->addCondition('return_stock_ledger_id = 0');
            }*/
            $existingIssueItems = InventoryGoodsReceiptItem::model()->findAll($criteria);
            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }
        // Prevent double inclusion of JS
        Yii::app()->clientScript->scriptMap = ['*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false];
        // Render partial with correct data
        $this->renderPartial( 'create', [ 'model' => $model, 'modelIssueItem' => $modelIssueItem, 'type' => $type ], false, true );
    }

    public function actionGetInvoiceDropdown()
    {
        $customer_id = Yii::app()->request->getParam('customer_id');
        $lead_owner_id = Yii::app()->request->getParam('lead_owner_id');
        $type_of_invoice = Yii::app()->request->getParam('type_of_invoice', 'service');
        $row_index = Yii::app()->request->getParam('row_index', 0); // for form indexing
        $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');
        $condition = '1=1';
        if ((int) Yii::app()->user->authorised_user != 1 && $warehouse_id > 0) {
            $condition .= ' AND warehouse_id=' . $warehouse_id;
        }
        if ((int) $customer_id > 0) {
            $condition .= ' AND customer_id=' . $customer_id;
        }
        // if ((int) $lead_owner_id > 0) {
        //     $condition .= ' AND lead_owner_id=' . $lead_owner_id;
        // }
        if (!empty($type_of_invoice)) {
            $condition .= ' AND order_type="' . $type_of_invoice . '"';
        }
        // Fetch invoices
        $modelInvoice = new Order();
        $invoices = $modelInvoice->findAll([
            'select' => 'id,file_id,sales_group_id,lead_owner_id',
            'condition' => $condition,
            'limit' => 200
        ]);
        // Prepare array for dropdown
        $invoiceArray = [];
        $salesGroupMap = [];
        $assignedUser = [];
        foreach ($invoices as $invoice) {
            $invoiceArray[$invoice->id] = $invoice->file_id . ' : ' . $invoice->id;
            $salesGroupMap[$invoice->id] = $invoice->sales_group_id;
            $assignedUser[$invoice->id] = $invoice->lead_owner_id;
        }
        // Create active dropdown
        $model = new InventoryGoodsReceipt(); // or your form model that holds invoice_id
        $dropInvoice = '<li class="col-sm-2">';
        $dropInvoice .= CHtml::activeDropDownList(
            $model,
            "file_id",
            $invoiceArray,
            [
                'empty' => '-Select Order-',
                'class' => 'invoice-dropdown',
                'title' => 'Please select Order',
                'data-label' => 'Service Order',
                'data-search' => true,
                'onChange' => 'getMachineDetailsList();changeType(this)',
            ]
        );
        $dropInvoice .= '</li>';
        echo CJSON::encode(['dropdown' => $dropInvoice, 'sales_groups' => $salesGroupMap, 'assigned_users' => $assignedUser]);
        Yii::app()->end();
    }

    public function actiongetCustomerShippingdetails()
    {
        $id = Yii::app()->request->getparam("id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $model = new InventoryGoodsReceipt();
        $models = CustomerOutletLocation::getShippingLocation($id);
        $drop = '<li class="col-sm-2">';
        $drop .= CHtml::activedropDownList($model, "outlet_id", $models, array('class' => '', 'title' => 'Please Select Outlet', 'data-label' => 'Outlet Location', 'data-search' => true, 'onChange' => 'js:getOutletLocationDetails(this);'));
        $drop .= '</li>';
        $status = array("dtship" => $drop);
        echo CJSON::encode($status);
    }

    public function actiongetOutletLocationDetails()
    {
        $customer_id = Yii::app()->request->getparam("customer_id");
        $outlet_id = Yii::app()->request->getparam("outlet_id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $model = new InventoryGoodsReceiptItem;
        $customerlocationarray = ServiceCustomerLocation::getLocationCustomerByOutlet($customer_id, $outlet_id);
        $droploc = CHtml::activedropDownList($model, "[$row_index]location_id", $customerlocationarray, array('empty' => 'Select', 'class' => 'form-control machine-dropdown', 'title' => 'Please Select Location', 'data-label' => 'Location <span style="color:red">*</span>', 'data-search' => true, 'empty' => '-select-'));
        $status = array("dtloc" => $droploc);
        echo CJSON::encode($status);
    }

    public function actionGetLeadownerMachineDetails()
    {
        $lead_owner_id = Yii::app()->request->getParam("lead_owner_id");
        $customer_id = Yii::app()->request->getParam("customer_id");
        $file_id = Yii::app()->request->getParam("file_id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $filter_text = Yii::app()->request->getParam("filter_text", ''); // optional filter term
        // 1. Get product IDs for this file
        $productIds = OrderItem::getProductIds($file_id);
        // 2. Get all available machine serial numbers
        $leadownermachinearray = StockLedger::getLeadownerMachineSerialnoByleadownerid($productIds, $lead_owner_id);
        // 3. Apply filter if any (case-insensitive search)
        if (!empty($filter_text)) {
            $leadownermachinearray = array_filter($leadownermachinearray, function ($value) use ($filter_text) {
                return stripos($value, $filter_text) !== false;
            });
        }
        // 4. Build dropdown
        $model = new InventoryGoodsReceiptItem;
        $drop = CHtml::activeDropDownList(
            $model,
            "[$row_index]serial_no",
            $leadownermachinearray,
            [
                'empty' => '--Select--',
                'class' => 'form-control machine-dropdown serial-dropdown',
                'title' => 'Please Select Serial No',
                'data-label' => 'Machine Serial No <span style="color:red">*</span>',
                'data-search' => true,
                'onchange' => 'leadownerMachinesdetails(this);',
            ]
        );
        echo CJSON::encode([
            'status' => 'success',
            'dt' => $drop,
        ]);
    }

    public function actionGetLeadownerMachineDetailsbyserailNo()
    {
        $lead_owner_id = Yii::app()->request->getParam("lead_owner_id");
        $serial_id = Yii::app()->request->getParam("serial_id");
        $row_index = Yii::app()->request->getParam("row_index", 0);

        $machineData = StockLedger::getLeadownerMachinebySerialno($serial_id);
        $machineName = '';
        $machineId = '';
        if (!empty($machineData) && is_array($machineData)) {
            // get first key/value pair (product_id => product_name)
            $machineId = key($machineData);
            $machineName = current($machineData);
        }
        // Model instance for indexed form binding
        $model = new InventoryGoodsReceiptItem;
        // readonly text field for display
        $textField = CHtml::activeTextField(
            $model,
            "[$row_index]product_name",
            [
                'class' => 'form-control',
                'title' => 'Machine',
                'data-label' => 'Machine <span style="color:red">*</span>',
                'value' => $machineName,
                'readonly' => true,
            ]
        );
        // hidden field for actual machine_id
        $hiddenField = CHtml::activeHiddenField(
            $model,
            "[$row_index]product_id",
            ['value' => $machineId]
        );
        echo CJSON::encode([
            'status' => 'success',
            'dt' => $textField . $hiddenField, // append both fields
        ]);
    }

    public function actionSave()
    {
        $model = new InventoryGoodsReceipt();
        $valid = true;
        $other = [];
        if (isset($_POST['InventoryGoodsReceipt'])) {
            $id = (int) @$_POST['InventoryGoodsReceipt']['id'];
            $isUpdate = $id > 0;
            if ($isUpdate) {
                $model = InventoryGoodsReceipt::model()->findByPk($id);
                if (!$model) {
                    echo CJSON::encode(['status' => 'error', 'message' => 'Record not found']);
                    Yii::app()->end();
                }
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $audit_type = 'CREATED';
            }
            $model->goods_issue_date = date('Y-m-d');
            $model->receipt_type = 'MH';
            /*** Manual mapping ***/
            $model->customer_id = $_POST['InventoryGoodsReceipt']['customer_id'];
            $model->outlet_id = $_POST['InventoryGoodsReceipt']['outlet_id'];
            //$model->location_id = $_POST['InventoryGoodsReceipt']['location_id'];
            $model->lead_owner_id = $_POST['InventoryGoodsReceipt']['lead_owner_id'];
            //$model->receipt_type = $_POST['InventoryGoodsReceipt']['receipt_type'];
            $model->file_id = $_POST['InventoryGoodsReceipt']['file_id'];
            $model->production_order_id = $_POST['InventoryGoodsReceipt']['file_id'];
            $model->reference = 'MACHINE_ISSUE';
            if (empty($model->lead_owner_id)) {
                echo CJSON::encode([
                    'status' => 'error',
                    'message' => 'Salesman cannot be blank'
                ]);
                Yii::app()->end();
            }
            $itemRows = $_POST['InventoryGoodsReceiptItem'] ?? [];
            if (empty($itemRows)) {
                echo CJSON::encode([
                    'status' => 'error',
                    'message' => 'No machine items found.'
                ]);
                Yii::app()->end();
            }
            $itemModels = [];
            $stockLedgers = [];
            // Safely load invoice (if provided)
            $invoiceId = (int) ($_POST['InventoryGoodsReceipt']['invoice_id'] ?? 0);
            $modelInvoice = $invoiceId ? Order::model()->findByPk($invoiceId) : null;
            // $InvoiceStartDate = $modelInvoice ? $modelInvoice->contract_start_date : null;
            // $InvoiceEndDate = $modelInvoice ? $modelInvoice->contract_end_date : null;
            $invoiceItemId = [];
            if ($invoiceId) {
                $invoiceItemId = OrderItem::model()->findAll([
                    'condition' => 'invoice_id="' . $invoiceId . '"'
                ]);
            }
            $invoiceProductIds = [];
            foreach ($invoiceItemId as $invItem) {
                $invoiceProductIds[] = (int) $invItem->product_id; // adjust field name if it's different
            }
            /*** Validate and Prepare Each Item ***/
            foreach ($itemRows as $i => $itemData) {
                $machine_id = (int) ($itemData['product_id'] ?? 0);
                $serial_no_input = $itemData['serial_no'] ?? null;
                $modelStore = $machine_id ? Store::model()->findByPk($machine_id) : null;
                if ($invoiceId && !in_array($machine_id, $invoiceProductIds)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => "Product at row " . ($i + 1) . " does not match any item from the selected invoice. Please select the correct product."
                    ]);
                    Yii::app()->end();
                }
                if (!$modelStore) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => "Invalid product selected at row " . ($i + 1)
                    ]);
                    Yii::app()->end();
                }
                if ((int) $itemData['location_id'] <= 0) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => "Please enter location for row " . ($i + 1)
                    ]);
                    Yii::app()->end();
                }
                // stock_ledger_id is passed as serial_no in the submitted data
                $stock_ledger_id = (int) $serial_no_input;
                $sql = 'SELECT serial_no,id,unit_id,warehouse_id FROM erp_stock_ledger L where L.id="' . $stock_ledger_id . '"';
                $modelStockLedger = Yii::app()->db->createCommand($sql)->queryRow();
                if (!$modelStockLedger) {
                    $valid = false;
                    $other[] = "Invalid stock ledger reference for item " . ($i + 1);
                    // push placeholder so indexes remain consistent but skip further processing for this row
                    $stockLedgers[] = null;
                    $itemModels[] = null;
                    Yii::app()->end();
                }
                $modelUOM = UnitOfMeasurement::model()->findByPk((int) $modelStockLedger['unit_id']);
                $serial_no = $modelStockLedger['serial_no'];
                if (empty($serial_no)) {
                    $valid = false;
                    $other[] = "Serial number missing for item " . ($i + 1);
                }
                // Either load existing or create new item
                if ($isUpdate) {
                    $modelIssueItem = InventoryGoodsReceiptItem::model()->find(
                        'header_id=:hid AND product_id=:mid',
                        [':hid' => $model->id, ':mid' => $machine_id]
                    );
                    if (!$modelIssueItem)
                        $modelIssueItem = new InventoryGoodsReceiptItem();
                    $modelIssueItem->updated_by = Yii::app()->user->id;
                    $modelIssueItem->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $modelIssueItem = new InventoryGoodsReceiptItem();
                    $modelIssueItem->created_by = Yii::app()->user->id;
                    $modelIssueItem->created_date_time = date('Y-m-d H:i:s');
                }
                $modelIssueItem->product_id = $machine_id;
                $modelIssueItem->product_name = $modelStore ? $modelStore->part_number : '';
                //$modelIssueItem->description = ($modelStore ? $modelStore->part_number : '') . '/' . $serial_no;
                $modelIssueItem->unit = (int) $modelStockLedger['unit_id'];
                $modelIssueItem->description = $itemData['description'] ? $itemData['description']: ($modelStore ? $modelStore->description : '');
                //$modelIssueItem->remarks = $itemData['description'] ?? '';
                $modelIssueItem->location_id = $itemData['location_id'] ?? null;
                $modelIssueItem->picked_qty = 1;
                $modelIssueItem->rate = 0; // temp
                //$modelIssueItem->customer_id = 0; // temp
                //$modelIssueItem->stock_ledger_id = (int) $modelStockLedger['id']; // use existing ledger id reference for now
                $modelIssueItem->serial_no = $serial_no;
                $customer = Customer::model()->findByPk($model->customer_id);
                $no_of_days = 30;
                if ($customer && !empty($customer->no_of_days) && $customer->no_of_days > 0) {
                    $no_of_days = (int) $customer->no_of_days;
                }
                $lastService = date('Y-m-d');
                $nextService = date('Y-m-d', strtotime("+{$no_of_days} days", strtotime($lastService)));
                //$modelIssueItem->last_service = $lastService;
                //$modelIssueItem->next_service = $nextService;
                $valid = $modelIssueItem->validate();
                $itemModels[] = $modelIssueItem;
                $stockLedgers[] = $modelStockLedger;
                // Assign warehouse_id from last item
                $model->warehouse_id = $modelStockLedger['warehouse_id'];
            }
            // validate header model too
            $valid = $model->validate();
        } else {
            $valid = false;
            $other[] = 'Form not posted';
        }
        if ($valid) {
            // Save header
            if (!$model->save(false)) {
                echo '<pre>';
                print_r($model->getErrors());
                echo '</pre>';
                Yii::app()->end();
            }
            /*** Save All Items and Corresponding Stock Ledgers ***/
            foreach ($itemModels as $index => $itemModel) {
                // skip rows that were invalid earlier
                if (!$itemModel || !isset($stockLedgers[$index]) || !$stockLedgers[$index]) {
                    Yii::app()->end();
                }
                $itemModel->goods_issue_id = $model->id;
                //$itemModel->customer_id = $model->customer_id;
                //$itemModel->lead_owner_id = $model->lead_owner_id;
                $ledger = $stockLedgers[$index]; // associative array from queryRow
                $uom = UnitOfMeasurement::model()->findByPk((int) $ledger['unit_id']);
                /************** UPDATE ORIGINAL STOCK LEDGER TO MARK ISSUED **************/
                // Use the existing ledger id to update (that is the row we are issuing)
                $existingLedgerId = (int) $ledger['id'];
                $customerNameForRemarks = ($model->customer && !empty($model->customer->customer_name)) ? $model->customer->customer_name : '';
                $remarksUpdate = 'MACHINE_ISSUED' . '/' . $model->id . '/' . $customerNameForRemarks;
                // Update original ledger entry
                StockLedger::model()->updateByPk($existingLedgerId, [
                    'customer_vendor_id' => $model->customer_id,
                    'customer_vendor_name' => $customerNameForRemarks,
                    'customer_location_id' => $model->outlet_id,
                    'remarks' => $remarksUpdate,
                    'available_status' => 'U'
                ]);
                /************** STOCK LEDGER (OUT) ENTRY FOR MACHINE_ISSUE **************/
                $existingLedger = (object) $ledger; // cast for ->property access convenience
                $remarks = 'MACHINE_ISSUED/' . $model->id . '/' . $customerNameForRemarks;
                $warehouse = $existingLedger->warehouse_id;
                // Get warehouse name
                $warehouseName = '';
                $warehouseModel = MasInventoryWarehouse::model()->findByPk($warehouse);
                if ($warehouseModel) {
                    $warehouseName = $warehouseModel->warehouse_name;
                }
                // Prepare new stock ledger OUT entry
                $stock = new StockLedger();
                $stock->file_id = $model->file_id;
                $stock->header_id = $model->id;
                $stock->header_item_id = $itemModel->id;
                $stock->customer_vendor_id = $model->customer_id;
                $stock->customer_vendor_name = $customerNameForRemarks;
                $stock->product_id = $itemModel->product_id;
                $stock->product_name = $itemModel->product_name;
                $stock->product_description = $itemModel->description;
                // Try to pull brand info from store if available
                $storeModel = Store::model()->findByPk($itemModel->product_id);
                $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                $stock->warehouse_id = $warehouse;
                $stock->warehouse_name = $warehouseName;
                // Default rack/bin
                $rack = new MasInvRack();
                $stock->rack_id = $rack->getDefaultRackId();
                $stock->rack_name = $rack->getRackName($stock->rack_id);
                $bin = new MasInvBin();
                $stock->bin_id = $bin->getDefaultBinId();
                $stock->bin_name = $bin->getBinName($stock->bin_id);
                // UOM and stock details
                $stock->unit_id = $existingLedger->unit_id;
                $uomModel = UnitOfMeasurement::model()->findByPk($existingLedger->unit_id);
                $stock->unit_name = $uomModel ? $uomModel->name : '';
                $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                $stock->quantity = -1;
                $stock->available_status = 'U'; // Mark unavailable as item is issued
                $stock->batch_no = '';
                $stock->serial_no = $existingLedger->serial_no;
                $stock->cost_price = 0;
                $stock->transaction_date = date('Y-m-d');
                $stock->transaction_from = "MACHINE_ISSUE";
                $stock->transaction_type = "OUT";
                $stock->master_stock_ledger_id = $existingLedger->id;
                $stock->stock_updated = 'Y';
                $stock->created_by = Yii::app()->user->id;
                $stock->created_date = date('Y-m-d H:i:s');
                $stock->remarks = $remarks;
                $stock->lead_owner_id = $model->lead_owner_id;
                if (!$stock->save(false)) {
                    Yii::log("Failed to save stock ledger (OUT) for issued machine ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                    Yii::app()->end();
                }
                // Now link the newly created stock ledger id to the item and save the item
                //$itemModel->stock_ledger_id = $stock->id;
                if (!$itemModel->save(false)) {
                    Yii::log("Failed to save InventoryGoodsReceiptItem for machine ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                    echo '<pre>';
                    print_r($itemModel->getErrors());
                    echo '</pre>';
                    Yii::app()->end();
                }
            }
            $currentTime = date('H:i:s');
            /************** CREATE REPAIR REQUEST **************/
            $modelRequest = new SaleRepairRequest();
            $modelRequest->type_id = 2;
            $modelRequest->customer_id = $model->customer_id;
            $modelRequest->customer_shipping_id = $model->outlet_id;
            $modelRequest->service_id = MasServices::getIdByCode('S2');
            $modelRequest->request_date = date('Y-m-d');
            $modelRequest->schedule_date = date('Y-m-d');
            $modelRequest->start_time = date('Y-m-d H:i:s');
            $modelRequest->end_time = date('Y-m-d H:i:s');
            $modelRequest->status_id = 2;
            $modelRequest->completed_date = date('Y-m-d');
            $modelRequest->assigned_id = $model->lead_owner_id;
            $modelRequest->submit_invoice = 'Y';
            $modelRequest->technician_status = 'Y';
            $modelRequest->is_Visited = 'Y';
            $modelRequest->schedule_status = 'C';
            $modelRequest->request_from = 'MI';
            $modelRequest->created_by = Yii::app()->user->id;
            $modelRequest->created_date_time = date('Y-m-d H:i:s');
            $modelRequest->save(false);
            // InventoryGoodsReceipt::model()->updateByPk($model->id, ['job_sheet_id' => $modelRequest->id]);
            /************** CREATE REPAIR REQUEST ITEMS **************/
            foreach ($itemModels as $itemModel) {
                // skip invalid rows
                if (!$itemModel)
                    Yii::app()->end();
                $repairItem = new SalesRepairRequestItem();
                $repairItem->machine_id = $itemModel->product_id;
                $repairItem->serial_no = $itemModel->serial_no;
                $repairItem->issue_item_id = $itemModel->id;
                $repairItem->location_id = $itemModel->location_id;
                $repairItem->status_id = 2;
                // $repairItem->repair_date = date('Y-m-d');
                $repairItem->service_id = MasServices::getIdByCode('S2');
                $repairItem->header_id = $modelRequest->id;
                $repairItem->activity_changed = 'N';
                // $repairItem->created_by = Yii::app()->user->id;
                // $repairItem->created_date_time = date('Y-m-d H:i:s');
                $repairItem->save(false);
            }
            /************** AUDIT LOG **************/
            AuditLog::saveAuditLogs($audit_type, 'InventoryGoodsReceipt', $model->id);
            echo CJSON::encode(['status' => 'success', 'id' => $model->id]);
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            // Merge CActiveForm errors with manual $other errors; make sure both are arrays
            $errorsMerged = array_merge_recursive((array) $error1, (array) $other);
            echo CJSON::encode($errorsMerged);
        }
    }

    public function actionReturnIndex()
    {
        $this->render('return_index');
    }

    public function actionGetReturnList()
    {
        $requestData = $_REQUEST;
        $columns = [
            0 => 't.id',
            1 => 'c.customer_name',
            2 => 'u.name',
            3 => 'l.location_name',
            4 => 'i.serial_no',
            5 => 'st.item_name',
        ];

        $criteria = new CDbCriteria();
        $criteria->alias = 't';
        $criteria->select = '
            t.id,
            i.serial_no,
            i.return_stock_ledger_id,
            c.customer_name,
            CONCAT(u.first_name, " ", u.last_name) AS lead_owner,
            l.location_name,
            st.part_number AS machine_name
        ';
        // ✅ Fixed join for correct schema
        $criteria->join = '
            INNER JOIN erp_service_mas_customer_machines_item i ON i.header_id = t.id
            INNER JOIN erp_customer c ON t.customer_id = c.id
            LEFT JOIN blskysoftware_erp_2025_main.erp_user u ON t.lead_owner_id = u.id
            LEFT JOIN erp_service_customer_location l ON t.location_id = l.id
            LEFT JOIN erp_store st ON i.machine_id = st.id
        ';
        // ✅ Only show those where items have been returned
        $criteria->addCondition('i.return_stock_ledger_id > 0');
        if (Yii::app()->user->authorised_user != 1) {
            $userId = (int) Yii::app()->user->id;
            $criteria->addCondition("(t.lead_owner_id = {$userId} OR t.created_by = {$userId})");
        }
        // ✅ Searching
        if (!empty($requestData['search']['value'])) {
            $search = trim($requestData['search']['value']);
            $criteria->addSearchCondition('c.customer_name', $search, true, 'OR');
            $criteria->addSearchCondition('i.serial_no', $search, true, 'OR');
            $criteria->addSearchCondition('st.item_name', $search, true, 'OR');
            $criteria->addSearchCondition('l.location_name', $search, true, 'OR');
        }
        // ✅ Count total properly
        $countCriteria = clone $criteria;
        $countCriteria->select = 't.id';
        $countCriteria->distinct = true;
        $totalData = ServiceMasCustomerMachines::model()->count($countCriteria);
        // ✅ Sorting
        $orderCol = isset($columns[$requestData['order'][0]['column']]) ? $columns[$requestData['order'][0]['column']] : 't.id';
        $orderDir = $requestData['order'][0]['dir'] === 'asc' ? 'ASC' : 'DESC';
        $criteria->order = "$orderCol $orderDir";
        // ✅ Pagination
        $criteria->limit = (int) $requestData['length'];
        $criteria->offset = (int) $requestData['start'];
        $models = ServiceMasCustomerMachines::model()->findAll($criteria);
        $data = [];
        $i = (int) $requestData['start'] + 1;
        foreach ($models as $row) {
            $data[] = [
                $i++,
                $row['customer_name'],
                $row['lead_owner'],
                $row['location_name'],
                $row['serial_no'],
                $row['machine_name'],
                '<button class="btn btn-primary btn-xs" onclick="viewReturn(' . $row['id'] . ')"><i class="fa fa-eye"></i></button>',
            ];
        }
        echo CJSON::encode([
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalData),
            "data" => $data,
        ]);
        Yii::app()->end();
    }




















    

    public function actionReturnForm()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');

        $model = new ServiceMasCustomerMachines();
        $modelIssueItem = [new ServiceMasCustomerMachinesItem()];

        if ($id > 0) {
            $existingModel = ServiceMasCustomerMachines::model()->findByPk($id);

            if ($existingModel !== null) {
                $model = $existingModel;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }

            // ✅ Fetch only items not yet returned (return_stock_ledger_id = 0)
            $criteria = new CDbCriteria();
            $criteria->addCondition('header_id = :header_id');
            $criteria->addCondition('return_stock_ledger_id = 0');
            $criteria->params = [':header_id' => $id];

            $existingIssueItems = ServiceMasCustomerMachinesItem::model()->findAll($criteria);

            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }

        Yii::app()->clientScript->scriptMap = [
            '*jquery.js' => false,
            '*jquery.min.js' => false,
            'jquery.min.js' => false,
            '*jquery-ui.js' => false,
            '*jquery-ui.min.js' => false,
        ];

        // ✅ Render partial view
        $this->renderPartial(
            'return_form',
            [
                'model' => $model,
                'modelIssueItem' => $modelIssueItem,
                'type' => $type,
            ],
            false,
            true
        );
    }

    




    



    


    





    



    //end


    public function actionCreateReturn()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');

        $model = new ServiceMasCustomerMachines();
        $modelIssueItem = [new ServiceMasCustomerMachinesItem()];

        if ($id > 0) {
            $existingModel = ServiceMasCustomerMachines::model()->findByPk($id);

            if ($existingModel !== null) {
                $model = $existingModel;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }

            // ✅ Fetch only items not yet returned (return_stock_ledger_id = 0)
            $criteria = new CDbCriteria();
            $criteria->addCondition('header_id = :header_id');
            $criteria->addCondition('return_stock_ledger_id = 0');
            $criteria->params = [':header_id' => $id];

            $existingIssueItems = ServiceMasCustomerMachinesItem::model()->findAll($criteria);

            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }

        Yii::app()->clientScript->scriptMap = [
            '*jquery.js' => false,
            '*jquery.min.js' => false,
            'jquery.min.js' => false,
            '*jquery-ui.js' => false,
            '*jquery-ui.min.js' => false,
        ];

        // ✅ Render partial view
        $this->renderPartial(
            'create_return',
            [
                'model' => $model,
                'modelIssueItem' => $modelIssueItem,
                'type' => $type,
            ],
            false,
            true
        );
    }


    public function actionReturnMachine()
    {
        $model = new ServiceMasCustomerMachines();

        if (isset($_POST['ServiceMasCustomerMachines'])) {
            $model->attributes = $_POST['ServiceMasCustomerMachines'];
            $model_id = $_POST['ServiceMasCustomerMachines']['id'];
            $lead_owner_id = $_POST['ServiceMasCustomerMachines']['lead_owner_id'];
            $customer_name = $_POST['ServiceMasCustomerMachines']['customer_name'];
            $selectedItems = isset($_POST['ServiceMasCustomerMachinesItem']) ? $_POST['ServiceMasCustomerMachinesItem'] : [];

            if (empty($selectedItems)) {
                echo CJSON::encode(['status' => 'error', 'message' => 'No machines selected for return.']);
                Yii::app()->end();
            }

            $messages = []; // ✅ collect all success/error messages
            $hasError = false;

            foreach ($selectedItems as $item) {
                if (isset($item['selected']) && !empty($item['selected'])) {
                    $machineId = (int) $item['machine_id'];
                    $issueItemId = (int) $item['id'];
                    $stockLedgerId = (int) ($item['stock_ledger_id'] ?? 0);
                    $remarks = trim($_POST['ServiceMasCustomerMachinesItem']['return_remarks'] ?? '');

                    $machineModel = ServiceMasCustomerMachinesItem::model()->findByPk($issueItemId);
                    if (!$machineModel) {
                        $messages[] = "Machine ID {$machineId} not found.";
                        $hasError = true;
                        continue;
                    }

                    if ($machineModel->return_stock_ledger_id > 0) {
                        $messages[] = "Machine ID {$machineId} already returned.";
                        $hasError = true;
                        continue;
                    }

                    $existingLedger = StockLedger::model()->findByPk($stockLedgerId);
                    if (!$existingLedger || empty($existingLedger->serial_no)) {
                        $messages[] = "Stock ledger missing for machine ID {$machineId}.";
                        $hasError = true;
                        continue;
                    }

                    // Determine warehouse
                    $warehouse = MasInventoryWarehouse::model()->getWarehouseIdByCode('RUW');
                    $warehouseName = MasInventoryWarehouse::model()->getWarehouseName($warehouse);

                    if (!$warehouse) {
                        $messages[] = "Warehouse not found for machine ID {$machineId}.";
                        $hasError = true;
                        continue;
                    }

                    // ✅ Create return stock ledger
                    $stock = new StockLedger();
                    $stock->file_id = $model_id;
                    $stock->header_id = $model_id;
                    $stock->header_item_id = '';
                    $stock->customer_vendor_id = 0;
                    $stock->customer_vendor_name = '';
                    $stock->product_id = $machineModel->machine_id;
                    $stock->product_name = $machineModel->machine->part_number;
                    $stock->product_description = $machineModel->machine->description;
                    $stock->brand_id = $machineModel->machine->brand_class_id;
                    $stock->brand_name = $machineModel->machine->brand_detail->brand_name;
                    $stock->warehouse_id = $warehouse;
                    $stock->warehouse_name = $warehouseName;

                    $rack = new MasInvRack();
                    $stock->rack_id = $rack->getDefaultRackId();
                    $stock->rack_name = $rack->getRackName($stock->rack_id);

                    $bin = new MasInvBin();
                    $stock->bin_id = $bin->getDefaultBinId();
                    $stock->bin_name = $bin->getBinName($stock->bin_id);

                    $stock->unit_id = $existingLedger->unit_id;
                    $stock->unit_name = $existingLedger->unit_name;
                    $stock->unit_factor = $existingLedger->unit_factor;
                    $stock->quantity = 1;
                    $stock->available_status = 'A';
                    $stock->batch_no = '';
                    $stock->serial_no = $existingLedger->serial_no;
                    $stock->cost_price = 0;
                    $stock->transaction_date = date('Y-m-d');
                    $stock->transaction_from = "MACHINE_RETURN";
                    $stock->transaction_type = "IN";
                    $stock->master_stock_ledger_id = $stockLedgerId;
                    $stock->stock_updated = 'Y';
                    $stock->created_by = Yii::app()->user->id;
                    $stock->created_date = date('Y-m-d H:i:s');
                    $stock->remarks = $remarks;
                    $stock->lead_owner_id = $lead_owner_id;


                    if (!$stock->save(false)) {
                        $messages[] = "Failed to save stock ledger for machine ID {$machineId}.";
                        $hasError = true;
                        continue;
                    }

                    // ✅ Update machine item record
                    $machineModel->updateByPk($machineModel->id, [
                        'return_stock_ledger_id' => $stock->id,
                        'return_remarks' => $remarks,
                        'returned_by' => $lead_owner_id,
                        'returned_date_time' => date('Y-m-d H:i:s')

                    ]);

                    // ✅ Update parent header reference
                    $model->updateByPk($_POST['ServiceMasCustomerMachines']['id'], [
                        'reference' => 'MACHINE_RETURN',
                    ]);

                    // ✅ Check if all items are returned now
                    $headerId = $machineModel->header_id;
                    $pendingCount = ServiceMasCustomerMachinesItem::model()->count(
                        'header_id = :hid AND (return_stock_ledger_id = 0 OR return_stock_ledger_id IS NULL)',
                        [':hid' => $headerId]
                    );

                    if ($pendingCount == 0) {
                        $model->updateByPk($headerId, [
                            'is_return_fully' => 'Y',
                            'updated_by' => Yii::app()->user->id,
                            'updated_date' => date('Y-m-d H:i:s'),
                        ]);
                    }

                    $messages[] = "✅ Machine ID {$machineId} marked as returned successfully.";
                }
            }

            // ✅ Final response after processing all selected machines
            if ($hasError && empty($messages)) {
                echo CJSON::encode(['status' => 'error', 'message' => 'No valid machines selected.']);
            } elseif ($hasError) {
                echo CJSON::encode(['status' => 'partial', 'message' => implode("<br>", $messages)]);
            } else {
                echo CJSON::encode(['status' => 'success', 'message' => implode("<br>", $messages)]);
            }

            Yii::app()->end();
        }
    }







    public function actionGetMachineserailNumbersonly()
    {
        $product_id = Yii::app()->request->getParam("machine_id");
        $machineserialnoarray = StockLedger::getAllMachineSerialNoByMacine($product_id);
        $drop = '<li class="col-sm-2">';
        $drop .= CHtml::dropDownList('serial_no', '', $machineserialnoarray, array('class' => 'form-control machine-dropdown', 'data-label' => 'Machine Serial No', 'empty' => '-Select-', 'data-search' => 'true'));
        $drop .= '</li>';
        $status = ['dt' => $drop, 'status' => 'success'];

        echo CJSON::encode($status);
    }
    

    public function actiongetCustomerShippingdetailsReturn1()
    {
        $id = Yii::app()->request->getparam("id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $model = new ServiceMasCustomerMachines();
        $models = CustomerOutletLocation::getShippingLocation($id);
        $drop = '<li class="col-sm-4">';
        $drop .= CHtml::activedropDownList($model, "customer_shipping_id", $models, array('class' => '', 'title' => 'Please Select Outlet', 'data-label' => 'Outlet Location', 'data-search' => true, 'empty' => '--Choose Outlet--'));
        $drop .= '</li>';


        $status = array("dtship" => $drop);
        echo CJSON::encode($status);
    }
    

    

    public function actionGetReturnMachines1()
    {
        $customer_id = Yii::app()->request->getPost('ServiceMasCustomerMachines')['customer_id'] ?? null;
        $customer_shipping_id = (int) Yii::app()->request->getPost('customer_shipping_id') ?? null;
        // $lead_owner_ids = Yii::app()->request->getPost('ServiceMasCustomerMachines')['lead_owner_id'] ?? [];

        // if (empty($customer_id) || empty($lead_owner_ids)) {
        //     echo "<div class='alert alert-warning'>Please select both Customer and at least one Lead Owner.</div>";
        //     Yii::app()->end();
        // }

        $criteria = new CDbCriteria();
        $criteria->alias = 't';
        $criteria->addCondition('t.customer_id = :customer_id');
        $criteria->params[':customer_id'] = $customer_id;
        if ($customer_shipping_id > 0) {
            $criteria->addCondition('parent.customer_shipping_id = :customer_shipping_id');
            $criteria->params[':customer_shipping_id'] = $customer_shipping_id;
        }
        // ✅ Handle multiple lead owners
        // $criteria->addInCondition('t.lead_owner_id', (array) $lead_owner_ids);

        $criteria->addCondition('t.return_stock_ledger_id = 0');
        $criteria->with = ['machine', 'parent', 'customerlocation'];
        $criteria->group = 't.id, t.machine_id';

        $machineList = ServiceMasCustomerMachinesItem::model()->findAll($criteria);

        if (empty($machineList)) {
            echo "<div class='alert alert-info'>No machines available for return under this customer and selected lead owner(s).</div>";
            Yii::app()->end();
        }

        $form = new CActiveForm(); // reuse form helpers
        $this->renderPartial('return_machine_table', [
            'machineList' => $machineList,
            'form' => $form,
        ], false, true);
    }



    public function actionReturnMachineMultiple1()
    {
        $model = new ServiceMasCustomerMachines();

        if (!isset($_POST['ServiceMasCustomerMachines'])) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid request.']);
            Yii::app()->end();
        }

        $model->attributes = $_POST['ServiceMasCustomerMachines'];
        $customer_name = $_POST['ServiceMasCustomerMachines']['customer_name'];
        $model_id = $_POST['ServiceMasCustomerMachines']['id'];
        $customer_id = (int) $model->customer_id;
        $lead_owner_ids = (array) ($_POST['ServiceMasCustomerMachines']['lead_owner_id'] ?? []);
        $selectedItems = $_POST['ServiceMasCustomerMachinesItem'] ?? [];

        if (empty($selectedItems)) {
            echo CJSON::encode(['status' => 'error', 'message' => 'No machines selected for return.']);
            Yii::app()->end();
        }

        // Get warehouse (return location)
        $warehouse = MasInventoryWarehouse::model()->getWarehouseIdByCode('RUW');
        $warehouseName = MasInventoryWarehouse::model()->getWarehouseName($warehouse);
        if (!$warehouse) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Return warehouse not configured (RUW missing).']);
            Yii::app()->end();
        }

        $rack = new MasInvRack();
        $bin = new MasInvBin();
        $defaultRackId = $rack->getDefaultRackId();
        $defaultBinId = $bin->getDefaultBinId();

        foreach ($selectedItems as $id => $item) {
            if (empty($item['selected'])) {
                continue;
            }

            $machineModel = ServiceMasCustomerMachinesItem::model()->findByPk($id);
            if (!$machineModel) {
                echo CJSON::encode(['status' => 'error', 'message' => "Machine record not found for item ID {$id}."]);
                Yii::app()->end();
            }

            if ($machineModel->return_stock_ledger_id > 0) {
                echo CJSON::encode(['status' => 'error', 'message' => "Machine serial <b>{$machineModel->serial_no}</b> already returned."]);
                Yii::app()->end();
            }

            $existingLedger = StockLedger::model()->findByPk($machineModel->stock_ledger_id);
            if (!$existingLedger) {
                echo CJSON::encode(['status' => 'error', 'message' => "No stock ledger found for machine <b>{$machineModel->serial_no}</b>."]);
                Yii::app()->end();
            }

            $remarks = trim($item['return_remarks'] ?? '');
            $return_lead_owner_id = (int) ($item['return_lead_owner_id'] ?? 0);
            if (empty($return_lead_owner_id) && !empty($lead_owner_ids)) {
                $return_lead_owner_id = reset($lead_owner_ids);
            }

            // Create stock ledger entry (IN - Return)
            $stock = new StockLedger();
            $stock->attributes = [
                'file_id' => $machineModel->header_id,
                'header_id' => $machineModel->header_id,
                'header_item_id' => '',
                'customer_vendor_id' => '0',
                'customer_vendor_name' => '',
                'product_id' => $machineModel->machine_id,
                'product_name' => $machineModel->machine->part_number,
                'product_description' => $machineModel->machine->description,
                'brand_id' => $machineModel->machine->brand_class_id,
                'brand_name' => $machineModel->machine->brand_detail->brand_name,
                'warehouse_id' => $warehouse,
                'warehouse_name' => $warehouseName,
                'rack_id' => $defaultRackId,
                'rack_name' => $rack->getRackName($defaultRackId),
                'bin_id' => $defaultBinId,
                'bin_name' => $bin->getBinName($defaultBinId),
                'unit_id' => $existingLedger->unit_id,
                'unit_name' => $existingLedger->unit_name,
                'unit_factor' => $existingLedger->unit_factor,
                'quantity' => 1,
                'available_status' => 'A',
                'batch_no' => '',
                'serial_no' => $existingLedger->serial_no,
                'cost_price' => 0,
                'transaction_date' => date('Y-m-d'),
                'transaction_from' => 'MACHINE_RETURN',
                'transaction_type' => 'IN',
                'master_stock_ledger_id' => $existingLedger->id,
                'stock_updated' => 'Y',
                'created_by' => Yii::app()->user->id,
                'created_date' => date('Y-m-d H:i:s'),
                'remarks' => $remarks,
                'lead_owner_id' => $return_lead_owner_id,
            ];

            if (!$stock->save(false)) {
                echo CJSON::encode(['status' => 'error', 'message' => "Failed to save return stock for serial <b>{$machineModel->serial_no}</b>."]);
                Yii::app()->end();
            }
            // var_dump($stock->id);

            // Update machine item as returned
            $machineModel->updateByPk($machineModel->id, [
                'return_stock_ledger_id' => $stock->id,
                'return_remarks' => $remarks,
                'returned_by' => $return_lead_owner_id,
                'returned_date_time' => date('Y-m-d H:i:s'),
            ]);

            // Update header if fully returned
            $pendingCount = ServiceMasCustomerMachinesItem::model()->count(
                'header_id = :hid AND (return_stock_ledger_id = 0 OR return_stock_ledger_id IS NULL)',
                [':hid' => $machineModel->header_id]
            );

            if ($pendingCount == 0) {
                $model->updateByPk($machineModel->header_id, [
                    'is_return_fully' => 'Y',
                    'updated_by' => Yii::app()->user->id,
                    'updated_date' => date('Y-m-d H:i:s'),
                ]);
            }
        }

        echo CJSON::encode(['status' => 'success', 'message' => 'Selected machines returned successfully.']);
        Yii::app()->end();
    }


    



}


