<?php

class CustomerVisitController extends Controller
{
	public function accessRules()
	{
		return array(
			array(
				'allow', // allow all users to perform 'index' and 'view' actions
				'actions' => array('login', 'error', 'logout'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('Index', 'getlist', 'getLocationdetails', 'View', 'print'),
				'expression' => '$user->isMember()',
			),
			array(
				'deny', // deny all users
				'users' => array('*'),
			),
		);
	}

	public function filters()
	{
		return array('accessControl'); // perform access control for CRUD operations
	}
	public function actionCreate()
	{
		$this->render('create');
	}

	public function actionIndex()
	{
		$this->render('index');
	}

	public function actiongetlist()
	{
		$model = new SaleRepairRequest();
		$draw = $_POST['draw'];
		$offset = $_POST['start'];
		$limit = $_POST['length'];
		$frm = $_POST['frm'];
		$columns = array(0 => 't.id', 1 => 't.id', 2 => 'customer.customer_name', 3 => 'assigned.first_name', 4 => 't.schedule_date', 5 => 't.start_time', 6 => 't.end_time', 7 => 't.complete_remark', 8 => 't.id');
		$filterColumn = $columns[$_POST['order'][0]['column']];
		$filterOrder = $_POST['order'][0]['dir'];
		$orderBy = $filterColumn . " " . $filterOrder;
		$condition = "1=1";
		if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_visit_view"])) {
			$condition .= ' AND t.is_Visited = "Y" AND t.status_id = 2';
		} else if (Yii::app()->user->authorised_user != 1) {
			$condition .= ' AND (t.assigned_id= "' . Yii::app()->user->id . '" OR t.created_by="' . Yii::app()->user->id . '" OR FIND_IN_SET("' . Yii::app()->user->id . '",customer.lead_owner_id))';
		}
		if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
			$searchString = $_POST['search']['value'];
			$condition .= "  AND (customer.customer_name LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR assigned.first_name LIKE '%" . $searchString . "%')";
		}
		//  echo $condition;die;
		$count = $model->with('customer', 'assigned')->count(array('condition' => $condition));
		$model = $model->with('customer', 'assigned')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
		$recordsTotal = $count;
		$recordsFiltered = $count;
		$data['draw'] = $draw;
		$data['recordsTotal'] = $recordsTotal;
		$data['recordsFiltered'] = $recordsFiltered;
		$rowData = array();
		foreach ($model as $key => $row) {
			$btn = "";
			if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["machine_type"])) {
				//  $btn .= '<button class="btn btn-primary  btn-xs" onclick="loadPopupModal(\'sale/service/create&id=' . $row['id'] . '\',\'Edit '. $row->id.' \',\'lg\')"><i class="fa fa-edit"></i></button> ';
			}
			/*if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["machine_type"])) {
				$btn .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deletemachinetype(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
			}*/
			/*$arr_start_time =  array();
			$arr_start_time = explode(' ',$row->start_time);*/
			if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_visit_print"])) {
				$btn .= '&nbsp;<button class="btn btn-primary btn-xs" title ="Print" onclick="window.open(\'index.php?r=sales/customerVisit/print&type=2&id=' . $row['id'] . '\')"><i class="fa fa-print"></i></button>';
				$btn .= '&nbsp;<button class="btn btn-primary btn-xs" title ="Print Oil Issual" onclick="window.open(\'index.php?r=iwarehouse/PrintMachine&id=' . $row['transfer_id'] . '\')"><i class="fa fa-print"></i></button>';
			}
			if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_visit_view"])) {
				$btn .= '&nbsp;<button class="btn btn-primary  btn-xs" onclick="loadPopupModal(\'sales/customerVisit/view&id=' . $row['id'] . '\',\'View - ' . $row->id . ' \',\'lg\')"><i class="fa fa-eye"></i></button> ';
			}
			if (date('H:i:s', strtotime($row->start_time)) == "00:00:00") {
				$start_time = "--";
			} else {
				$start_time = date('H:i a', strtotime($row->start_time));
			}

			if (date('H:i:s', strtotime($row->end_time)) == "00:00:00") {
				$end_time = "--";
			} else {
				$end_time = date('H:i a', strtotime($row->end_time));
			}


			$btn = "<div class='btn-wrap text-center'>{$btn}</div>";
			$rowData[] = [
				($key + 1),//0
				$row['id'],
				$row->customer->customer_name,//2
				$row->customer_outlet->outlet_location,
				$row->assigned->first_name . " " . $row->assigned->last_name,//4
				date('d/m/Y', strtotime($row->schedule_date)),
				$start_time,//6
				$end_time,
				$row->complete_remark,//8
				$row->service->name,
				['transfer_id'=>$row['transfer_id'],'type'=>$row->service->id]//10
			];
		}
		$data['data'] = $rowData;
		echo json_encode($data);
	}

	public function actionView()
	{
		$id = (int) Yii::app()->request->getParam('id');
		Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
		$this->renderPartial('service_view', array('id' => $id), false, true);
	}

	public function actionPrint()
	{
		$id = (int) Yii::app()->request->getParam('id');
		$type = (int) Yii::app()->request->getParam('type');
		$mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
		  $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
		 $mPDF1->WriteHTML($stylesheet, 1);
		if ($type == 2) {
			$page = "print_customer_wise";
		} else {
			$page = "print";
		}
		$mPDF1->WriteHTML($this->renderPartial($page, array('id' => $id), true));
		$mPDF1->Output($htmlTemplate, 'I');
		// echo $this->renderPartial($page, array('id' => $id), true);
	}


}