<?php

/**
 * This is the model class for table "{{project_requisition}}".
 *
 * The followings are the available columns in table '{{project_requisition}}':
 * @property integer $id
 * @property integer $project_id
 * @property string $project_name
 * @property string $location
 * @property string $requisition_date
 * @property string $required_date
 * @property string $notes
 * @property string $terms_and_conditions
 * @property string $remarks
 * @property string $status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class Requisition extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{project_requisition}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_id, project_name, location, requisition_date, required_date', 'required'),
			array('project_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('project_name, location,file_title', 'length', 'max'=>500),
			array('terms_and_conditions, notes,remarks', 'length', 'max'=>5000),
			array('status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_id, project_name, location, requisition_date, required_date, notes, terms_and_conditions, remarks, status, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'items' => array(self::HAS_MANY, 'RequisitionItems', 'project_requisition_id'),
            'project' => array(self::BELONGS_TO, 'Project', 'project_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_id' => 'Project',
			'project_name' => 'Project Name',
			'location' => 'Location',
			'requisition_date' => 'Requisition Date',
			'required_date' => 'Required Date',
			'notes' => 'Notes',
			'terms_and_conditions' => 'Terms And Conditon',
			'remarks' => 'Remarks',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('project_name',$this->project_name,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('requisition_date',$this->requisition_date,true);
		$criteria->compare('required_date',$this->required_date,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('terms_and_conditions',$this->terms_and_conditions,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProjectRequisition the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
