<?php

/**
 * This is the model class for table "{{project_milestone_technical}}".
 *
 * The followings are the available columns in table '{{project_milestone_technical}}':
 * @property integer $id
 * @property integer $project_id
 * @property string $milestone
 * @property string $percent_of_completion
 * @property string $milestone_planned_start_date
 * @property string $milestone_actual_start_date
 * @property string $milestone_planned_end_date
 * @property string $milestone_actual_end_date
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $remarks
 */
class MilestoneTechnical extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{project_milestone_technical}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_id, milestone, percent_of_completion, milestone_planned_start_date, milestone_actual_start_date, milestone_planned_end_date, milestone_actual_end_date, created_by, created_date_time, updated_by, updated_date_time, remarks', 'required'),
			array('project_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('milestone', 'length', 'max'=>255),
			array('percent_of_completion', 'length', 'max'=>5),
			array('remarks', 'length', 'max'=>250),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_id, milestone, percent_of_completion, milestone_planned_start_date, milestone_actual_start_date, milestone_planned_end_date, milestone_actual_end_date, created_by, created_date_time, updated_by, updated_date_time, remarks', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_id' => 'Project',
			'milestone' => 'Milestone',
			'percent_of_completion' => 'Percent Of Completion',
			'milestone_planned_start_date' => 'Milestone Planned Start Date',
			'milestone_actual_start_date' => 'Milestone Actual Start Date',
			'milestone_planned_end_date' => 'Milestone Planned End Date',
			'milestone_actual_end_date' => 'Milestone Actual End Date',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'remarks' => 'Remarks',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('milestone',$this->milestone,true);
		$criteria->compare('percent_of_completion',$this->percent_of_completion,true);
		$criteria->compare('milestone_planned_start_date',$this->milestone_planned_start_date,true);
		$criteria->compare('milestone_actual_start_date',$this->milestone_actual_start_date,true);
		$criteria->compare('milestone_planned_end_date',$this->milestone_planned_end_date,true);
		$criteria->compare('milestone_actual_end_date',$this->milestone_actual_end_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('remarks',$this->remarks,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProjectMilestoneTechnical the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
