<?php

/**
 * This is the model class for table "{{project_estimation}}".
 *
 * The followings are the available columns in table '{{project_estimation}}':
 * @property integer $id
 * @property string $project_name
 * @property string $location
 * @property string $estimation_date
 * @property string $manager_name
 * @property string $notes
 * @property integer $project_type
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class Estimation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{project_estimation}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_name, location', 'required'),
			array('project_type, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('project_name, location', 'length', 'max'=>500),
			array('manager_name', 'length', 'max'=>50),
			array('notes', 'length', 'max'=>5000),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_name, location, estimation_date, manager_name, notes, project_type, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'projecttype' => array(self::BELONGS_TO, 'MasProjectType','project_type'),
                    'items' => array(self::HAS_MANY, 'EstimationDetails', 'project_estimation_id', 'order' => 'items.id asc'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_name' => 'Project Name',
			'location' => 'Location',
			'estimation_date' => 'Estimation Date',
			'manager_name' => 'Manager Name',
			'notes' => 'Notes',
			'project_type' => 'Project Type',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_name',$this->project_name,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('estimation_date',$this->estimation_date,true);
		$criteria->compare('manager_name',$this->manager_name,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('project_type',$this->project_type);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Estimation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
