<?php

class Store extends CActiveRecord {

    public $oldBarCode;
    public $oldPartNo;
    public $oldOemNo;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{store}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // will receive user inputs.
        return array(
            array('part_number, description, unit_id, tax_code', 'required'),
            array('part_number,hsir_code,bar_code', 'filter', 'filter' => 'trim', 'on' => 'add'),
            array('part_number', 'unique', 'on' => 'add'),
            array('bar_code', 'unique'),
            //array('bar_code', 'checkUniqueness'),
            //array('oem_number', 'checkUniquenessOemNumber'),
            array('warehouse_id', 'checkWarehouse'),
            //array('machine_type', 'checkMachineType'),
            array('rack_id', 'checkRack'),
            //array('bin_id', 'checkBin'),
            array('brand_class_id', 'checkBrandClass'),
            array('part_number', 'checkUniqueBarcode'),
            array('purchase_from', 'checkPurchaseFrom'),
            array('brand_class_id, unit_id, tax_code, tax_code_1, tax_code_2, tax_code_3, re_order_level, re_order_lot,  created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('part_number, notes,generic_id, hsir_code, version, bar_code, others,item_image,oem_number,other_number,alias_name,width,length,height,thickness,material,finished,machine_type_remarks,cubic_meter', 'length', 'max' => 255),
            array('rate,  weight, volume,machine_type,bin_id,selling_price_1', 'length', 'max' => 15),
            array('description', 'length', 'max' => 5000),
            array('bar_code', 'length', 'max' => 15),
            array('packing,capacity', 'length', 'max' => 255),
            array('html_description', 'length', 'max' => 50000),
            array('inventory_item_type, isActive,have_expiry_date,have_serial_no,purchase_from', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, part_number, generic_id, description, brand_class_id, rate, unit_id, inventory_item_type, isActive,  tax_code,tax_code_1,tax_code_2,tax_code_3,  weight, volume, re_order_level, re_order_lot, hsir_code, version, bar_code, others, notes, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    public function checkUniqueness($attribute, $params) 
    {
        if (($this->bar_code !== $this->oldBarCode) && ($this->inventory_item_type == 1) && trim($this->bar_code)!='') {
            $model = Store::model()->find('part_number = ? OR  bar_code = ?', array($this->part_number,$this->bar_code));
            if ($model != null) {
                $this->addError('id', 'This ACE code already exist in either part number or Purchasing Part No');
            }
        }
    }
    public function checkUniquenessOemNumber($attribute, $params) 
            {
        if ($this->oem_number !== $this->oldOemNo && $this->inventory_item_type == 1 && $this->oem_number != '') {
            $model = Store::model()->find('part_number = ? OR  oem_number = ?', array($this->part_number, $this->oem_number));
            if ($model != null) {
                $this->addError('id', 'This purchasing part no already exist in either part number or ACE code');
            }
        }
    }

    public function checkWarehouse($attribute, $params) {
        if ((int) $this->warehouse_id == 0 && $this->inventory_item_type == 1) {
            $this->addError('warehouse_id', 'Warehouse cannot be blank');
        }
    }

    public function checkMachineType($attribute, $params) {
        if ($this->machine_type == "" && $this->inventory_item_type == 1) {
            $this->addError('machine_type', 'Machine Type cannot be blank');
        }
    }

    public function checkRack($attribute, $params) {
        if ((int) $this->rack_id == 0 && $this->inventory_item_type == 1) {
            $this->addError('rack_id', 'Rack cannot be blank');
        }
    }

    public function checkBin($attribute, $params) {
        if ((int) $this->bin_id == 0 && $this->inventory_item_type == 1) {
            $this->addError('bin_id', 'Bin cannot be blank');
        }
    }

    public function checkBrandClass($attribute, $params) {
        if ((int) $this->brand_class_id == 0 && $this->inventory_item_type == 1) {
            $this->addError('brand_class_id', 'Brand/Class cannot be blank');
        }
    }

    public function checkUniqueBarcode($attribute, $params) {
        if ($this->part_number !== $this->oldPartNo) {
            $model = Store::model()->find('bar_code = ? AND bar_code != ?', array($this->part_number, ''));
            if ($model != null) {
                $this->addError('id', 'This Part Number already exist in other product Bar Code');
            }
        }
    }

    public function checkPurchaseFrom($attribute, $params) {
        if ($this->purchase_from == "" && $this->inventory_item_type == 1) {
            $this->addError('purchase_from', 'Purchase From cannot be blank');
        }
    }

    protected function afterFind() {
        parent::afterFind();
        $this->oldBarCode = $this->bar_code;
        $this->oldPartNo = $this->part_number;
        $this->oldOemNo = $this->oem_number;
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'brand_detail' => array(self::BELONGS_TO, 'ProductClass', 'brand_class_id'),
            'tax' => array(self::BELONGS_TO, 'MasInvTax', 'tax_code'),
            'unit' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
            'salesunit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'default_sales_unit_id'),
            'genericdetails' => array(self::BELONGS_TO, 'MasGeneric', 'generic_id'),
            //'totalQuantity' => array(self::STAT, 'StockLedger', 'product_id', 'select' => 'SUM(quantity * unit_factor)','condition' => 'stock_updated="Y"'),
            /*'total_allocated_quantity' => array(self::STAT, 'AllocatedMaterial', 'product_id', 'select' => 'SUM(quantity)',
                'condition' => 'allocation_end_date >="' . date('Y-m-d') . '"'),*/
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'part_number' => 'Part Number',
            'generic_id' => 'Generic Name',
            'alias_name' => 'Alias Name',
            'description' => 'Description',
            'brand_class_id' => 'Brand/Class',
            'rate' => 'Rate',
            'unit_id' => 'Unit',
            'inventory_item_type' => 'Stock Item',
            'tax_code' => 'Tax Code',
            'weight' => 'Weight',
            'volume' => 'Volume',
            're_order_level' => 'Re Order Level',
            're_order_lot' => 'Re Order Lot',
            'hsir_code' => 'Hsir Code',
            'version' => 'Version',
            'bar_code' => 'Bar Code',
            'others' => 'Others',
            'notes' => 'Notes',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
            'isActive' => 'Is Active',
            'warehouse_id' => 'Warehouse',
            'rack_id' => 'Rack',
            'bin_id' => 'Bin',
            'length' => 'Length',
            'width' => 'Width',
            'height' => 'Height',
            'thickness' => 'Thickness',
            'material' => 'Material',
            'finished' => 'Finished',
            'machine_id' => 'Machine No',
            'machine_type' => 'Machine Type',
            'packing' => 'Packing',
            'capacity' => 'Capacity'
        );
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Store the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getFullname() {
        return ($this->part_number . ' : ' . $this->description);
    }

    public static function getProducts() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'part_number'));
        return CHtml::listData($model, 'id', 'fulldetails');
    }

    public function save_ledger() {
        if (isset(Yii::app()->modules['finance'])) {
            Yii::import('application.modules.finance.models.*');

            //configuration
            $service_sales = 106;
            $employee_subledger_type = 3;

            $existence = FinanceLegder::model()->find(array('condition' => 'parent_id=' . (int) $this->id));
            if ($existence->id > 0) {
                FinanceLegder::model()->updateBypk(
                        $existence->id,
                        array(
                            'description' => $this->part_number,
                        )
                );
            } else {

                $parentModel = FinanceLegder::model()->findByPk($service_sales);
                $count_of_child = FinanceLegder::model()->count(array('condition' => 'parent_account=' . $service_sales));
                if ($count_of_child > 0) {
                    $account_no = Yii::app()->db->createCommand('SELECT MAX(account_no)+1 AS account_no FROM {{finance_legder}} WHERE parent_account=' . $service_sales)->queryScalar();
                } else {
                    $account_no = $parentModel->account_no . '1';
                }
                $exist = true;
                while ($exist) {
                    $existenceModel = FinanceLegder::model()->find(array('condition' => 'account_no=' . $account_no));
                    if ($existenceModel->id > 0) {
                        $account_no += 1;
                    } else {
                        $exist = false;
                    }
                }

                $newLedger = new FinanceLegder;
                $newLedger->account_no = $account_no;
                $newLedger->description = $this->part_number;
                $newLedger->type_of_account = 'P';
                $newLedger->main_account_type = 'I';
                $newLedger->parent_account = $parentModel->id;

                $root_array = ($parentModel->root != null) ? array($parentModel->root, $newLedger->parent_account) : array($newLedger->parent_account);
                $newLedger->root = implode(',', $root_array);

                $newLedger->level = $parentModel->level + 1;
                $newLedger->sort_order = 1;
                $newLedger->haveSubledger = 'Y';
                $newLedger->subledger_types = $employee_subledger_type;
                $newLedger->system_generated = 'Y';
                $newLedger->parent_id = $this->id;
                $newLedger->created_by = Yii::app()->user->id;
                $newLedger->created_datetime = date('Y-m-d');
                $newLedger->save(false);
            }
        }
    }
    
    
     //code added on 16-08-2022 by sarika to get the total quantity
    public  function gettotalQuantity(){
        if($this->id){
            $sql="SELECT IFNULL(SUM(quantity),0) AS totalQuantity FROM view_all_stock_items WHERE id=".$this->id ;
            $total_qty=Yii::app()->db->createCommand($sql)->queryScalar();
            
            $modelMasInventoryWarehouse=new MasInventoryWarehouse();
            
            $damage_warehouse_id=$modelMasInventoryWarehouse->find(array('condition'=>'warehouse_code="DAM"'))->id;
            
            $SQL="SELECT IFNULL(SUM(quantity),0) AS damage_quantity FROM erp_stock_ledger WHERE product_id=".$this->id.' AND warehouse_id='.$damage_warehouse_id ;
            $total_damage_qty=(float) Yii::app()->db->createCommand($SQL)->queryScalar();
            
            $total_qty = $total_qty - $total_damage_qty;
            return (float) $total_qty;
        }
    }
    public  function gettotal_allocated_quantity(){
        if($this->id){
            $sql="SELECT SUM(allocated_qty) AS totalQuantity FROM view_all_stock_items WHERE id=".$this->id ;
            $allocated_qty=Yii::app()->db->createCommand($sql)->queryScalar();
            return (float) $allocated_qty;
        }
    }
}
