<?php

/**
 * This is the model class for table "{{production_order_requsition}}".
 *
 * The followings are the available columns in table '{{production_order_requsition}}':
 * @property integer $id
 * @property integer $production_order_id
 * @property integer $product_id
 * @property string $product_name
 * @property string $product_description
 * @property string $quantity
 * @property integer $unit_id
 * @property string $unit_name
 * @property string $supplier_name
 * @property integer $purchase_order_no
 * @property string $expected_date
 * @property integer $po_component_id
 * @property string $requisition_flag
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ProductionOrderRequsition extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{production_order_requsition}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('production_order_id, product_id, product_name, product_description, quantity, unit_id, unit_name, supplier_name, purchase_order_no, expected_date, po_component_id, created_by, created_date_time, updated_by, updated_date_time', 'required'),
			array('production_order_id, product_id, unit_id, purchase_order_no, po_component_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('product_name', 'length', 'max'=>255),
			array('product_description', 'length', 'max'=>500),
			array('quantity', 'length', 'max'=>10),
			array('unit_name', 'length', 'max'=>50),
			array('supplier_name', 'length', 'max'=>100),
			array('requisition_flag', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, production_order_id, product_id, product_name, product_description, quantity, unit_id, unit_name, supplier_name, purchase_order_no, expected_date, po_component_id, requisition_flag, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
           // 'unitdetails' => array(self::BELONGS_TO, 'Unit', 'unit'),
            'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
            'productction_order' => array(self::BELONGS_TO, 'ProductionOrder', 'production_order_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'production_order_id' => 'Production Order',
			'product_id' => 'Product',
			'product_name' => 'Product Name',
			'product_description' => 'Product Description',
			'quantity' => 'Quantity',
			'unit_id' => 'Unit',
			'unit_name' => 'Unit Name',
			'supplier_name' => 'Supplier Name',
			'purchase_order_no' => 'Purchase Order No',
			'expected_date' => 'Expected Date',
			'po_component_id' => 'Po Component',
			'requisition_flag' => 'Requisition Flag',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('production_order_id',$this->production_order_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('product_name',$this->product_name,true);
		$criteria->compare('product_description',$this->product_description,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('unit_name',$this->unit_name,true);
		$criteria->compare('supplier_name',$this->supplier_name,true);
		$criteria->compare('purchase_order_no',$this->purchase_order_no);
		$criteria->compare('expected_date',$this->expected_date,true);
		$criteria->compare('po_component_id',$this->po_component_id);
		$criteria->compare('requisition_flag',$this->requisition_flag,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductionOrderRequsition the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
