<?php

/**
 * This is the model class for table "{{production_order_bom_details}}".
 *
 * The followings are the available columns in table '{{production_order_bom_details}}':
 * @property integer $id
 * @property integer $production_order_id
 * @property integer $product_id
 * @property string $product_name
 * @property string $product_description
 * @property string $quantity
 * @property integer $unit_id
 */
class ProductionOrderBomDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{production_order_bom_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, product_name, product_description, quantity, unit_id', 'required'),
			array('production_order_id, product_id, unit_id', 'numerical', 'integerOnly'=>true),
			array('product_name, product_description', 'length', 'max'=>255),
			array('quantity,available_qty,bom_qty', 'length', 'max'=>10),
			array('cost_rate', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, production_order_id, product_id, product_name, product_description, quantity, unit_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
           // 'unitdetails' => array(self::BELONGS_TO, 'Unit', 'unit'),
            'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
            'productction_order' => array(self::BELONGS_TO, 'ProductionOrder', 'production_order_id'),

        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'production_order_id' => 'Po Order',
			'product_id' => 'Product',
			'product_name' => 'Product Name',
			'product_description' => 'Product Description',
			'quantity' => 'Quantity',
			'unit_id' => 'Unit',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('production_order_id',$this->production_order_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('product_name',$this->product_name,true);
		$criteria->compare('product_description',$this->product_description,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('unit_id',$this->unit_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductionOrderBomDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
