<?php

class GoodsissueController extends Controller
{

 
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails','Updatedefaulthrs'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetGoodsIssue','GetListProGoodsIssue','CreateGoodsIssue','SaveGI'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }
      public function actionIndex() {
        $this->render('index');
    }

       public function actionGetGoodsIssue() {
        $model = new ProductionGoodsIssue();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'order.id',
            2 => 'product.id',
            3 => 'product.description',
            4 => 'order.productionorder_date',
            5 => 'order.end_date',
            6 => 't.id',
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 'is_goods_issued="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.id LIKE '%" . $searchString . "%' OR order.id LIKE '%" . $searchString . "%' OR product.part_number LIKE '%" . $searchString . "%' OR t.description LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('product','order')->count(array('condition' => $condition));
        $model = $model->with('product','order')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $current = strtotime(date('y-m-d'));
        foreach ($model as $row)
        {
            //
            $div = '';
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["prod_gi_edit"])){
                //$div .= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'production/CreateBill&id='.$row['id'].'\',\''.$row['id'].'\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["prod_gi_print"])){
                $div .= ' <a class="btn btn-primary btn-xs" title="Print BOM" target="_blank" href="index.php?r=production/PrintProductionGIPDF&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            
            $rowData[] = array($row['id'],
                $row['order']['id'],
                $row['order']['product']['part_number'],
                $row['order']['description'], 
                date('d/m/Y',strtotime($row['order']['productionorder_date'])),
                date('d/m/Y',strtotime($row['order']['end_date'])),
                '<div class="btn-wrap text-center">'.$div.'</div>',
                 array('id' => $row['id'],'code'=>'Good issue print'));
   
                                
        } 
        
        $data['data'] = $rowData;
        echo json_encode($data);
    
    }

      public function actionGetListProGoodsIssue()
    {
        $model=new PackagingList();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 =>'transaction_id',
            1 =>'file_id',
            2 => 'customer_name',
            4 => 'transaction_date',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 'status="PRGI"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
                $searchString = $_POST['search']['value'];
                $condition.=" AND (transaction_id LIKE '%".$searchString."%' OR customer_name LIKE '%".$searchString."%' OR packing_frm LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'transaction_date desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m = 1;
        foreach ($model as $row)
        {
                $transaction_date=date("d/m/Y", strtotime($row->transaction_date));
                $rowData[]=array($row['transaction_id'],$transaction_date,$row['customer_name'],$row['packing_frm'],$row['status']);
                $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

        public function actionCreateGoodsIssue(){
        $model = new ProductionGoodsIssue();
        $modelItems = array(new ProductionGoodsIssueItem());
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model,'modelItems' =>$modelItems));
    }

      public function actionSaveGI()
    {


        $model = new ProductionGoodsIssue();
        $modelItem = array(new ProductionGoodsIssueItem());
        if (isset($_POST['ProductionGoodsIssue'])) {
            if ((int) @$_POST['ProductionGoodsIssue']['id'] > 0) {
                $model = $model->findByPK($_POST['ProductionOrder']['id']);
                $audit_type = 'UPDATED';
            } else {
                $model->crm_user_id = Yii::app()->user->id;
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
                $audit_type = 'CREATED';
            }
            $model->attributes          = $_POST['ProductionGoodsIssue'];
            $model->notes               =  $_POST['ProductionGoodsIssue']['notes'];
            $model->remarks             =  $_POST['ProductionGoodsIssue']['remarks'];
            $model->reference           =  $_POST['ProductionGoodsIssue']['reference'];
            $model->connected_file      =  $_POST['ProductionGoodsIssue']['connected_file'];
            $model->terms_and_conditions       =  $_POST['ProductionGoodsIssue']['terms_and_conditions'];
            $model->customer_id           =  $_POST['ProductionGoodsIssue']['customer_id'];
            $model->is_goods_issued       =  'Y';
            $model->warehouse_id           =  $_POST['ProductionGoodsIssue']['warehouse_id'];

            if ($_POST['ProductionGoodsIssue']['goods_issue_date'] != '') {
                $model->goods_issue_date = str_replace('/', '-', $_POST['ProductionGoodsIssue']['goods_issue_date']);
                $model->goods_issue_date = date("Y-m-d", strtotime($model->goods_issue_date));
            }

            $model->updated_by  = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
            $valid = $model->validate();
            $other_errors = array();
            
                   //   ---------------------AccAuditClose check------------------------------------
            

                $issue_datex = date("Y-m-d", strtotime(str_replace('/', '-',$_POST['ProductionGoodsIssue']['goods_issue_date'])));
                
                $modelAccAuditClose = new AccAuditClose();
                $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
                $issue_date = strtotime($issue_datex);
                if ($issue_date <= $existing_date) {
                $valid = false;
                $other_errors[] = ' Given Issue date must be greater than Audit Close date  :- ' .date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
                
                } 
            //   --------------------//-AccAuditClose check------------------------------------
            
            
            
            if (!empty($_POST['ProductionGoodsIssueItem'])) {
                foreach ($_POST['ProductionGoodsIssueItem'] as $k => $rowItem) {
                    if (empty($rowItem['id'])) {
                        $modelItem[$k] = new ProductionGoodsIssueItem();
                        $modelItem[$k]->created_by = Yii::app()->user->id;
                        $modelItem[$k]->created_datetime = date('Y-m-d h:i:s');
                    } else {
                        $modelItem[$k] = ProductionGoodsIssueItem::model()->findByPk($rowItem['id']);
                    }
                    $modelItem[$k]->attributes = $_POST['ProductionGoodsIssueItem'][$k];
                    //$modelItem[$k]->product_location_id = $rowItem['product_location_id']; 
                    $modelItem[$k]->picked_qty = $rowItem['picked_qty'];
                 
                    
                    $modelItem[$k]->production_goods_issue_id = 0;
                    $modelItem[$k]->updated_by  = Yii::app()->user->id;
                    $modelItem[$k]->updated_datetime = date('Y-m-d h:i:s');
                    $valid = $modelItem[$k]->validate() && $valid;
                }
            }

            if ($valid) {
                if ($model->save()) {
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'GOODS_ISSUE',
                        Yii::app()->user->id,
                        $audit_type,
                        " with PKG No: - {$model->id}  "
                    );
                    // end audit log

                    /*    $sum = 0; 
                   if (!empty($modelItem)) {
                        foreach ($modelItem as $eachItem) {
                            $eachItem->production_goods_issue_id = $model->id;
                            $sum += $eachItem->amount;
                            $eachItem->save();
                            
                        }
                    }
                    $model->updateByPk($model->id, array('grand_total' => $sum));*/



                    // ----------------------added by indhu 14_04_2023------------------------------------------------

                    $sum = 0;
                    if (!empty($modelItem)) {

                        $modelCustomer     = new Customer();
                        $modelRack         = new MasInvRack();
                        $modelBin          = new MasInvBin();
                        $modelProductClass = new ProductClass();
                        $modelUOM          = new UnitOfMeasurement();


                        if ((int)$model->warehouse_id > 0) {
                            $warehouse_id = $model->warehouse_id;
                        } else {
                            $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');;
                        }

                        $warehouse_name = '';
                        if ($warehouse_id > 0) {
                            $modwarehouse = new MasInventoryWarehouse();
                            $warehouse_name = $modwarehouse->getWarehouseName($warehouse_id);
                        }


                        foreach ($modelItem as $eachItem) {
                            if($eachItem->product_id>0){
                                $eachItem->rate = $eachItem->product->rate;
                                $eachItem->amount = $eachItem->product->rate * $eachItem->quantity ;
                            }

                            $eachItem->production_goods_issue_id = $model->id;
                            $sum += $eachItem->amount;
                            $eachItem->save();
                            // -------------------------------------------------------------------

                            $modelproduct_class = '';
                            if ((int)$eachItem->product->brand_class_id > 0) {
                                $modelproduct_class = $modelProductClass->findByPk($eachItem->product->brand_class_id)->product_class;
                            }

                            $modelcustomer_name = '';
                            if ((int)$model->customer_id > 0) {
                                $modelcustomer_name = $modelCustomer->findByPk($model->customer_id)->customer_name;
                            }

                            $modelUOM = $modelUOM->findByPk((int)  $eachItem->unit);
                            // ---------------------------
                            $modelStockLedger                                = new StockLedger();
                            $modelStockLedger->brand_id                      = $eachItem->product->brand_class_id;
                            $modelStockLedger->brand_name                    = $modelproduct_class;
                            $modelStockLedger->customer_vendor_id            = $model->customer_id;
                            $modelStockLedger->customer_vendor_name          = $modelcustomer_name;
                            $modelStockLedger->file_id                       = $model->file_id;
                            $modelStockLedger->header_id                     = $model->id;
                            $modelStockLedger->header_item_id                = $eachItem->id;
                            $modelStockLedger->product_id                    = $eachItem->product_id;
                            $modelStockLedger->product_name                  = $eachItem->product->part_number;
                            $modelStockLedger->product_description           = $eachItem->product->description;
                            $modelStockLedger->warehouse_id                  = $warehouse_id;
                            $modelStockLedger->warehouse_name                = $warehouse_name;
                            $modelStockLedger->rack_id                       = $modelRack->getDefaultRackId();
                            $modelStockLedger->rack_name                     = $modelRack->getRackName((int)$modelStockLedger->rack_id);
                            $modelStockLedger->bin_id                        = $modelBin->getDefaultBinId();
                            $modelStockLedger->bin_name                      = $modelBin->getBinName((int)$modelStockLedger->bin_id);
                            $modelStockLedger->unit_id                       =  $eachItem->unit;
                            $modelStockLedger->unit_name                     = $modelUOM->name;
                            $modelStockLedger->unit_factor                   =  $modelUOM->factor;
                            $modelStockLedger->quantity                      = -1 *  $eachItem->quantity;
                            $modelStockLedger->available_status              = 'U'; //U
                            $modelStockLedger->buying_price                  = 0;
                            $modelStockLedger->batch_no                      = '';
                            $modelStockLedger->serial_no                     = '';
                            $modelStockLedger->manufacturing_date            = '0000-00-00';
                            $modelStockLedger->expiry_date                   = '0000-00-00';
                            $modelStockLedger->cost_price                    = $eachItem->product->rate;
                            $modelStockLedger->transaction_cost_rate         = $eachItem->product->rate;
                            // $modelStockLedger->sales_price                    = $eachItem['rate']*$modelUOM->factor;
                            $modelStockLedger->sales_price                   = 0;
                            $modelStockLedger->transaction_date              = ($model->goods_issue_date != '' && $model->goods_issue_date != '0000-00-00') ? $model->goods_issue_date : '0000-00-00';
                            $modelStockLedger->transaction_from              = 'PRODUCTION_GOODS_ISSUE';
                            $modelStockLedger->transaction_type              = "OUT";
                            $modelStockLedger->stock_after_transaction       =   0;
                            $modelStockLedger->stock_value_after_transaction =   0;
                            $modelStockLedger->master_stock_ledger_id        =   0;
                            $modelStockLedger->stock_updated                 =  'Y';
                            $modelStockLedger->created_by                    = (int) $model->created_by;
                            $modelStockLedger->created_date                  = date("Y-m-d H:i:s");
                            $modelStockLedger->save(false);
                        }
                    }
                    // --------------end----------------------------

                    $model->updateByPk($model->id, array('grand_total' => $sum));



                    $jsonData['id'] = $model->id;
                    $jsonData['po'] = $model->findByPk($model->id);
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
            } else {
                $error1 = array();
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($modelItem[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one item";
                $error = CJSON::encode(array_merge_recursive($error2, $error1, $other_errors));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    

}