<?php

class DefaultController extends Controller {

	/* public function init()
	{
		/* $this->layout = $this->module->layout;
		$this->defaultAction = 'index'; 
		
		
	} */
	
	public function accessRules() {
		return array(
				array('allow', // allow all users to perform 'index' and 'view' actions
						'actions' => array('login', 'error', 'logout', 'TableRo', 'Forgotpassword', 'Recover'),
						'users' => array('*'),
				),
				array('allow', // allow authenticated user to perform 'create' and 'update' actions
						'actions' => array('CostPrice','Index','SalesPrice','salespricegroupname','SaveGroup',
                                                    'DownloadSalesPriceList','SaveSalesPricingGroup','UploadPriceList','GetProfitItemDetails',
                                                    'UnApproveProfitCalculation','ApproveProfitCalculation','GetFilesForProfit'),
						'expression' => '$user->isMember()',
				),
				array('deny', // deny all users
						'users' => array('*'),
				),
		);
	}
	
    public function actionIndex() 
    {
    	//$model = new ProfitCalc();
    	
        $this->render('index'/*,array('model'=>$model)*/);
    }
    
    public function actionCostPrice()
    {
    	$model=new CostPriceGroup();
    	$this->render('view_cost_price',array('model'=>$model));
    }
    
    public function actionSalesPrice()
    {
    	$model=new SalesPriceGroup();
    	$this->render('view_sales_price',array('model'=>$model));
    }
   /*  public function actionSaveSalesPricingGroup()
    {
    	$price_list_file_name = $_POST['SalesPriceGroup']['sales_price_group_file_name'];
    	 
    	$pricing_list = $this->readCSV("pricelistfiles/" . $price_list_file_name);
    	$jsonData = array();
    	foreach (array_slice($pricing_list, 1) as $i => $eachItem) {
    		 
    		$part_number = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
    		//echo strlen($part_number)."<br>";
    
    		if (strlen($part_number) > 0) {
    			
    			 
    			$base_sales_price = 0;
    			if(isset($eachItem[1]) && $eachItem[1]!="" && $eachItem[1]!=0)
    			{
    				$base_sales_price = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
    			}
    			 
    			 
    			$price1 = 0;
    			if(isset($eachItem[2]) && $eachItem[2]!="" && $eachItem[2]!=0)
    			{
    				$price1 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
    			}
    			 
    			$price2 = 0;
    			if(isset($eachItem[3]) && $eachItem[3]!="" && $eachItem[3]!=0)
    			{
    				$price2 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
    			}
    			 
    			$price3 = 0;
    			if(isset($eachItem[4]) && $eachItem[4]!="" && $eachItem[4]!=0)
    			{
    				$price3 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
    			}
    
    			$price4 = 0;
    			if(isset($eachItem[5]) && $eachItem[5]!="" && $eachItem[5]!=0)
    			{
    				$price4 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));
    			}
    			 
    			$price5 = 0;
    			if(isset($eachItem[6]) && $eachItem[6]!="" && $eachItem[6]!=0)
    			{
    				$price5 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));
    			}
    			
    			$price6 = 0;
    			if(isset($eachItem[7]) && $eachItem[7]!="" && $eachItem[7]!=0)
    			{
    				$price6 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));
    			}
    			
    			$price7 = 0;
    			if(isset($eachItem[8]) && $eachItem[8]!="" && $eachItem[8]!=0)
    			{
    				$price7 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[8]), '"'));
    			}
    			 
    			$product_model = Store::model()->find('part_number="' . $part_number . '"');
    			
    			if(count($product_model) > 0)
    			{
    				$model 										= new SalesPriceGroup();
    	    
    				$arr_sales_price_group 						= SalesPriceGroup::model()->find(array('condition'=>'product_id='.$product_model->id));
    	    
    				$model->id = 0;
    				if(count($arr_sales_price_group) > 0){
    					$model->id 		= 	$arr_sales_price_group->id;
    					$model			=	$model->findByPk($arr_sales_price_group->id);
    
    					$model->product_id 								= $product_model->id;
    					if($base_sales_price>0)
    					{
    						$model->base_sales_price 					= $base_sales_price;
    					}
    					if($price1 > 0)
    					{
    						$model->sales_price1 						= $price1;
    					}
    					if($price2 > 0)
    					{
    						$model->sales_price2 						= $price2;
    					}
    					if($price3 > 0)
    					{
    						$model->sales_price3 						= $price3;
    					}
    					if($price4 > 0)
    					{
    						$model->sales_price4 						= $price4;
    					}
    					if($price5 > 0)
    					{
    						$model->sales_price5 						= $price5;
    					}
    
    
    					$model->sales_price_group_file_name 		= $price_list_file_name;
    					$model->uploaded_by 						= Yii::app()->user->id;
    					$model->uploaded_date 						= date('Y-m-d h:i:s');
    
    					$model->save();
    					$jsonData['msg'][]= "Item " . $eachItem[0] . " price found and updated!";
    
    				}
    				else
    				{
    					$model->product_id 							= $product_model->id;
    					$model->base_sales_price 					= $base_sales_price;
    					$model->sales_price1 						= $price1;
    					$model->sales_price2 						= $price2;
    					$model->sales_price3 						= $price3;
    					$model->sales_price4 						= $price4;
    					$model->sales_price5 						= $price5;
    					$model->sales_price_group_file_name 		= $price_list_file_name;
    					$model->uploaded_by 						= Yii::app()->user->id;
    					$model->uploaded_date 						= date('Y-m-d h:i:s');
    					$model->save();
    					$jsonData['msg'][]= "Item " . $eachItem[0] . " price found and added!";
    				}
    		   
    			}
    			else
    			{
    				
    				//New product added from here
    				
    				
    				
    				$jsonData['part_number'][] = $part_number;
    			}
    
    		}
    	}
    	$jsonData['errors']="";
    	if(count($jsonData['part_number']) > 0 && $jsonData['part_number'][0]!="")
    	{
    		$jsonData['errors'][]="Please add the following part number into inventory <br>".implode("<br>", $jsonData['part_number']);
    	}
    	$jsonData['model'] = $model;
    	$jsonData['status'] = "success";
    
    	echo CJSON::encode($jsonData);
    } */
    
    
    public function actionSaveSalesPricingGroup()
    {
    	
    	$price_list_file_name = $_POST['SalesPriceGroup']['sales_price_group_file_name'];
    
    	$pricing_list = $this->readCSVProfit("pricelistfiles/" . $price_list_file_name);
    	$jsonData = array();
    	foreach (array_slice($pricing_list, 1) as $i => $eachItem) {
    		 
    		$part_number = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
    		$description = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
    		$brand_class = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
    		$unit = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
    		$tax_code = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
    		$warehouse = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));
    		
    		if (strlen($part_number) > 0) {
    			 
    
    			$base_sales_price = 0;
    			if(isset($eachItem[9]) && $eachItem[6]!="" && $eachItem[6]!=0)
    			{
    				$base_sales_price = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));
    			}
    
    
    			$price1 = 0;
    			if(isset($eachItem[7]) && $eachItem[7]!="" && $eachItem[7]!=0)
    			{
    				$price1 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));
    			}
    
    			$price2 = 0;
    			if(isset($eachItem[8]) && $eachItem[8]!="" && $eachItem[8]!=0)
    			{
    				$price2 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[8]), '"'));
    			}
    
    			$price3 = 0;
    			if(isset($eachItem[9]) && $eachItem[9]!="" && $eachItem[9]!=0)
    			{
    				$price3 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[9]), '"'));
    			}
    
    			$price4 = 0;
    			if(isset($eachItem[10]) && $eachItem[10]!="" && $eachItem[10]!=0)
    			{
    				$price4 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[10]), '"'));
    			}
    
    			$price5 = 0;
    			if(isset($eachItem[11]) && $eachItem[11]!="" && $eachItem[11]!=0)
    			{
    				$price5 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[11]), '"'));
    			}
    			 
    			$price6 = 0;
    			if(isset($eachItem[12]) && $eachItem[12]!="" && $eachItem[12]!=0)
    			{
    				$price6 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[12]), '"'));
    			}
    			 
    			$price7 = 0;
    			if(isset($eachItem[13]) && $eachItem[13]!="" && $eachItem[13]!=0)
    			{
    				$price7 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[13]), '"'));
    			}
    
    			$product_model = Store::model()->find('part_number="' . $part_number . '"');
    			
    			
    			$arr_default_ware_house_details = MasInventoryWarehouse::getDefaultWarehouse();
    			
    			
    			if(empty($product_model)){
    				$product_model = new Store;
    				$product_model->part_number = $part_number;
    				$product_model->description = $description;
    				
    				/*********** START Unit ***************************************************/
    				if (!empty($unit)) {
    					$modelUnit = Unit::model()->find('symbol="' . $unit . '"');
    					if ($modelUnit === null) {
    						$modelUnit = new Unit;
    						$modelUnit->symbol = trim($unit);
    						$modelUnit->isActive = "Y";
    						$modelUnit->created_by = Yii::app()->user->id;
    						$modelUnit->created_datetime = date("Y-m-d h:i:s");
    						$modelUnit->save(false);
    						$modelUnit->refresh();
    					}
    					$product_model->unit_id = $modelUnit->id;
    				}
    				/*********** END Unit ***************************************************/
    				
    				/*********** START Product Class ***************************************************/
    				
    				$modelProductClass = ProductClass::model()->find('product_class="' . $product_class . '"');
    				if ($modelProductClass == null) {
    				$modelProductClass = new ProductClass;
    				$modelProductClass->product_class = $product_class;
    				$modelProductClass->save(false);
    				$modelProductClass->refresh();
    				$jsonData['errors'][] = "Product class " . $product_class . " not found! Adding to the system<br/>";
    				}
    				
    				$product_model->brand_class_id = $modelProductClass->id;
    				
    				/*********** END Product Class ***************************************************/
    				
    				    				
    				/*********** START Tax Code ***************************************************/
    				if (!empty($tax_code)) {
    				$modelTax = MasInvTax::model()->find('tax_code="' . $tax_code . '"');
    				if ($modelTax === null) {
    				$modelTax = new MasInvTax;
    				$modelTax->tax_code = $tax_code;
    				$modelTax->isActive = "Y";
    				$modelTax->created_by = Yii::app()->user->id;
    				$modelTax->created_datetime = date("Y-m-d h:i:s");
    				$modelTax->save(false);
    				$modelTax->refresh();
    				}
    				}
    				
    				$product_model->tax_code = $modelTax->id;
    				
    				/*********** END Tax Code ***************************************************/
    				
    				
    				/*********** START Warehouse ***************************************************/
    				
    				
    				
    				$product_model->default_warehouse_id = $arr_default_ware_house_details->id;
    				
    				
    				
    				$new_ware_house_id =0;
    				if (!empty($warehouse)) {
    					$modelWarehouse = MasInventoryWarehouse::model()->find('warehouse_name="' . $warehouse . '"');
    					if ($modelWarehouse === null) {
    						$modelWarehouse = new MasInventoryWarehouse;
    						$modelWarehouse->warehouse_name = $warehouse;
    						$modelWarehouse->isActive = "Y";
    						$modelWarehouse->isBaseWareHouse = "N";
    						$modelWarehouse->created_by = Yii::app()->user->id;
    						$modelWarehouse->created_datetime = date("Y-m-d h:i:s");
    						$modelWarehouse->save(false);
    						
    						$new_ware_house_id = (int) $modelWarehouse->id;
    						$modelWarehouse->refresh();
    					}
    				}
    				/*********** END Warehouse ***************************************************/
    				
    				$product_model->inventory_item_type = 1;
    				$product_model->isActive = "Y";
    				$product_model->created_by = Yii::app()->user->id;
    				$product_model->created_date_time = date("Y-m-d h:i:s");
    				
    				$product_model->save(false);
    				
    				$product_model = Store::model()->find('part_number="' . $part_number . '"');
    				
    				/***************** Default Ware house *********************/
    				$modelProductLocation = new ProductLocation();
    				
    				$modelProductLocation->stock_id = $product_model->id;
    				$modelProductLocation->bin = 0;
    				$modelProductLocation->rack = 0;
    				$modelProductLocation->warehouse_id = $arr_default_ware_house_details->id;
    				$modelProductLocation->is_default_warehouse_id = "Y";
    				$modelProductLocation->quantity = 0;
    				$modelProductLocation->created_by = Yii::app()->user->id;
    				$modelProductLocation->created_date_time = date("Y-m-d h:i:s");
    				$modelProductLocation->save(false);
    				/***************** Default Ware house *********************/
    				
    				/***************** New Ware house *********************/
    				if($new_ware_house_id > 0){
	    				$modelProductLocation = new ProductLocation();
	    				
	    				$modelProductLocation->stock_id = $product_model->id;
	    				$modelProductLocation->bin = 0;
	    				$modelProductLocation->rack = 0;
	    				$modelProductLocation->warehouse_id = $new_ware_house_id;
	    				$modelProductLocation->is_default_warehouse_id = "N";
	    				$modelProductLocation->quantity = 0;
	    				$modelProductLocation->created_by = Yii::app()->user->id;
	    				$modelProductLocation->created_date_time = date("Y-m-d h:i:s");
	    				$modelProductLocation->save(false);
    				}
    				/***************** New Ware house *********************/
    				
    				/*************** Opening Balance **********************/
    				$modelOpeningBalance = new OpeningBalance();
    				$modelOpeningBalance->product_id=$product_model->id;
    				$modelOpeningBalance->opening_quantity=0;
    				$modelOpeningBalance->save(false);
    				/*************** Opening Balance **********************/
    				$jsonData['msg'][]= "New Item [" . $part_number . "] found and added!";
    				
    				
    			}
    			
    			
    			 
    			if(count($product_model) > 0)
    			{
    				$model 										= new SalesPriceGroup();
    					
    				$arr_sales_price_group 						= SalesPriceGroup::model()->find(array('condition'=>'product_id='.$product_model->id));
    					
    				$model->id = 0;
    				if(count($arr_sales_price_group) > 0){
    					$model->id 		= 	$arr_sales_price_group->id;
    					$model			=	$model->findByPk($arr_sales_price_group->id);
    
    					$model->product_id 								= $product_model->id;
    					if($base_sales_price>0)
    					{
    						$model->base_sales_price 					= $base_sales_price;
    					}
    					if($price1 > 0)
    					{
    						$model->sales_price1 						= $price1;
    					}
    					if($price2 > 0)
    					{
    						$model->sales_price2 						= $price2;
    					}
    					if($price3 > 0)
    					{
    						$model->sales_price3 						= $price3;
    					}
    					if($price4 > 0)
    					{
    						$model->sales_price4 						= $price4;
    					}
    					if($price5 > 0)
    					{
    						$model->sales_price5 						= $price5;
    					}
    					if($price6 > 0)
    					{
    						$model->sales_price6 						= $price6;
    					}
    					if($price7 > 0)
    					{
    						$model->sales_price7 						= $price7;
    					}
    
    					$model->sales_price_group_file_name 		= $price_list_file_name;
    					$model->part_number 						= $part_number;
    					
    					if($description!='Description' && $description!="")
    					{
    						$model->product_description 			= $description;
    					}
    					else
    					{
    						$model->product_description 			= $product_model->description;
    					}
    					
    					if($brand_class!='Class/Brand' && $brand_class!="")
    					{
    						$model->brand_class 					= $brand_class;
    					}
    					else
    					{
    						$model->brand_class 					= $product_model->brand_detail->product_class;
    					}
    					
    					if($unit!='Unit' && $unit!="")
    					{
    						$model->unit 								= $unit;
    					}
    					else
    					{
    						$model->unit								= $product_model->unit->symbol;
    					}
    					
    					if($tax_code!='Tax Code' && $tax_code!="")
    					{
    						$model->tax_code 							= $tax_code;
    					}
    					else
    					{
    						$model->tax_code 							= $product_model->tax->tax_code;;
    					}
    					
    					if($warehouse!='Warehouse' && $warehouse!="")
    					{
    						$model->ware_house 							= $warehouse;
    					}
    					else
    					{
    						$model->ware_house 							= $arr_default_ware_house_details->warehouse_name;
    					}
    					
    					$model->uploaded_by 						= Yii::app()->user->id;
    					$model->uploaded_date 						= date('Y-m-d h:i:s');
    					
    					
    					/* echo '<pre>';
    					print_r($model->attributes);
    					exit; */
    
    					$model->save();
    					$jsonData['msg'][]= "Item " . $eachItem[0] . " price found and updated!";
    
    				}
    				else
    				{
    					$model->product_id 							= $product_model->id;
    					$model->base_sales_price 					= $base_sales_price;
    					$model->sales_price1 						= $price1;
    					$model->sales_price2 						= $price2;
    					$model->sales_price3 						= $price3;
    					$model->sales_price4 						= $price4;
    					$model->sales_price5 						= $price5;
    					$model->sales_price6 						= $price6;
    					$model->sales_price7 						= $price7;
    					$model->sales_price_group_file_name 		= $price_list_file_name;
    					$model->uploaded_by 						= Yii::app()->user->id;
    					$model->uploaded_date 						= date('Y-m-d h:i:s');
    					
    					
    					/* echo '<pre>';
    					print_r($model->attributes);
    					exit; */
    					
    					$model->save();
    					$jsonData['msg'][]= "Item " . $eachItem[0] . " price found and added!";
    				}
    					
    			}
    			
    
    		}
    	}
    	$jsonData['errors']="";
    	if(count($jsonData['part_number']) > 0 && $jsonData['part_number'][0]!="")
    	{
    		$jsonData['errors'][]="Please add the following part number into inventory <br>".implode("<br>", $jsonData['part_number']);
    	}
    	$jsonData['model'] = $model;
    	$jsonData['status'] = "success";
    
    	echo CJSON::encode($jsonData);
    }
    
    public function readCSVProfit($csvFile) {
    
    	$file_handle = fopen($csvFile, 'r');
    
    	while (!feof($file_handle)) {
    
    		$contents = fgetcsv($file_handle, 1024, ',');
    
    		if ($contents[1] == "")
    
    			$contents = explode(';', $contents[0]);
    
    		$line_of_text[] = $contents;
    
    	}
    
    	fclose($file_handle);
    
    	return $line_of_text;
    
    }
    
    public function actionDownloadSalesPriceList() {
    	//$filename = Yii::app()->getBaseUrl(true) . 'pricelistfiles/SALES_PRICE_LIST.csv';
    	$data = array();
    
    	$data[0][0] = 'Product';
    	$data[0][1] = 'Description';
    	$data[0][2] = 'Class/Brand';
    	$data[0][3] = "Unit";
    	$data[0][4] = "Tax Code";
    	$data[0][5] = "Warehouse";
    	$data[0][6] = "Base Sales Price";
    	$data[0][7] = "Price1";
    	$data[0][8] = "Price2";
    	$data[0][9] = "Price3";
    	$data[0][10] = "Price4";
    	$data[0][11] = "Price5";
    	$data[0][12] = "Price6";
    	$data[0][13] = "Price7";
    
    	$export_file_name="SALES_PRICE_LIST.csv";
    	$this->array_to_csv_download($data, // this array is going to be the second row
    			$export_file_name
    	);
    
    }
    
    
    
    public function actionSalespricegroupname()
    {
        $model = SalesPriceGroupName::model()->findAll(); 
       
        $this->render('view_sales_price_group_name',array('model'=>$model));
    }
    public function actionSaveGroup()
        {
            if (isset($_POST['SalesPriceGroupName'])) {
                    foreach ($_POST['SalesPriceGroupName'] as $i => $items) {
                        if ($items['id']>0) {
                            $modal_group[$i] = SalesPriceGroupName::model()->findByPK($items['id']);   
                        }else{
                            $modal_group[$i] = new SalesPriceGroupName;   
                        }
                        $modal_group[$i]->pricing_group_name  = $items['pricing_group_name'];
                        $modal_group[$i]->lowest_pricing_group = $items['lowest_pricing_group'];
                        
                        $validate = $modal_group[$i]->validate();                   
                    }
                }
                
                if($validate){
                    if(!empty($modal_group)){
                        foreach ($modal_group as $eachModel) {
                            $eachModel->save();   
                        }
                    }
                    $jsonData['status'] = 'success';
	                echo CJSON::encode($jsonData);
                }
                else{
                    $error1 = json_decode(CActiveForm::validate($modal_group, '', false), true); 
                    $error = CJSON::encode(array_merge_recursive($error1));
                    if ($error != '[]')
		               echo $error;
                }
            
            
        }
        
        
        public function actionUploadPriceList($folder = null) {
        	Yii::import("ext.EAjaxUpload.qqFileUploader");
        
        	$folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        	// make the directory to store the pic:
        	if (!is_dir($folder)) {
        		mkdir($folder, 0777, TRUE);
        		//chmod($folder, 0755);
        	}
        	$allowedExtensions = array();
        	$sizeLimit = 1 * 1024 * 1024; // maximum file size in bytes
        	$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        	$result = $uploader->handleUpload($folder);
        	$result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        	$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        
        	$fileName = $result['filename']; //GETTING FILE NAME
        	$this->CropIfImage($folder, $fileName, 100, 100);
        	echo $return; // it's array
        }
        
	public function actionGetProfitItemDetails($id=0)
	{
		$file_id = (int) Yii::app()->request->getParam('file_id');
		$price_group_id = (int) Yii::app()->request->getParam('price_group_id');
		
		
		$modelFile = new MasterFile();
		$modelProfit = new ProfitCalc();

		$modelFile 		= $modelFile->with('quote.items', 'order.items1')->findByPK($file_id, array('order' => 'items.id ASC,items1.id ASC'));
		
		
		$modelProfit 	= $modelProfit->with('items')->find(array('condition' => 'file_id=' . $file_id, 'order' => 'items.id ASC'));
		
		if(empty($modelProfit)){
			$modelProfit = new ProfitCalc();
		}
		
		if($price_group_id > 0)
		{
			$arr_default_pricing_group = SalesPriceGroupName::getSalesPricingGroupDetailsById($price_group_id);
			
			/* echo '<pre>';
			print_r($arr_default_pricing_group);
			exit; */
		}
		else
		{
			$arr_default_pricing_group = SalesPriceGroupName::getDefaulSalesPricingGroupDetails();
		}
	 	
		
		/* echo '<pre>';
		print_r($modelFile);
		exit; */
		$addition_amount = 0;
		$deduction_amount = 0;
		switch ($modelFile->current_process_status) {
			case 'Q':
				$model = $modelFile->quote;
				if((int) $model->id > 0){
					$addition_amount = (int) Yii::app()->db->createCommand('SELECT SUM(particular_value) AS addition_amount FROM crm_quotes_addition WHERE quotes_id='.$model->id)->queryScalar();
					$deduction_amount = (int) Yii::app()->db->createCommand('SELECT SUM(particular_value) AS deduction_amount FROM crm_quotes_deduction WHERE quotes_id='.$model->id)->queryScalar();
				}
				break;
			default:
				$model = $modelFile->order;
				if((int) $model->id > 0){
					$addition_amount = (int) Yii::app()->db->createCommand('SELECT SUM(particular_value) AS addition_amount FROM crm_order_addition WHERE order_id='.$model->id)->queryScalar();
					$deduction_amount = (int) Yii::app()->db->createCommand('SELECT SUM(particular_value) AS deduction_amount FROM crm_order_deduction WHERE order_id='.$model->id)->queryScalar();
				}
				break;
		}
		
		/* echo '<pre>';
		print_r($model->items);
		exit;  */
		Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
		$this->renderPartial('profit_calculation', array('file_id'=>$id,'model'=>$model,'modelFile'=>$modelFile,'modelProfit'=>$modelProfit,'arr_default_pricing_group'=>$arr_default_pricing_group,'addition_amount'=>$addition_amount,'deduction_amount'=>$deduction_amount), false, true);
		Yii::app()->end();
	}
	
	public function actionApproveProfitCalculation() {
	
		
		
		
		$_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
		
		
		
         /*Count of POST*/
        if(count($_POST) > 0){
        	
        $user_id 			= 	(int) Yii::app()->user->id;
        $file_id 			= 	(int) $_POST['file_id'];
        $net_selling_value 	= 	$_POST['net_selling_value'];
        $net_cost_value 	= 	$_POST['net_cost_value'];
        $pricing_group_id	= 	$_POST['price_group_id'];
        $profit_percentage	= 	$_POST['profit_percentage'];
        $net_profit_value	= 	$_POST['net_profit_value'];
		
        
        
		$modelProfit		=	new ProfitCalc();
		
		$profit_calc_details = $modelProfit->find(array('condition'=>'file_id='.$file_id));
	
		if(!empty($profit_calc_details)){
			$modelProfit->deleteAll(array('condition' => 'file_id=' . $file_id));
			$modelProfitCalcItem = new ProfitCalcItem();
			$profit_calc_id = $profit_calc_details->id;
			$modelProfitCalcItem->deleteAll(array('condition' => 'profit_calc_id=' . $profit_calc_id));
		}
	
		
	
		$modelProfit->crm_user_id 		= $user_id;
	
		$modelProfit->file_id 			= $file_id;
	
		$modelProfit->net_selling_value = $net_selling_value;
	
		$modelProfit->net_cost_value 	= $net_cost_value;
	
		$modelProfit->price_group_id 	= $pricing_group_id;
	
		$modelProfit->profit_percentage = $profit_percentage;
	
		$modelProfit->net_profit_value 	= $net_profit_value;
	
		$modelProfit->save();
	
		$profit_calc_id = $modelProfit->id;
		
		$modelProfit->refresh();
	
		$modelFile = new MasterFile();
		
		$modelFile = $modelFile->findByPK($file_id);
		
		
	
		switch ($modelFile->current_process_status) {
	
			case 'Q':
	
				$items = $modelFile->quote->items;
	
				break;
	
			case 'O':
	
				$items = $modelFile->order->items;
	
			default:
	
				$items = $modelFile->order->items;
	
				break;
		}
	
		$netcostvalue = 0;
		$arr_cost_pricing_group = array();
		$flag=0;
		foreach ($items as $eachItem) {
			if(!empty($eachItem->product->id))
			{
				$modelProduct = new Store();
				$product_details = $modelProduct->findbypk($eachItem->product->id);
				
				$actual_cost_price = 0;
				$costrate = 0;
				/* if(isset($product_details->rate))
				{
					$actual_cost_price = $product_details->rate;
					
				} */
				
				$modelSalesGroup = new SalesPriceGroup();
				$arr_sales_pricing_group = $modelSalesGroup->find(array('condition'=>'product_id='.$eachItem->product->id));
				
				
				
				if($pricing_group_id==1)
				{
					$costrate = $arr_sales_pricing_group->base_sales_price;
				}
				elseif($pricing_group_id==2)
				{
					$costrate = $arr_sales_pricing_group->sales_price1;
				}
				elseif($pricing_group_id==3)
				{
					$costrate = $arr_sales_pricing_group->sales_price2;
				}
				elseif($pricing_group_id==4)
				{
					$costrate = $arr_sales_pricing_group->sales_price3;
				}
				elseif($pricing_group_id==5)
				{
					$costrate = $arr_sales_pricing_group->sales_price4;
				}
				elseif($pricing_group_id==6)
				{
					$costrate = $arr_sales_pricing_group->sales_price5;
				}
				elseif($pricing_group_id==7)
				{
					$costrate = $arr_sales_pricing_group->sales_price6;
				}
				elseif($pricing_group_id==8)
				{
					$costrate = $arr_sales_pricing_group->sales_price7;
				}
				else
				{
					$costrate = $product_details->rate;
				}
				
				
	
				$actual_cost_price = 0;
				if(isset($product_details->rate))
				{
					$actual_cost_price = $product_details->rate;;
				}
	
				$cost_price1 = 0;
				if(isset($arr_sales_pricing_group->base_sales_price))
				{
					$cost_price1 = $arr_sales_pricing_group->base_sales_price;
				}
	
				$cost_price2 = 0;
				if(isset($arr_sales_pricing_group->sales_price1))
				{
					$cost_price2 = $arr_sales_pricing_group->sales_price1;
				}
	
				$cost_price3 = 0;
				if(isset($arr_sales_pricing_group->sales_price2))
				{
					$cost_price3 = $arr_cost_pricing_group->sales_price2;
				}
	
				$cost_price4 = 0;
				if(isset($arr_sales_pricing_group->sales_price3))
				{
					$cost_price4 = $arr_cost_pricing_group->sales_price3;
				}
	
				$cost_price5 = 0;
				if(isset($arr_sales_pricing_group->sales_price4))
				{
					$cost_price5 = $arr_cost_pricing_group->sales_price4;
				}
	
				$cost_price6 = 0;
				if(isset($arr_sales_pricing_group->sales_price5))
				{
					$cost_price6 = $arr_cost_pricing_group->sales_price5;
				}
	
				$cost_price7 = 0;
				if(isset($arr_sales_pricing_group->sales_price6))
				{
					$cost_price7= $arr_cost_pricing_group->sales_price6;
				}
	
				$cost_price8 = 0;
				if(isset($arr_sales_pricing_group->sales_price8))
				{
					$cost_price8 = $arr_cost_pricing_group->sales_price8;
				}
				
				
	
				if($modelFile->current_process_status=='Q')
				{
					$modelQuotesItem = new QuotesItem();
					$modelQuotesItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price));
					//$modelQuotesItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price));
					//$modelQuotesItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price, 'cost_price1' => $cost_price1, 'cost_price2' => $cost_price2, 'cost_price3' => $cost_price3, 'cost_price4' => $cost_price4, 'cost_price5' => $cost_price5, 'cost_price6' => $cost_price6, 'cost_price7' => $cost_price7, 'cost_price8' => $cost_price8));
				}
				else if($modelFile->current_process_status=='O')
				{
					$modelOrderItem = new OrderItem();
					$modelOrderItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price));
					//$modelOrderItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price));
					//$modelOrderItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price, 'cost_price1' => $cost_price1, 'cost_price2' => $cost_price2, 'cost_price3' => $cost_price3, 'cost_price4' => $cost_price4, 'cost_price5' => $cost_price5, 'cost_price6' => $cost_price6, 'cost_price7' => $cost_price7, 'cost_price8' => $cost_price8));
				}
	
	
				//For approval history
				/* if($price_group_id==1)
				{
					$costrate = $arr_cost_pricing_group->cost_price1;
				}
				elseif($price_group_id==2)
				{
					$costrate = $arr_cost_pricing_group->cost_price2;
				}
				elseif($price_group_id==3)
				{
					$costrate = $arr_cost_pricing_group->cost_price3;
				}
				else
				{
					$costrate = $product_details->rate;
				} */
	
				$netcostvalue 	= $netcostvalue + ($costrate * $eachItem->quantity);
				$netsellingvalue = $eachItem->parent->netAmount * $eachItem->parent->exchange_rate;
				//$netsellingvalue = $eachItem->parent->netAmount;
				
				
				
				$modelProfitCalcItem = new ProfitCalcItem();
				
				
				$modelProfitCalcItem->profit_calc_id = $profit_calc_id;
				$modelProfitCalcItem->product_id = $eachItem->product->id;
				$modelProfitCalcItem->product_part_number = $eachItem->product->part_number;
				$modelProfitCalcItem->product_description = $eachItem->product->description;
				$modelProfitCalcItem->product_quantity = $eachItem->quantity;
				$modelProfitCalcItem->product_unit =$eachItem->unit_id;
				$modelProfitCalcItem->selling_value_per_unit = $eachItem->rate;
				$modelProfitCalcItem->cost_value_per_unit = $costrate;
				$modelProfitCalcItem->total_selling_value = ($eachItem->rate * $eachItem->quantity);
				$modelProfitCalcItem->total_cost_value = ($costrate * $eachItem->quantity);
				
				$modelProfitCalcItem->save(false);
	
				$flag=1;
			}
		}
	
		if($flag > 0)
		{
			$profit = $netsellingvalue - $netcostvalue;
	
			$profit_in_percentage = ($netcostvalue > 0) ? round(($profit / $netcostvalue) * 100, 2) : 100;
	
			$modelFile->updateByPK(Yii::app()->request->getParam('file_id'), array('is_approved' => 'Y', 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));
	
			$modelFile->refresh();
	
			$modelApprovalHistory = new ApprovalHistory;
	
			$modelApprovalHistory->file_id = $modelFile->id;
	
			$modelApprovalHistory->status = "Y";
	
			$modelApprovalHistory->action_by = Yii::app()->user->id;
	
			$modelApprovalHistory->profit = $profit_in_percentage;
	
			$modelApprovalHistory->save(false);
	
			$jsonData['status'] = "success";
	
	
		}
		else
		{
			$jsonData['status'] = "failed";
		}
		echo CJSON::encode($jsonData);
		Yii::app()->end();
		//}
         }
         else
         {
         	$jsonData['status'] = "failed";
         	echo CJSON::encode($jsonData);
         }
	}
	
	public function actionUnApproveProfitCalculation() {

		$file_id = Yii::app()->request->getParam('file_id');
		$modelProfit =  new ProfitCalc();
		
		$profit_calc_details = $modelProfit->find(array('condition'=>'file_id='.$file_id));
		
		if(!empty($profit_calc_details)){
			$modelProfit->deleteAll(array('condition' => 'file_id=' . $file_id));
			$modelProfitCalcItem = new ProfitCalcItem();
			$profit_calc_id = $profit_calc_details->id;
			$modelProfitCalcItem->deleteAll(array('condition' => 'profit_calc_id=' . $profit_calc_id));
		}
		
		
		
		
		$modelFile = new MasterFile();
		$modelFile = $modelFile->findByPK($file_id);

		switch ($modelFile->current_process_status) {

			case 'Q':

				$items = $modelFile->quote->items;

				break;

			case 'O':

				$items = $modelFile->order->items;

			default:

				$items = $modelFile->order->items;

				break;
		}


		foreach ($items as $eachItem) {
			
			$modelProduct = new Store();
			$product_details = $modelProduct->findbypk($eachItem->product->id);

			$actual_cost_price = 0;
			$cost_price1 = 0;
			$cost_price2 = 0;
			$cost_price3 = 0; 
			$cost_price4 = 0; 
			$cost_price5 = 0; 
			$cost_price6 = 0; 
			$cost_price7 = 0; 
			$cost_price8 = 0; 

			if($modelFile->current_process_status=='Q')
			{
				$modelQuotesItem = new QuotesItem();
				//$modelQuotesItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price, 'cost_price1' => $cost_price1, 'cost_price2' => $cost_price2, 'cost_price3' => $cost_price3, 'cost_price4' => $cost_price4, 'cost_price5' => $cost_price5, 'cost_price6' => $cost_price6, 'cost_price7' => $cost_price7, 'cost_price8' => $cost_price8));
				$modelQuotesItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price));
				//$modelQuotesItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price, 'cost_price1' => $cost_price1, 'cost_price2' => $cost_price2, 'cost_price3' => $cost_price3));
			}
			else if($modelFile->current_process_status=='O')
			{
				$modelOrderItem = new OrderItem();
				$modelOrderItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price));
				//$modelOrderItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price, 'cost_price1' => $cost_price1, 'cost_price2' => $cost_price2, 'cost_price3' => $cost_price3, 'cost_price4' => $cost_price4, 'cost_price5' => $cost_price5, 'cost_price6' => $cost_price6, 'cost_price7' => $cost_price7, 'cost_price8' => $cost_price8));
				//$modelOrderItem->updateByPK($eachItem->id, array('actual_cost_rate' => $actual_cost_price, 'cost_price1' => $cost_price1, 'cost_price2' => $cost_price2, 'cost_price3' => $cost_price3));
			}
		}
		
		$modelFile = new MasterFile();
		
		$modelFile->updateByPK($file_id, array('is_approved' => 'N', 'date_of_approval' => '0000-00-00', 'approved_by' => '0'));

		$modelApprovalHistory = new ApprovalHistory;

		$modelApprovalHistory->file_id = $file_id;

		$modelApprovalHistory->status = "N";

		$modelApprovalHistory->action_by = Yii::app()->user->id;

		$modelApprovalHistory->save(false);

		$jsonData['status'] = "success";

		echo CJSON::encode($jsonData);

		Yii::app()->end();
	}
    //Code added by jisha on 22/11/2017 for autocomplete 
            
    public function actionGetFilesForProfit() 
    {
     
        $searchTerm = $_GET['term'];
        //coping from masterfile
//        $file_string   = "";
//        $approval_type_order = "";
//        $approval_type_quote = "";
//        if(isset(Yii::app()->user->havePermissionOn['approval_type_order']))
//        {
//            $approval_type_order = Yii::app()->user->havePermissionOn['approval_type_order'];
//        }
//        if(isset(Yii::app()->user->havePermissionOn['approval_type_quote']))
//        {
//            $approval_type_quote = Yii::app()->user->havePermissionOn['approval_type_quote'];
//        }

//        if(isset(Yii::app()->user->havePermissionOn['sop_profit_calc_change_pricing_group']) && Yii::app()->user->havePermissionOn['sop_profit_calc_change_pricing_group'] > 0)
//        {
//            $file_string = '"Q", "O", "PD", "D", "PI", "I", "C"';
//        }
//        else
//        {
//            if($approval_type_order=='sop_order_appr_by_val' || $approval_type_order=='sop_order_appr_by_pc')
//            {
//                $file_string = '"O"';
//            }
//            if($approval_type_quote=='sop_quote_appr_by_val' || $approval_type_quote=='sop_quote_appr_by_pc')
//            {
//                if($file_string!="")
//                    $file_string.=",";
//
//                $file_string.='"Q", "PD", "D", "PI", "I", "C"';
//            }
//        }
         $file_string ='"Q", "O"';
        //End code by Mereena
        //echo $file_string;
        $criteria  = new cdbCriteria;
        $condition  = 'isActive="Y"';
        if($file_string!="")
        {
            $condition.=' AND current_process_status in (' . $file_string . ')';
        }
         if((int) Yii::app()->user->havePermissionOn['sop_lead_viewall']==1 || (int) Yii::app()->user->havePermissionOn['sop_order_viewall']==1 || (int) Yii::app()->user->havePermissionOn['sop_delivery_viewall']==1 || (int) Yii::app()->user->havePermissionOn['sop_invoice_viewall']==1 || (int) Yii::app()->user->havePermissionOn['sop_credit_notes_viewall']==1 || Yii::app()->user->authorised_user == 1)
        {
             
        }
        else 
        {
         $condition.=' AND lead_owner_id='. Yii::app()->user->id;
        }
        //End copy by Mereena
        
        $condition .= 'AND id LIKE "%' . $searchTerm . '%" OR t.current_process_status LIKE "%' . $searchTerm . '%"';
        $model = new MasterFile();
        $model = $model->findAll(array('condition' => $condition, 'order' => 'id DESC,current_process_status'));
        //return CHtml::listData($model, 'id', 'id_with_status');
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->id.' : '.$eachModel->status;            
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();    
         
            
    }
   
}