<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'shiftupload-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<style>
    .bott_dec span{
        display: block;
        line-height: 20px;
        font-weight: normal;
        font-size: 12px !important;
        color: #4d4c4c;
        padding-left: 20px;
        letter-spacing: 0.25px;
    }
</style>
<?php
        $model_upload_shift = HrMasterUpload::model()->findByPK(12);
        $sizeLimitshift = $model_upload_shift->max_upload_size * 1024 * 1024;
    ?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
                <?php
                $allowedExtensions = array("csv");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => 'shiftcsv_0_upload_csv',
                    'config' => array(
                        'action' => Yii::app()->createUrl('hr/' . Yii::app()->controller->id . '/UploadEmployeecsv', array('folder' => 'uploads/shift')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => $sizeLimitshift,
                        'onStart' => "js:function(){}",
                        'class' => 'pull-right',
                        'onComplete' => "js:function(id, fileName, responseJSON){
                            shiftupload(responseJSON.filename)
                        }",
                )));
                ?>
            </li>
            <li class="col-sm-2">
                <div  id="csv_msg">
                </div>
            </li>
            <li class="col-sm-8 bott_dec">
                <span style="color: red;">* All fields in the excel are Mandatory *</span>
                <span style="color: red;">* Fill out shift type based upon the shift type master corresponding to <b><?= CHtml::link('Shift Type', array('masshift/index'), array('target' => '_blank')); ?></b> *</span>
                <span style="color: red;">* Fill the Shift Start Date in YYYY-mm-dd format *</span>
                <span style="color: red;">* Fill the Shift End Date in YYYY-mm-dd format *</span>
                <span style="color: red;">* Upload files in .csv format *</span>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::link('Download template', array('shift/downloadshiftformat'), array('target' => '_blank')); ?>
            </li>
        </ul>
    </div>
    <button type="button" class="btn btn-danger" style="display:none;" id="shiftupload_close" data-dismiss="modal">Close</button>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();

$cs->registerScript("shiftupload", "function shiftupload(filename)
{
    if(filename != ''){
      jQuery.ajax({
        'type': 'post',
        'dataType': 'json',
        'data': {
                filename: filename
        },
        'url'  : '" . Yii::app()->createUrl("hr/shift/SaveShiftUploadCsv") . "',
        'cache': false,
        'success': function (data) {
            if (data.status == 'success') {
                $('#loader').hide();
                if(data.error!=''){
                    $('#csv_msg').html(data.link);
                        $.each(data.error, function(key, val) {
                            t8.error(''+val+''); 
                    }); 
            }else{	
                t8.success('Details Uploaded Successfully');	
                reloadTable('#tbl_shift_time_details');
                $('#shiftupload_close').click();	
                }
          }
        },
        'beforeSend':function(){
            $('#loader').show();
        },
        'complete':function(){
            $('#loader').hide();
        }
      });
    }else{
        t8.error('File not found');

    }
}", CClientScript::POS_HEAD);
?>





