<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadwpsdetails",  "function loadwpsdetails(){  
    $('#tbl_salarysif_details').DataTable().destroy();
    var type= $('#salary_payment_type').val();		
    var month= $('#wps_month').val();		
    var wps_company= $('#wps_company_detail').val();  
    var salary_year_id = $('#salary_year_id').val();
    filterDataTable(type,month,wps_company,salary_year_id); 
};", CClientScript::POS_HEAD); 

$cs->registerScript("loadDetails", 'function filterDataTable(type,month,wps_company,year){
        var table_id ="#tbl_salarysif_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salarysif/GetSifList') . '",
                type: "POST",
                "data" : {
                    "month" : month,
                    "type" : type,
                    "wps_company" : wps_company,
                    "year":year                    
                },
                cache : false,
            },
            columns: [            
                {className: ""},
                {className: ""},
                {className: ""},
                {className: ""},
                {className: "text-right"}, 
            ],
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
               AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
	}	
		
    $(document).ready(function() {  	 	  
        var type= $("#salary_payment_type").val();	
        var month= $("#wps_month").val();
        var wps_company= $("#wps_company_detail").val();
        var salary_year_id = $("#salary_year_id").val();		
        filterDataTable(type,month,wps_company,salary_year_id);
        materializing(".material");
    });', CClientScript::POS_HEAD);

$cs->registerScript("deletesifdetail",  "function deletesifdetail(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {			
            jQuery.ajax({
              'type'  : 'post',
              'dataType':'json',
              'data'  : 'id=' + id,			  
              'url'  : $('#liveSite').val()+'index.php?r=hr/salarysif/deletesiffile',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){                  
                    reloadTable('#tbl_salarysif_details');
                    t8.success('Deleted SuccessFully!');
                }else {
                     t8.error('Error while Delete');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs->registerScript("connect_to_finance", "function connect_to_finance(id, flag) {
    if( confirm('Are you sure?') ){
        $('#loader').show();
        var url = ( flag == 'POST' ) ? '" . Yii::app()->createUrl('finance/hr/generateWps') . "' : '" . Yii::app()->createUrl('finance/hr/deleteWps') . "';
        var msg = ( flag == 'POST' ) ? 'Voucher Posted' : 'Voucher Unposted';
        jQuery.ajax({
            'dataType':'json',
            'data': { 'id':id }  ,
            'type':'post',
            'url': url,
            'cache': false,
            'success': function(data) {
                $('#loader').hide();
                if( data.status == 'success' ){
                    t8.success(msg);
                    reloadTable('#tbl_salarysif_details');
                }else
                    t8.success(data.msg);
            },
        });
    }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[5].sif_download !== 0) {
            items.sif = {
                name: "SIF",
                icon: "fa-file-text-o",
                callback: function () {
                    window.location.href = $('#liveSite').val() + "/index.php?r=hr/salarysif/downloadsif&id=" + datas[5].id;
                }
            };
        }
        if (datas[5].exchange_download !== 0) {
            items.exchange = {
                name: "Exchange",
                icon: "fa-exchange",
                callback: function () {
                    window.location.href = $('#liveSite').val() + "/index.php?r=hr/salarysif/downloadexcel&id=" + datas[5].id;
                }
            };
        }
        if (datas[5].payment_print_code !== 0) {
            items.printcode = {
                name: "Print(Code)",
                icon: "fa-file-pdf-o",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/salarysif/printsif&type=" + datas[5].salary_payment_mode + "&id=" + datas[5].id, "_blank");
                }
            };
        }
        if (datas[5].payment_print !== 0) {
            items.printwithoutcode = {
                name: "Print((Without Code))",
                icon: "fa-file-o",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/salarysif/printsif&frm=1&type=" + datas[5].salary_payment_mode + "&id=" + datas[5].id, "_blank");
                }
            };
        }
        if (datas[5].salary_sheet !== 0) {
            items.salarysheet = {
                name: "Salary Sheet",
                icon: "fa-file-excel-o",
                callback: function () {
                    window.location.href = $('#liveSite').val() + "/index.php?r=hr/salarysif/excelsheetsalary&type=" + datas[5].salary_payment_mode + "&id=" + datas[5].id;
                }
            };
        }
        if (datas[5].payment_delete !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash",
                callback: function () {
                    deletesifdetail(datas[5].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #salarypaymentindexdropdown .material-select-label {
        display: none;
    }
    </style>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame"> 
        <?php
        if($type==1){
            echo 'Salary-Cash';
        }else if($type==2){
            echo 'Salary-Cheque';
        }else if($type==3){
            echo 'Salary-WPS';
        }else if($type==4){
            echo 'Salary-Exchange';
        }else if($type==5){
            echo 'Salary-Bank';
        }
        ?>
        <div class="pull-right  dis-flx">
        <div class="material col-sm-12 pd-zero" id="salarypaymentindexdropdown"> 
        <span class="col-sm-3 pull-right">
            <?php echo CHtml::dropdownlist('wps_company_detail','',MasCompanyWpsDetails::getCompanyDetail(),  array('empty' => 'All','title' => 'WPS Company','data-search'=>true,'onchange'=>'loadwpsdetails();')); ?>                                    
           </span>
           <span class="col-sm-3 pull-right">
            <?php echo CHtml::dropdownlist('wps_month',date("m"),HrGenerelSettings::listMonths(),  array('empty' => 'All','title' => 'Salary Month','data-search'=>true,'onchange'=>'loadwpsdetails();')); ?>                   
          </span>
           <span class="col-sm-3 pull-right">
            <?php echo CHtml::dropdownlist('salary_year_id',date("Y"),HrGenerelSettings::listYears(4, 0),  array('empty' => 'Year','title' => 'Please Select Year','data-search'=>true,'onchange'=>'loadwpsdetails();','style'=>'width:100px;')); ?>
           </span>
           </div>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sif_file_add'])  || Yii::app()->user->authorised_user == 1) { ?>
             <a class="ad-btn"   onclick="loadPopupModal('hr/salarysif/create&type=<?php echo $type; ?>', 'Add New Salary Payment', 'xl')">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a> 
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <input type="hidden" id="salary_payment_type" name="salary_payment_type" value="<?php echo $type; ?>">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_salarysif_details" style="font-size:13px;width: 100%;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Date</th><th>
                        <?php
                        if($type==1 || $type==2){
                            echo 'Payment Mode';
                        }else if($type==3 || $type==4){
                            echo 'WPS Company';
                        }
                        ?>
                        </th>
                        <th>Month</th>  
                        <th>Total Amount</th>  
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>