<?php

Yii::import('application.modules.finance.models.*');

$form = $this->beginWidget('CActiveForm', array(
    'id' => 'salarysif-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
                <?php echo CHtml::dropdownlist('year', '', array( date('Y') => date('Y'), date("Y",strtotime("-1 year")) => date("Y",strtotime("-1 year")) ), array( 'data-label' => 'Year <span style="color : red;"> *</span>','data-search' => true)); ?>  
            </li>   
            <li class="col-sm-2">
                <?php echo CHtml::dropdownlist('sif_salary_month', '',HrGenerelSettings::listMonths(), array('prompt' => 'Select', 'data-label' => 'Month <span style="color : red;"> *</span>', 'title' => 'Please Select Month','data-search'=>true)); ?>
                <?php echo CHtml::hiddenField('salary_payment_type',$type); ?>
            </li>   
            <li class="col-sm-2">
                <?php echo $form->dropdownlist($model, 'wpscompany_id', MasCompanyWpsDetails::getCompanyDetail(), array('data-label' => 'Company <span style="color : red;"> *</span>', 'empty' => 'Select','data-search' => true)); ?>      
            </li> 
            <li class="col-sm-3">
                <?php echo CHtml::dropdownlist('company_branch_id', '',MasCompanyBranchSponsor::getCompanyBranches(), array( 'data-label' => 'Branch','data-search'=>true, 'empty' => 'Select','data-search' => true)); ?>  
            </li>
            <?php
            if($type==1 || $type==2 || $type==5){ 
                $array_mode=array(1=>'Cash',2=>'Cheque',5=>'Bank')
                ?>
            <li class="col-sm-2">
                <?php echo CHtml::textField('salary_payment_mode',$array_mode[$type], array('data-label' => 'Salary Payment', 'title' => 'Salary Payment','readonly'=>true)); ?>
            </li>
            <?php } ?>
            <?php
            if($type==2){ ?>
             <li class="col-sm-4">
                <?php echo CHtml::dropdownlist('transfer_bank_name','', MasBank::getbanks(), array( 'data-label' => 'Bank','empty'=>'Select','data-search' => true,'onchange'=>'$(".class_bank_1").val(this.value);')); ?>  
            </li>   
            <?php } ?>
            <li class="col-sm-12">
                <div class="btn-wrap text-center"> 
                    <a  class="btn btn-primary" href="javascript:void(0);" onclick="generatesiffile()">Load</a>
                </div>
            </li>   
        </ul>
        <div id="list_wpsemployee_details"></div>
    </div>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("generatesiffile", "function generatesiffile(){
    var month= $('#sif_salary_month').val();
    var type= $('#salary_payment_type').val();
    var branch_id= $('#company_branch_id').val();
    var transfer_bank_name= $('#transfer_bank_name').val();
    var wpscompany_id= $('#MonthlySalarySif_wpscompany_id').val();
    if((type==2 && transfer_bank_name!='' && month!='' && wpscompany_id!='') || ((type==1 || type==3 || type==4 || type==5) && wpscompany_id!='' && month!='')){
        jQuery.ajax({
           // 'dataType':'json',
            'data': {'month':month,'wps_company':wpscompany_id, year : $('#year').val(),'type':type,'bank_id':transfer_bank_name,'branch_id':branch_id }  ,
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/salarysif/generatesiffile') . "',    
            'cache': false,
            'success': function(data) {   
                $('#list_wpsemployee_details').html(data); 
            },
            'beforeSend': function(data) {        
                $('#loader').show();
            },
            'complete': function(data) {   
                 $('#loader').hide();
            }
        });
    }else{
        if(month==''){
            t8.error('Select month');
        }else if(wpscompany_id==''){
            t8.error('Company For WPS');
        }else if(type==2 && transfer_bank_name==''){
            t8.error('Select Bank');
        }          
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("getSubledger", "function getSubledger(value, field_id){
    jQuery.ajax({
        'type': 'post',
        'url': '" . Yii::app()->createUrl('finance/hr/getsubledgerdrop') . "',
        'data' : {'account' : value, 'model' : 'MonthlySalarySif', 'field' : 'sublegder_id' },
        'success': function(data) { 
            $('#'+field_id).html(data);
        }
    });
    
}", CClientScript::POS_HEAD);
?>
<script>
$(document).ready(function(){materializing(".material"); });
</script>