<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'upload_salary-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<style>
    .bott_dec span{
        display: block;
        line-height: 20px;
        font-weight: normal;
        font-size: 12px !important;
        color: #4d4c4c;
        padding-left: 20px;
        letter-spacing: 0.25px;
    }
</style>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <div class="material">    
                    <?php echo CHtml::dropDownList('salary_branch', '', MasCompanyBranchSponsor::getCompanyBranches(), array('class' => 'tooltipster', 'data-label' => 'Branch <span style="color : red;"> *</span>', 'empty' => 'Select')); ?>                                
                </div>
            </li>
            <li class="col-sm-3">
            <div class="material">
                <?php
                echo CHtml::dropDownList('salary_month','', HrGenerelSettings::listMonths(), array('class' => 'tooltipster', 'data-label' => 'Month <span style="color : red;"> *</span>', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">
                <?php
                echo CHtml::dropDownList('salary_year','', HrGenerelSettings::listYears(5, 0), array('class' => 'tooltipster', 'data-label' => 'Year <span style="color : red;"> *</span>', 'empty' => 'Select'));
                ?>
            </div>
        </li>
            <li class="col-sm-3">
                <?php
                $allowedExtensions = array("csv");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => rand(),
                    'config' => array(
                        'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/salarydetails')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => 2 * 1024 * 1024,
                        'onStart' => "js:function(){}",
                        'class' => 'pull-right',
                        'onComplete' => "js:function(id, fileName, responseJSON){
                            SalaryUpload(responseJSON.filename);
                        }",
                )));
                ?>
            </li>
            <li class="col-sm-2">
                <div  id="csv_msg">
                </div>
            </li>
            <li class="col-sm-8 bott_dec">
                <span>* <b>Employee Code,Basic Salary Details,Total Salary</b> are Mandatory *</span>
                <span>* Upload files in .csv format *</span>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::link('<i class="fa fa-download"></i> Download Template',array('salarymigration/downloadsalarytemplate'), array('target'=>'_blank','class'=>"btn btn-sm btn-theme",'title'=>"Download Salary Details Upload Template"));?>
            </li>
        </ul>
    </div>
    <button type="button" class="btn btn-danger" style="display:none;" id="salaryupload_close" data-dismiss="modal">Close</button>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("SalaryUpload", "function SalaryUpload(filename)
{
var branch=$('#salary_branch').val();
var month=$('#salary_month').val();
var year=$('#salary_year').val();
if(branch != '' && month != '' && year != '' && filename != ''){
    jQuery.ajax({
    'type': 'post',
    'dataType': 'json',
    'data': {
            branch: branch,month: month,year: year,filename: filename
            },
    'url'  : '" . Yii::app()->createUrl("salarymigration/SaveUploadCsv") . "',
    'cache': false,
    'success': function (data) {
        if (data.status == 'success') {
            $('#loader').hide();
            if(data.error!=''){
                $('#csv_msg').html(data.link);
                $.each(data.error, function(key, val) {
                    t8.error(''+val+''); 
                }); 
        }else{
			
		t8.success('Details Uploaded Successfully');	
		$('#salaryupload_close').click();	
		reloadTable('#tbl_salary_migration_details');
		}
      }else {
        $('#loader').hide();
      }
    },
  });
}else{
    if(branch==''){
        t8.error('Select Branch');
    }else if(month==''){
        t8.error('Select Month');
    }else if(year==''){
        t8.error('Select Year');
    }else if(filename==''){
        t8.error('Please upload salary file');
    }
	
}
}", CClientScript::POS_HEAD);
?>









