<html>
    <head>
        <title>Salary Slip</title>
        <style>
            .table-responsive table{
                margin-right:10px;	
                margin-bottom:10px;	
            }
            .table-responsive th{
                background: #d9ebfc;
                text-align: center;
                border: 1px solid #88abcc;
            }
        </style>
    </head>
    <body>
        <?php
        $model_pdf_settings = DocumentSettings::model()->find();
        $company_name = "";
        $company_address = "";
        $company_phno = "";
        $company_web_address = "";
        if (!empty($model_pdf_settings)) {
            $company_name = strtoupper($model_pdf_settings->company_name);
            $company_address = $model_pdf_settings->company_address;
            $company_phno = $model_pdf_settings->company_phno;
            $web = substr($model_pdf_settings->company_web_address, 0, 3);
            if ($web != 'www') {
                $company_web_address = 'www.';
            }
            $company_web_address.=$model_pdf_settings->company_web_address;
        } else {
            $model_company = MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id);
            $company_name = strtoupper($model_company->company_name);
            ;
            $company_address = $model_company->billing_address;
            $company_phno = $model_company->genral_phno;
            $web = substr($model_company->genral_web, 0, 2);
            if ($web != 'www') {
                $company_web_address = 'www.';
            }
            $company_web_address = $model_company->genral_web;
        }
        if($id>0){
            $condition.='salary_processing_id="'.$id.'"';
        }
        if($employee_id>0){
            $condition.=' and employee_id="'.$employee_id.'"';
        }
        $model_salary_slip = SalarySlip::model()->findAll(array('condition'=>$condition));
        $len=  count($model_salary_slip);
        foreach ($model_salary_slip as $key => $model) {
            $model_salary_processing = SalaryProcessing::model()->findbyPK($model->salary_processing_id);
            $payroll_startdate=$model_salary_processing->payroll_startdate;
            $payroll_enddate=$model_salary_processing->payroll_enddate;
            $year_salary = (int) date("Y", strtotime($model_salary_processing->payroll_enddate));
            $installment_detail='-';
            if($model->loan_amount>0){
                $model_loan_installment = EmployeeLoan::model()->find(array('condition' => 'date_payment="' . $model_salary_processing->salary_lock_date . '" and employee_id="'.$model->employee_id.'" and salary_lock_id="'.$model_salary_processing->id.'" and added_from="2"'));
                $inst=$model_loan_installment->loan_installment;
                $model_loan = EmployeeLoanDetail::model()->findbyPK($model_loan_installment->loan_id);
                $tot_inst=$model_loan->loan_total_installment;
                $installment_detail=$inst.'/'.$tot_inst;

            }
        ?>
        <div class="heading" style="text-align:center;">
            <h3 style="margin: 0px;padding: 0px;font-size: 30px;color: #0070c0;font-weight: bold;"><?php echo $company_name; ?></h3>
            <h6 style="font-size: 11px;font-weight:200;color: #0070c0;margin:10px 0px 0px 0px;margin-top:1px;"><?php echo $company_address; ?>; <?php echo $company_phno; ?>; <span style="text-decoration:underline;color:#0000ff;"><?php echo $company_web_address; ?></span></h6>
        </div>
        <div class="clearfix"></div>
        <div class="panel">
            <div class="panel-heading panel-theame">
                <h5> Salary Slip - for the month of&nbsp;&nbsp;<span style="color:#0000ff;"><u><b><?php echo $model_salary_processing->payroll_month . ' ' . $year_salary; ?></b></u></span></h5>
            </div>
            <div class="panel-body"> 
                <div class="table-responsive">

                    <div id="salaryslip">
                        <div class="inner-box">  
                            <div class="col-6">
                                <table id="employeedoc_table" class="table  table-bordered personal-task " >
                                    <tr>
                                        <td class="lite text-left">Employee Code</td>
                                        <td class="text-left"><b><?php echo $this->ciphertext($model->employeedetail->employee_code, "d"); ?></b></td>   
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Department</td> <td class="lite text-left">
                                            <?php
                                            $department = MasDepartment::model()->findByPk($model->employeedetail->department);
                                            echo $department->department_name;
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Date of Joining</td> <td class="lite text-left"> 
                                            <?php
                                            if ($model->employeedetail->date_join != "0000-00-00") {
                                                echo date_format(date_create($model->employeedetail->date_join), 'd/m/Y');
                                            } else {
                                                echo"";
                                            }
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Month</td> <td class="lite text-left"> <b>
<?php echo $model_salary_processing->payroll_month; ?></b></td>  
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Bank Name</td> <td class="lite text-left"> 
                                            <?php
                                            $bank = MasBank::model()->findByPk($model->employeedetail->employee_bankname);
                                            echo $bank->bank_name;
                                            ?></td>  
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">IBAN No.</td>
                                        <td><?php
                                            echo $model->employeedetail->employee_iban_no;
                                            ?></td>   
                                    </tr> 
                                </table>
                            </div>	


                            <div class="col-6">
                                <table id="employeedoc_table" class="table table-bordered personal-task " >
                                    <tr>
                                        <td class="lite text-left">Employee Name</td>
                                        <td class="text-left"><b><?php echo $this->ciphertext($model->employeedetail->first_name, "d") . " " . $this->ciphertext($model->employeedetail->last_name, "d"); ?></b></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Designation</td> <td class="lite text-left">
                                            <?php
                                            $desi = MasDesignation::model()->findByPk($model->employeedetail->designation);
                                            echo $desi->designation_name;
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Branch</td> <td class="lite text-left">
                                            <?php
                                            $branch = MasCompanyBranchSponsor::model()->findByPk($model->employeedetail->branch_or_sponsor_id);
                                            echo $branch->branch_or_sponsor_name;
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Year</td> <td class="lite text-left"><b><?php echo $year_salary; ?></b></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left" style="color:#d10606;font-weight:bold;">Total work days</td> <td class="lite text-left"><?php echo $model->total_working_days; ?></td> 
                                    </tr> 
                                    <tr>
                                        <td class="lite text-left" style="color:#d10606;">Days Absent/Leave</td> <td class="lite text-left"><?php echo $model->absent_working_days; ?></td> 
                                    </tr> 
                                </table>

                            </div>  
                            <div class="clearfix"></div>


                            <div class="col-6">
                                <table id="fixed_table" class="table  table-bordered personal-task " >
                                    <tr>  <th class="bg-ec1" colspan="2">EARNINGS</th></tr>
                                    <?php
                                    $addictions = 0.00;
                                    $deductions = 0.00;
                                    $model_salary_type = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and salary_type="1" AND id!=5'));
                                    foreach ($model_salary_type as $model_add) {
                                        $model_salary_amount = SalarySlipDetails::model()->find(array('condition' => 'salary_slip_id="' . $model->id . '" and 		salary_id="' . $model_add->id . '"'));
                                        ?>
                                        <tr>
                                            <td class="lite text-left"><?php echo $model_add->salary_name; ?></td>
                                            <td class="text-right"><?php
                                                $addictions+=$model_salary_amount->salary_amount;
                                                echo Yii::app()->numberFormatter->formatCurrency($model_salary_amount->salary_amount, "");
                                                ?>
                                            </td>
                                        <tr>
<?php } ?>
                                    <tr>
                                        <td class="lite bold text-left" style="color:#d10606;font-weight:bold;">Net Salary</td>
                                        <td class="text-right bold" style="color:#d10606;font-weight:bold;">
                                            <?php
                                            echo Yii::app()->numberFormatter->formatCurrency($addictions, "");
                                            ?> </td>
                                    </tr>
                                </table>     
                            </div>	   

                            <div class="col-6">
                                <table id="fixed_deduction_table" class="table  table-bordered personal-task " >
                                    <tr> <th class="bg-ec1" colspan="2">DEDUCTIONS</th></tr>
                                    <?php
                                    $model_salary_type_1 = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and salary_type="2"'));
                                    foreach ($model_salary_type_1 as $model_deduct) {
                                        $model_salary_amount = SalaryslipDetails::model()->find(array('condition' => 'salary_slip_id="' . $modelSalarySlip->id . '" and salary_id="' . $model_deduct->id . '"'));
                                        ?>
                                        <tr>
                                            <td class="lite text-left"><?php echo $model_deduct->salary_name; ?></td>
                                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model_salary_amount->salary_amount, ""); ?>
                                            </td>
                                        <tr>
<?php } ?>
                                    <tr>
                                        <td class="lite text-left">Salary Advance</td>
                                        <td class="text-right"><?php
                                            $deductions+=$model->salary_advance_amount;
                                            echo Yii::app()->numberFormatter->formatCurrency($model->salary_advance_amount, "");
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Leave without pay</td>
                                        <td class="text-right"><?php
                                            $deductions+=$model->leave_amount;
                                            echo Yii::app()->numberFormatter->formatCurrency($model->leave_amount, "");
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Loan Amount</td>
                                        <td class="text-right"><?php
                                            $deductions+=$model->loan_amount;
                                            echo Yii::app()->numberFormatter->formatCurrency($model->loan_amount, "");
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Installment of Loan Balance</td>
                                        <td class="text-right"><?php echo $installment_detail; ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Deduction(Before Joining)</td>
                                        <td class="text-right"><?php
                                            $deductions+=$model->before_joining_salary;
                                            echo Yii::app()->numberFormatter->formatCurrency($model->before_joining_salary, "");
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">AL Deduction</td>
                                        <td class="text-right"><?php
                                            $deductions+=$model->annual_leave_deduction;
                                            echo Yii::app()->numberFormatter->formatCurrency($model->annual_leave_deduction, "");
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Other Deductions</td>
                                        <td class="text-right">
                                            <?php
                                            $deductions+=$model->other_deduction;
                                            echo Yii::app()->numberFormatter->formatCurrency($model->other_deduction, "");
                                            ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="lite bold text-left" style="font-weight:bold;">Total</td>
                                        <td class="text-right bold" style="font-weight:bold;"><?php
                                            echo Yii::app()->numberFormatter->formatCurrency($deductions, "");
                                            ?> </td>
                                    </tr>
                                </table>
                            </div>
                            <!--<div class="clearfix"></div>-->
                            <div class="col-6" style="margin-top:-65px !important;">
                                <table id="fixed_table" class="table  table-bordered personal-task " >
                                    <tr>  <th class="bg-ec1" colspan="2">Allowances</th></tr>
                                    <?php
                                    $allowance_addictions = 0.00;
                                    $model_salary_type_1 = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and salary_type="1" and id=5'));
                                    foreach ($model_salary_type_1 as $model_add) {
                                        $model_salary_amount = SalarySlipDetails::model()->find(array('condition' => 'salary_slip_id="' . $model->id . '" and 		salary_id="' . $model_add->id . '"'));
                                        ?>
                                        <tr>
                                            <td class="lite text-left"><?php echo $model_add->salary_name; ?></td>
                                            <td class="text-right">
                                                <?php
                                                $allowance_addictions+=$model_salary_amount->salary_amount;
                                                echo Yii::app()->numberFormatter->formatCurrency($model_salary_amount->salary_amount, "");
                                                ?>
                                            </td>
                                        </tr> 
<?php } ?>

                                    <tr>
                                        <td class="lite text-left">Overtime</td>
                                        <td class="text-right">
                                            <?php
                                            $allowance_addictions+=$model->overtime_amount;
                                            echo Yii::app()->numberFormatter->formatCurrency($model->overtime_amount, "");
                                            ?></td>
                                    </tr> 
                                    <tr>
                                        <td class="lite text-left">AL Additions</td>
                                        <td class="text-right"><?php
                                            $allowance_addictions+=$model->annual_leave_addition;
                                            echo Yii::app()->numberFormatter->formatCurrency($model->annual_leave_addition, "");
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite text-left">Other Additions</td>
                                        <td class="text-right"><?php
                                            $allowance_addictions+=$model->other_addition;
                                            echo Yii::app()->numberFormatter->formatCurrency($model->other_addition, "");
                                            ?></td>
                                    </tr>
                                    <tr>
                                        <td class="lite bold text-left" style="color:#d10606;font-weight:bold;">Total Allowances</td>
                                        <td class="text-right bold" style="color:#d10606;font-weight:bold;">
                                            <?php
                                            echo Yii::app()->numberFormatter->formatCurrency($allowance_addictions, "");
                                            ?> </td>
                                    </tr>
                                </table>     
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-6">
                                <?php
                                  //Overtime Calculation
            $overtime_work = "00:00:00";
            $overtime_amount = 0.00;
            $normal_overime_time_detail="00:00:00";
            $holiday_overime_time_detail="00:00:00";
            $weekend_overime_time_detail="00:00:00";
            $no_overtime_amount=0.00;
            $ho_overtime_amount=0.00;
            $we_overtime_amount=0.00;
            $salary_overtime_normal=0.00;
            $salary_overtime_weekend=0.00;
            $salary_overtime_holiday=0.00;
            if ($model->employeedetail->overtime == "Y") {
                //Normal overtime
                    $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`))) As normal_overtime', 'condition' => 'employee_id="'.$model->employee_id.'" AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '"'));
                   // $overtime_work = $model_attendance->normal_overtime;
                    if ($model_attendance->normal_overtime != "00:00:00") {
                        $normal_overime_time_detail=$model_attendance->normal_overtime;
                        $normal_overtime = explode(':', $model_attendance->normal_overtime);
                        $n_overtime = $normal_overtime[0];
                        //Overtime Salary
                        $model_master_normal = MasOverTime::model()->findByPk(1);
                        $normal_overtime_salary=0.00;
                        $each_normal_ot = explode(',', $model_master_normal->salary);
                            foreach ($each_normal_ot as $value_1) {
                                $model_normalovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="'.$model->employee_id.'" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '"'));
                                $normal_overtime_salary+=$model_normalovertime_salary->amount;
                            }
                        $normal_ot_salary_per_day =round($normal_overtime_salary / 30, 2);  //Per day salary for overtime 
                        //Salary Per hour
                        $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model->employeedetail->branch_or_sponsor_id);
                        $working_hours_second="";
                        if($model_company_shift->branch_working_hours!='00:00:00'){
                            //$working_time=date("H:i",strtotime($model_company_shift->branch_working_hours));
                           // $working_hours_second = strtotime($working_time); //In second
                            $working_time = explode(':', $model_company_shift->branch_working_hours);
                            $working_hours_second=$working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        }else{
                            $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                            $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                        }
                        //echo $normal_ot_salary_per_day; 
                        // gmdate('H:i', $working_hours_second);
                        $salary_per_second_normal= $normal_ot_salary_per_day /$working_hours_second; 
                        $salary_per_hour_normal=$salary_per_second_normal*3600; 
                        //Overtimesalary
                        $salary_overtime_normal = $salary_per_hour_normal * $model_master_normal->times;
                        $normal_salary_per_min = ($salary_overtime_normal/60);
                        $no_overtime_amount+= round($n_overtime * $salary_overtime_normal, 2);
                        $no_overtime_amount+= round($normal_overtime[1] * $normal_salary_per_min, 2);
                        $overtime_amount+= round($n_overtime * $salary_overtime_normal, 2);
                        $overtime_amount+= round($normal_overtime[1] * $normal_salary_per_min, 2);
                        $salary_overtime_normal=round($salary_overtime_normal, 2);
                    }
                //End Normal Overtime
                
                //Start Holiday Overtime
                    $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`holiday_overtime`))) As holiday_overtime', 'condition' => 'employee_id="' . $model->employeedetail->id . '" AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '"'));
                    //$overtime_work = $model_attendance->holiday_overtime;
                    if ($model_attendance->holiday_overtime != "00:00:00") {
                        $holiday_overime_time_detail=$model_attendance->holiday_overtime;
                        $holiday_overtime = explode(':', $model_attendance->holiday_overtime);
                        $h_overtime = $holiday_overtime[0];

                        //Overtime Salary           
                        $holiday_overtime_salary=0.00;
                        $model_master_holiday = MasOverTime::model()->findByPk(2);
                        $each_holiday_ot = explode(',', $model_master_holiday->salary);
                        foreach ($each_holiday_ot as $value_1) {
                            $model_holidayovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $model->employeedetail->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '"'));
                            $holiday_overtime_salary+=$model_holidayovertime_salary->amount;
                        }
                        $holiday_ot_salary_per_day = $holiday_overtime_salary / 30;  //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model->employeedetail->branch_or_sponsor_id);
                       $working_hours_second="";
                        if($model_company_shift->branch_working_hours!='00:00:00'){
//                            $working_time=date("H:i",strtotime($model_company_shift->branch_working_hours));
//                            $working_hours_second = strtotime($working_time); //In second
                            $working_time = explode(':', $model_company_shift->branch_working_hours);
                            $working_hours_second=$working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        }else{
                            $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                            $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                        }
                        $salary_per_second_holiday= $holiday_ot_salary_per_day /$working_hours_second; 
                        $salary_per_hour_holiday=$salary_per_second_holiday*3600;
                        //Overtimesalary
                        $salary_overtime_holiday = $salary_per_hour_holiday * $model_master_holiday->times;
                        $holiday_salary_per_min = ($salary_overtime_holiday/60);
                        $ho_overtime_amount+= round($h_overtime * $salary_overtime_holiday, 2); 
                        $ho_overtime_amount+= round($holiday_overtime[1] * $holiday_salary_per_min, 2);
                        $overtime_amount+= round($h_overtime * $salary_overtime_holiday, 2); 
                        $overtime_amount+= round($holiday_overtime[1] * $holiday_salary_per_min, 2);
                        $salary_overtime_holiday=round($salary_overtime_holiday, 2);
                    }
               
                //End Holiday Overtime
                //Weekend Overtime
                    $model_attendance_weekend = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`weekend_overtime`))) As weekend_overtime', 'condition' => 'employee_id="' . $model->employeedetail->id . '" AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '"'));
                    if ($model_attendance_weekend->weekend_overtime != "00:00:00") {
                        $weekend_overime_time_detail=$model_attendance_weekend->weekend_overtime;
                        $weekend_overtime = explode(':', $model_attendance_weekend->weekend_overtime);
                        $w_overtime = $weekend_overtime[0]; 

                        //Overtime Salary                            
                        $model_master_weekend = MasOverTime::model()->findByPk(3);
                        $each_weekend_ot = explode(',', $model_master_weekend->salary);
                        $weekend_overtime_salary=0.00;
                        foreach ($each_weekend_ot as $value_1) {
                            $model_weekendovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' .$model->employeedetail->id. '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '"'));
                            $weekend_overtime_salary+=$model_weekendovertime_salary->amount;
                        }
                        $weekend_ot_salary_per_day = $weekend_overtime_salary / 30;  //Per day salary for overtime 
                        //Salary Per hour
                        $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model->employeedetail->branch_or_sponsor_id);
                        $working_hours_second="";
                        if($model_company_shift->branch_working_hours!='00:00:00'){
//                            $working_time=date("H:i",strtotime($model_company_shift->branch_working_hours));
//                            $working_hours_second = strtotime($working_time); //In second
                            $working_time = explode(':', $model_company_shift->branch_working_hours);
                            $working_hours_second=$working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        }else{
                            $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                            $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                        }
                        $salary_per_second_weekend= $weekend_ot_salary_per_day /$working_hours_second; 
                        $salary_per_hour_weekend=$salary_per_second_weekend*3600;
                        //Overtimesalary
                        $salary_overtime_weekend = $salary_per_hour_weekend * $model_master_weekend->times;
                        $weekend_salary_per_min = ($salary_overtime_weekend/60);
                        $we_overtime_amount+= round($w_overtime * $salary_overtime_weekend, 2);  
                        $we_overtime_amount+= round($weekend_overtime[1] * $weekend_salary_per_min, 2);
                        $overtime_amount+= round($w_overtime * $salary_overtime_weekend, 2);  
                        $overtime_amount+= round($weekend_overtime[1] * $weekend_salary_per_min, 2);
                        $salary_overtime_weekend=round($salary_overtime_weekend, 2);  
                    }
                //End weekend overtime
//                    $model_total_overtime= EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`)+time_to_sec(`holiday_overtime`)+time_to_sec(`weekend_overtime`))) As normal_overtime', 'condition' =>'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '"' ));
//                    $overtime_work=$model_total_overtime->normal_overtime;
            }
            //End Overtime Calculation
                                ?>
                                <table border="0" style="padding-top:-10px;">
                                    <tr>
                                        <th colspan="2" style="color:#0000ff;background-color:none;border:none;text-align:left;"><u>Overtime Breakdown</u></th>
                                    </tr>
                                    <tr>
                                        <td style="color:#366092;text-align:left;width:50%;font-size:12px;">Overtime Weekdays </td>
                                        <td style="text-align:right;color:#366092;width:50%;font-size:12px;"><?php echo $normal_overime_time_detail; ?>Hrs - <?php echo Yii::app()->numberFormatter->formatCurrency($no_overtime_amount, ""); ?></td>
                                    </tr>
                                    <tr>
                                        <td style="color:#366092;text-align:left;width:50%;font-size:12px;">Overtime Weekend  </td>
                                        <td style="text-align:right;color:#366092;width:50%;font-size:12px;"><?php echo $weekend_overime_time_detail; ?>Hrs - &nbsp;&nbsp;<?php echo Yii::app()->numberFormatter->formatCurrency($we_overtime_amount, ""); ?></td>
                                    </tr>
                                    <tr>
                                        <td style="color:#366092;text-align:left;width:50%;font-size:12px;">Overtime Holiday  </td>
                                        <td style="text-align:right;color:#366092;width:50%;font-size:12px;"><?php echo $holiday_overime_time_detail; ?>Hrs - &nbsp;&nbsp;<?php echo Yii::app()->numberFormatter->formatCurrency($ho_overtime_amount, ""); ?></td>
                                    </tr>
                                    <tr>
                                        <th style="color:#366092;text-align:left;width:50%;border:none;background-color:#ccc;font-weight:bold;">Total Overtime</th>
                                        <th style="text-align:right;background-color:#ccc;width:50%;border:none;font-weight:bold;"><?php echo Yii::app()->numberFormatter->formatCurrency($overtime_amount, ""); ?></th>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="height:2px;"></td>
                                    </tr>
                                    <tr>
                                        <td style="color:#d10606;text-align:left;width:50%;border:none;background-color:#ccc;font-weight:bold;">Deductions</td>
                                        <td style="text-align:right;background-color:#ccc;width:50%;border:none;color:#d10606;font-weight:bold;">
                                            <?php
                                            echo Yii::app()->numberFormatter->formatCurrency($deductions, "");
                                            ?>
                                            </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="height:2px;"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="color:#366092;text-align:left;width:50%;border:none;background-color:#ccc;font-weight:bold;">Remarks : <span style="color:#d10606;font-weight:bold;"><?php echo $model->remarks; ?></span></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="height:2px;"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="color:#366092;text-align:left;font-size:9.5px;font-weight:bold;">Total Gross Payable Salary&nbsp;&nbsp;&nbsp;<span style="color:#d10606;font-size:9px;font-weight:bold;">(<?php echo $addictions; ?>+ <?php echo $allowance_addictions; ?> - <?php echo $deductions; ?>)</span></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="clearfix"></div>
                            <table class="col-12 table table-bordered personal-task " style="margin-bottom:10px;">
                                <tr>
                                    <th class="lite bold text-right" style="width:30%;font-weight:bold;">Net Amount</th>
                                    <th class="text-right bold" style="width:70%;font-weight:bold;">
                                        <?php
                                        $total = $addictions - $deductions;
                                        $currencycode = MasCurrency::model()->findByPk($model->employeedetail->currency);
                                        $currency = $currencycode->currency;
                                        echo $currency . " " . Yii::app()->numberFormatter->formatCurrency($model->total_salary_amount, "");
                                        ?><br><?php echo $currency . " " . ucfirst($this->widget('ext.NumtoWord.NumtoWord', array('num' => floatval($model->total_salary_amount)))->result) . ' Only'; ?> </th>
                                </tr>
                            </table>
                            <table class="col-12 table table-bordered personal-task ">
                            <?php
                            $model_leave_detail = SalarySlipLeavedetails::model()->findAll(array('condition' => 'salary_processing_id="' . $model->salary_processing_id . '" and salary_slip_id="' . $model->id . '"'));
                            foreach ($model_leave_detail as $key => $value_detail) {
                                ?>
                                <tr>
                                    <th class="lite bold text-left" style="width:30%;"><?php echo strtoupper($value_detail->leave_name); ?></th>
                                    <th colspan="2" class="text-right bold" style="width:70%;"><?php echo $value_detail->leave_count; ?></th>
                                </tr>
                            <?php } 
                            $total_medical_leave=0.00;
                            $start_date=array();
                            $medical_leave_day='-';
                            $model_medical_leave_count = EmployeeAttendance::model()->with('leave')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $model->employee_id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leave.leave_type="2"'));
                            if($model_medical_leave_count->id>0){
                               $total_medical_leave= $model_medical_leave_count->id;
                            }
                            $model_medical_leave = EmployeeAttendance::model()->with('leave')->findAll(array('condition' => 't.employee_id=' . $model->employee_id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leave.leave_type="2"'));
                            foreach ($model_medical_leave as $key => $value) {
                                $start_date[]=date("d/m/Y", strtotime($value->leave->leave_start_date)).'-'.date("d/m/Y", strtotime($value->leave->leave_end_date));
                            }
                            if(!empty($start_date)){
                              $medical_leave_day=  implode(',', $start_date);
                            }
                            ?>
                                <tr>
                                    <td class="lite bold text-left" style="width:30%;background-color:#d9ebfc;font-weight:bold;">
                                        MEDICAL LEAVE AVAILED</td>
                                    <td class="text-left bold" style="width:30%;background-color:#d9ebfc;font-weight:bold;"><?php echo $medical_leave_day; ?></td>
                                    <td class="text-right bold" style="width:30%;background-color:#d9ebfc;font-weight:bold;"><?php echo $total_medical_leave; ?></td>
                                </tr>    
<!--                                <tr>
                                    <td class="lite bold text-left" style="width:30%;background-color:#d9ebfc;font-weight:bold;">
                                        TICKET ENTITLEMENT BALANCE</td>
                                    <td colspan="2" class="text-right bold" style="width:70%;background-color:#d9ebfc;font-weight:bold;"><?php echo $model->ticket_entitlement_balance; ?></td>
                                </tr>    -->
                            </table>
                            <div style="padding-top:-10px;">
                                <h4>Disclaimer</h4>
                                <?php
                                $model_disclaimer_text = HrGenerelSettings::model()->find();
                                ?>
                                <p style="font-size:11px;font-weight:300;padding-top:-10px;"><?php echo $model_disclaimer_text->disclaimer_salary_slip; ?></p>
                            </div>
                             <?php 
                                --$len;
                                if($len>0){
                                    echo "<div style='page-break-after:always'></div>";

                                }else{
                                      echo "<div style='page-break-after:avoid'></div>";
                                }

                                ?>
                        </div></div>
                </div></div></div>
        <?php } ?>
    </body>
</html>