<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTablesalcomp", '
    var table;  // Declare a variable to hold the DataTable instance
    function filterDataTablesalcomp()
    {
        var table_id = "#tbl_salary_component";
        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        if (!$.fn.dataTable.isDataTable(table_id)) {
            // Initialize DataTable only if it has not been initialized yet
            table = $(table_id).DataTable({
                pageLength: 50,
                processing: true,
                ordering: false,
                searching: false,
                ajax: {
                    url: "' . Yii::app()->createUrl('hr/salarychecker/SalaryComponentChecker') . '",
                    type: "POST",
                    data: {"branch_id": branch_id, "frmdate": frmdate, "todate": todate},
                    cache: false,
                },
                serverSide: true,
                fixedColumns: true,
                fixedHeader: {
                    headerOffset: $("header.main").outerHeight(),
                },
                autoWidth: false,
             "columnDefs": [
                    {
                        "targets": [5],  // Right-align these columns
                        "className":"dt-right"
                    }
                ]
            });
        } else {
            // If DataTable is already initialized, just reload the data
            table.ajax.reload();
        }
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {
       filterDataTablesalcomp();  // Initialize the table on page load
    });
', CClientScript::POS_HEAD);
?>
<?php
$model = new HrMonthlySalaryComponent();
$start_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
$dateObj = new DateTime($start_date);
$year = $dateObj->format('Y');
$month = $dateObj->format('m');
$condition = "1=1";
if ($year && $month) {
    $condition .= " AND salary_month = " . $month . " AND salary_year = " . $year;
}
$salaryComponent = HrMonthlySalaryComponent::model()->findAll(array(
    'condition' => $condition,
    'with' => array('salarytype', 'branch_sponsor'),
    'group' => 't.salary_type'
        ));
$branchSums = 0.00;
$branches = MasCompanyBranchSponsor::model()->findAll(array(
    'order' => 'branch_or_sponsor_name ASC',
        ));
?>
<div class="col-sm-2"></div>
<div class="col-sm-8" style="margin-top:10px">
    <?php
    ?>
    <table class="table table-hover table-bordered personal-task">
        <thead>
            <tr>
                <th>Salary Component</th>
                <?php foreach ($branches as $branchName): ?>
                    <th><?php echo $branchName->branch_or_sponsor_name; ?></th>
                    <?php endforeach; ?>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($salaryComponent as $salaryName): ?>
                <tr>
                    <td><?= $salaryName->salarytype->salary_name; ?></td>
    <?php
    $totalAmount = 0;
    foreach ($branches as $branchName) {
        $amount = 0;
        $condition1 = "salary_month = " . $month . " AND salary_year = " . $year . " AND employeedetail.branch_or_sponsor_id = '" . $branchName->id . "' AND t.salary_type='" . $salaryName->salary_type . "'";
        $salaryComponentdetails = HrMonthlySalaryComponent::model()->with('employeedetail')->find(array('select' => 'sum(t.amount) as amount,employeedeatil.id', 'condition' => $condition1));
        $totalAmount += $salaryComponentdetails['amount'];
        ?>
                        <td style="text-align:right;"><?= number_format($salaryComponentdetails['amount'], 2) ?></td>
                    <?php } ?>
                    <td style="text-align:right;"><?= number_format($totalAmount, 2) ?></td> <!-- Display total for each salary component across all branches -->
                </tr>
    <?php
    $branchSums += $totalAmount;
endforeach;
?>
        </tbody>
    </table>
</div>
<div class="col-sm-2"></div>
<div class="col-sm-12">
    <div id="content_tables" class="content_table10">
        <table class="table table-hover table-bordered personal-task" id="tbl_salary_component" style="font-size:13px;">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Branch</th>    
                    <th>Employee Code</th>
                    <th>Employee Name</th>
                    <th>Salary Type</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Comments / Remarks</th>
                </tr>
            </thead>
        </table>
    </div>
</div>

<style>
    .dt-right{
        text-align: right;
    }
</style>