<?php
// Initialize the employee model and set date format
$model_leave_detail = new EmployeeLeaveDetail();
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));

// Initialize an array to store branch data for leave
$leave_finalData = [];

// Define leave status conditions
$leave_conditions = [
    'leave_applied' => "leave_status= '1'",
    'leave_level1' => "leave_status= '2'",
    'leave_level2' => "leave_status= '4'",
    'leave_level3' => "leave_status= '6'",
    'leave_approved' => "leave_status= '12'"
];

// Append the date conditions to each leave status
foreach ($leave_conditions as $status => $condition) {
    $leave_conditions[$status] .= " AND ((leave_start_date >= '" . $from_date . "' AND leave_end_date <= '" . $to_date . "') OR (leave_start_date BETWEEN '" . $from_date . "' AND '" . $to_date . "' OR leave_end_date BETWEEN '" . $from_date . "' AND '" . $to_date . "'))";
}

// Fetch employees and their branch details
$employees = Employee::model()->findAll(array(
    'condition' => 't.isActive = "Y"',
    'with' => array('branch_sponsor'),
    'order' => 'branch_sponsor.branch_or_sponsor_name',
        ));

// Loop through employees to calculate leave status counts for each branch
foreach ($employees as $employee) {
    $masBranch = $employee->branch_sponsor;

    if ($masBranch) {
        $branch_id = $masBranch->id;
        $branch_name = $masBranch->branch_or_sponsor_name;

        // Initialize branch data if not already set
        if (!isset($leave_finalData[$branch_id])) {
            $leave_finalData[$branch_id] = [
                'branch_name' => $branch_name,
                'leave_status_counts' => [
                    'leave_applied' => 0,
                    'leave_approved' => 0,
                    'leave_level1' => 0,
                    'leave_level2' => 0,
                    'leave_level3' => 0
                ]
            ];
        }

        // **Leave Statuses**
        foreach ($leave_conditions as $status => $condition) {
            $leave_count = $model_leave_detail->with('employeedetail')->count(array(
                'condition' => $condition . " AND employeedetail.branch_or_sponsor_id = " . $branch_id
            ));
            $leave_finalData[$branch_id]['leave_status_counts'][$status] = $leave_count; // Add to branch's leave status count
        }
    }
}
?>


<?php
// Initialize the employee model and set date format
$model_loan_detail = new EmployeeLoanDetail();
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));

// Initialize an array to store branch data for loan
$loan_finalData = [];

// Define loan status conditions
$loan_conditions = [
    'loan_applied' => "loan_status= '1'",
    'loan_level1' => "loan_status= '2'",
    'loan_level2' => "loan_status= '4'",
    'loan_level3' => "loan_status= '6'",
    'loan_approved' => "loan_status= '12'"
];

// Append the date conditions to each loan status
foreach ($loan_conditions as $status => $condition) {
    $loan_conditions[$status] .= " AND ((apply_date >= '" . $from_date . "' AND apply_date <= '" . $to_date . "') OR (apply_date BETWEEN '" . $from_date . "' AND '" . $from_date . "' OR apply_date BETWEEN '" . $to_date . "' AND '" . $to_date . "'))";
}

// Fetch employees and their branch details
$employees = Employee::model()->findAll(array(
    'condition' => 't.isActive = "Y"',
    'with' => array('branch_sponsor'),
    'order' => 'branch_sponsor.branch_or_sponsor_name ASC',
        ));

// Loop through employees to calculate loan status counts for each branch
foreach ($employees as $employee) {
    $masBranch = $employee->branch_sponsor;

    if ($masBranch) {
        $branch_id = $masBranch->id;
        $branch_name = $masBranch->branch_or_sponsor_name;

        // Initialize branch data if not already set
        if (!isset($loan_finalData[$branch_id])) {
            $loan_finalData[$branch_id] = [
                'branch_name' => $branch_name,
                'loan_status_counts' => [
                    'loan_applied' => 0,
                    'loan_approved' => 0,
                    'loan_level1' => 0,
                    'loan_level2' => 0,
                    'loan_level3' => 0
                ]
            ];
        }

        // **Loan Statuses**
        foreach ($loan_conditions as $status => $condition) {
            $loan_count = $model_loan_detail->with('employeedetail')->count(array(
                'condition' => $condition . " AND employeedetail.branch_or_sponsor_id = " . $branch_id
            ));
            $loan_finalData[$branch_id]['loan_status_counts'][$status] = $loan_count; // Add to branch's loan status count
        }
    }
}
?>


<?php
// Initialize expense model
$model_expense_details = new EmployeeExpense();
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));

// Initialize expense conditions for various statuses
$expense_conditions = [
    'expense_applied' => "status= '1'",
    'expense_level1' => "status= '2'",
    'expense_level2' => "status= '4'",
    'expense_level3' => "status= '6'",
    'expense_approved' => "status= '12'"
];

// Append the date condition to each expense status
foreach ($expense_conditions as $status => $condition) {
    $expense_conditions[$status] .= " AND created_date <= '" . $to_date . "'";
}

// Initialize array to store expense counts by branch
$expense_finalData = [];

// Fetch employees and their branch details
$employees = Employee::model()->findAll(array(
    'condition' => 't.isActive = "Y"',
    'with' => array('branch_sponsor'),
    'order' => 'branch_sponsor.branch_or_sponsor_name ASC',
        ));

foreach ($employees as $employee) {
    $masBranch = $employee->branch_sponsor;

    if ($masBranch) {
        $branch_id = $masBranch->id;
        $branch_name = $masBranch->branch_or_sponsor_name;

        // Initialize branch data if not already set
        if (!isset($expense_finalData[$branch_id])) {
            $expense_finalData[$branch_id] = [
                'branch_name' => $branch_name,
                'expense_status_counts' => [
                    'expense_applied' => 0,
                    'expense_approved' => 0,
                    'expense_level1' => 0,
                    'expense_level2' => 0,
                    'expense_level3' => 0
                ]
            ];
        }

        // Calculate expense status counts for each branch
        foreach ($expense_conditions as $status => $condition) {
            $expense_count = $model_expense_details->with('employeedetail')->count(array(
                'condition' => $condition . " AND employeedetail.branch_or_sponsor_id = " . $branch_id
            ));
            $expense_finalData[$branch_id]['expense_status_counts'][$status] = $expense_count; // Store expense count
        }
    }
}


$model = new EmployeePayment();

// Initialize an array to store counts for each payment type and branch
$payment_finalData = [];

// Define the condition to filter out 'End of Service' payments
$condition = 'TYPE != "End of Service"';

// Query the records with the condition applied
$model = $model->findAll(array('condition' => $condition));

// Initialize an array to store counts for each branch
$branches = MasCompanyBranchSponsor::model()->findAll(array(
    'order' => 'branch_or_sponsor_name ASC',
        ));

// Loop through each branch to initialize data in the final array
foreach ($branches as $branch) {
    $branch_id = $branch->id;  // Get branch ID
    $branch_name = $branch->branch_or_sponsor_name;  // Get branch name (or any other field like name)
    // Initialize branch data if not already set
    if (!isset($payment_finalData[$branch_id])) {
        $payment_finalData[$branch_id] = [
            'branch_name' => $branch_name,
            'payment_status_counts' => [
                'Loan' => 0,
                'Salary Advance' => 0,
                'Leave Encashment' => 0,
                'End of Service' => 0,
                'Leave Settlement' => 0,
                'Expense' => 0,
                'Ticket Encashment' => 0
            ]
        ];
    }

    // Loop through each payment record to count by payment type and branch
    foreach ($model as $payment) {
        // **Change this line to use the correct field** - Match payments to the current branch
        if ($payment['branch_or_sponsor_id'] == $branch_id) {  // Replace 'branch_id' with the actual field name in your model
            $paymentType = $payment['TYPE'];  // Get the payment type
            // Increment the count for the respective payment type for the branch
            if (array_key_exists($paymentType, $payment_finalData[$branch_id]['payment_status_counts'])) {
                $payment_finalData[$branch_id]['payment_status_counts'][$paymentType] ++;
            }
        }
    }
}

$model = new EmployeeSalaryAdvance(); // Ensure this is correct for the EmployeeSalaryAdvance model
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));

// Initialize advance conditions for various statuses
$advance_conditions = [
    'Applied' => " advance_payment_status = '1'",
    'Level 1' => " advance_payment_status = '2'",
    'Level 2' => " advance_payment_status = '4'",
    'Level 3' => " advance_payment_status = '6'",
    'Approved' => "advance_payment_status = '12'"
];

// Append the date condition to each advance status
foreach ($advance_conditions as $status => $condition) {
    $advance_conditions[$status] .= " AND apply_date >= '" . $from_date . "' AND apply_date <= '" . $to_date . "'";
}

// Initialize array to store advance counts by branch
$advance_status_finalData = [];

// Fetch employees and their branch details
$employees = Employee::model()->findAll(array(
    'condition' => 't.isActive = "Y"',
    'with' => array('branch_sponsor'),
    'order' => 'branch_sponsor.branch_or_sponsor_name ASC',
));

foreach ($employees as $employee) {
    $masBranch = $employee->branch_sponsor;

    if ($masBranch) {
        $branch_id = $masBranch->id;
        $branch_name = $masBranch->branch_or_sponsor_name;

        // Initialize branch data if not already set
        if (!isset($advance_status_finalData[$branch_id])) {
            $advance_status_finalData[$branch_id] = [
                'branch_name' => $branch_name,
                'advance_status_counts' => [
                    'Applied' => 0,
                    'Level 1' => 0,
                    'Level 2' => 0,
                    'Level 3' => 0,
                    'Approved' => 0
                ]
            ];
        }

        // Calculate advance status counts for each branch
        foreach ($advance_conditions as $status => $condition) {
            $advance_count = $model->with('employeedetail')->count(array(
                'condition' => $condition . " AND employeedetail.branch_or_sponsor_id = " . $branch_id
            ));
            $advance_status_finalData[$branch_id]['advance_status_counts'][$status] = $advance_count; // Store advance count
        }
    }
}

$model = new HrEmployeeAttendanceExcuse();
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));

// Initialize attendance conditions
$attendance_conditions = [
    'attendance_applied' => "status = '1'",
    'attendance_level1' => "status = '2'",
    'attendance_level2' => "status = '4'",
    'attendance_level3' => "status = '6'",
    'attendance_approved' => "status = '12'"
];

// Append the date condition to each attendance status
foreach ($attendance_conditions as $status => $condition) {
    $attendance_conditions[$status] .= " AND apply_date >= '" .$from_date . "' AND apply_date <= '" . $to_date . "'";
}

// Initialize array to store attendance counts by branch
$attendance_finalData = [];

// Fetch employees and their branch details
$employees = Employee::model()->findAll(array(
    'condition' => 't.isActive = "Y"',
    'with' => array('branch_sponsor'),
    'order' => 'branch_sponsor.branch_or_sponsor_name ASC',
));

foreach ($employees as $employee) {
    $masBranch = $employee->branch_sponsor;

    if ($masBranch) {
        $branch_id = $masBranch->id;

        // Initialize branch data if not already set
        if (!isset($attendance_finalData[$branch_id])) {
            $attendance_finalData[$branch_id] = [
                'branch_name' => $masBranch->branch_or_sponsor_name,
                'attendance_status_counts' => [
                    'attendance_applied' => 0,
                    'attendance_level1' => 0,
                    'attendance_level2' => 0,
                    'attendance_level3' => 0,
                    'attendance_approved' => 0
                ]
            ];
        }

        // Calculate attendance status counts for each branch
        foreach ($attendance_conditions as $status => $condition) {
            $attendance_count = $model->with('employeedetail')->count(array(
                'condition' => $condition . " AND employeedetail.branch_or_sponsor_id = " . $branch_id
            ));
            $attendance_finalData[$branch_id]['attendance_status_counts'][$status] = $attendance_count;
        }
    }
}
?>
 <?php
    $model_module_leave = HrModules::model()->findByPK(3);
    $model_module_loan = HrModules::model()->findByPK(6);
    $model_module_salary_advance = HrModules::model()->findByPK(5);
    $model_module_expense = HrModules::model()->findByPK(11);
    $model_module_payroll = HrModules::model()->findByPK(7);
    $model_module_attendance = HrModules::model()->findByPK(2);
    $model_module_flexitime= HrModules::model()->findByPK(32);
            ?>
<section>
    <div class="container-fluid">
        <div class="row">
        <?php if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') { ?>
            <div class="col-lg-3">
                <div class="cards-sal">
                    <h3>Leave</h3>

                    <table class="table table-hover table-bordered personal-task">
                        <tr>
                            <th>Status</th>    
                            <?php foreach ($leave_finalData as $branchData) { ?>
                                <th class="text-center"><?= $branchData['branch_name'] ?></th>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Applied</td>
                            <?php foreach ($leave_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['leave_status_counts']['leave_applied'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['leave_status_counts']['leave_applied'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Level 1</td>
                            <?php foreach ($leave_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['leave_status_counts']['leave_level1'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['leave_status_counts']['leave_level1'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Level 2</td>
                            <?php foreach ($leave_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['leave_status_counts']['leave_level2'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['leave_status_counts']['leave_level2'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Level 3</td>
                            <?php foreach ($leave_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['leave_status_counts']['leave_level3'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['leave_status_counts']['leave_level3'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Approved</td>
                            <?php foreach ($leave_finalData as $branchData) { ?>
                                <td style="text-align:center"><?= $branchData['leave_status_counts']['leave_approved'] ?></td>
                            <?php } ?>
                        </tr>
                    </table>


                </div>
            </div>
        <?php } 
        if ($model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y') { ?>
            <div class="col-lg-3">
                <div class="cards-sal">
                    <h3>Loan</h3>	
                    <table class="table table-hover table-bordered personal-task">
                        <tr>
                            <th>Status</th>    
                            <?php foreach ($loan_finalData as $branchData) { ?>
                                <th class="text-center"><?= $branchData['branch_name'] ?></th>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Applied</td>
                            <?php foreach ($loan_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['loan_status_counts']['loan_applied'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['loan_status_counts']['loan_applied'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Level 1</td>
                            <?php foreach ($loan_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['loan_status_counts']['loan_level1'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['loan_status_counts']['loan_level1'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Level 2</td>
                            <?php foreach ($loan_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['loan_status_counts']['loan_level2'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['loan_status_counts']['loan_level2'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Level 3</td>
                            <?php foreach ($loan_finalData as $branchData) { ?>
                                <td  style="color:<?= ($branchData['loan_status_counts']['loan_level3'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['loan_status_counts']['loan_level3'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Approved</td>
                            <?php foreach ($loan_finalData as $branchData) { ?>
                                <td style="text-align:center"><?= $branchData['loan_status_counts']['loan_approved'] ?></td>
                            <?php } ?>
                        </tr>
                    </table>
                </div>
            </div>
        <?php } 
        if ($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y') { ?>

            <div class="col-lg-3">
                <div class="cards-sal">
                    <h3>Expense</h3>	
                    <table class="table table-hover table-bordered personal-task">
                        <tr>
                            <th>Status</th>    
                            <?php foreach ($expense_finalData as $branchData) { ?>
                                <th class="text-center"><?= $branchData['branch_name'] ?></th>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Applied</td>
                            <?php foreach ($expense_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['expense_status_counts']['expense_applied'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['expense_status_counts']['expense_applied'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Level 1</td>
                            <?php foreach ($expense_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['expense_status_counts']['expense_level1'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['expense_status_counts']['expense_level1'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Level 2</td>
                            <?php foreach ($expense_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['expense_status_counts']['expense_level2'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['expense_status_counts']['expense_level2'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Level 3</td>
                            <?php foreach ($expense_finalData as $branchData) { ?>
                                <td style="color:<?= ($branchData['expense_status_counts']['expense_level3'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['expense_status_counts']['expense_level3'] ?></td>
                            <?php } ?>
                        </tr>

                        <tr>
                            <td>Approved</td>
                            <?php foreach ($expense_finalData as $branchData) { ?>
                                <td style="text-align:center"><?= $branchData['expense_status_counts']['expense_approved'] ?></td>
                            <?php } ?>
                        </tr>
                    </table>
                </div>
            </div>
        <?php } ?>
            <?php
            $filteredData = array_filter($payment_finalData, function($branchData) {
                return !empty($branchData['payment_status_counts']['Expense']);
            });
            $filteredData2 = array_filter($payment_finalData, function($branchData) {
                return !empty($branchData['payment_status_counts']['Loan']);
            });
            if (($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y')
                || ($model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y')
                ||($model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y')
                ||($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y')) {
            ?>
            <div class="col-lg-3">
                <div class="cards-sal">
                    <h3>Payments</h3>	
                    <table class="table table-hover table-bordered personal-task">
                        <tr>
                            <th>Type</th>    
                            <?php foreach ($payment_finalData as $branchData) { ?>
                            <th class="text-center"><?= $branchData['branch_name'] ?></th>
                            <?php } ?>
                        </tr>
                        <?php if (!empty($filteredData2)) { ?>
                            <tr>
                                <td>Loan</td>
                                <?php foreach ($payment_finalData as $branchData) { ?>
                                    <td style="color:<?= ($branchData['payment_status_counts']['Loan'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['payment_status_counts']['Loan'] ?></td>
                                <?php } ?>
                            </tr>

                        <?php } ?>
                        <?php if (!empty($filteredData)) { ?>
                            <tr>
                                <td>Expense</td>
                                <?php foreach ($payment_finalData as $branchData) { ?>
                                    <td style="color:<?= ($branchData['payment_status_counts']['Expense'] > 0) ? '#f00606' : '' ?>;text-align:center"><?= $branchData['payment_status_counts']['Expense'] ?></td>
                                <?php } ?>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
            </div>
                <?php  } if ($model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y') { ?>
            <div class="col-lg-3">
    <div class="cards-sal">
        <h3>Salary Advance</h3>

        <table class="table table-hover table-bordered personal-task">
            <tr>
                <th>Status</th>    
                <?php foreach ($advance_status_finalData as $branchData) { ?>
                    <th class="text-center"><?= $branchData['branch_name'] ?></th>
                <?php } ?>
            </tr>

            <tr>
                <td>Applied</td>
                <?php foreach ($advance_status_finalData as $branchData) { ?>
                    <td style="color:<?= ($branchData['advance_status_counts']['Applied'] > 0) ? '#f00606' : '' ?>;text-align:center">
                        <?= $branchData['advance_status_counts']['Applied'] ?>
                    </td>
                <?php } ?>
            </tr>

            <tr>
                <td>Level 1</td>
                <?php foreach ($advance_status_finalData as $branchData) { ?>
                    <td style="color:<?= ($branchData['advance_status_counts']['Level 1'] > 0) ? '#f00606' : '' ?>;text-align:center">
                        <?= $branchData['advance_status_counts']['Level 1'] ?>
                    </td>
                <?php } ?>
            </tr>

            <tr>
                <td>Level 2</td>
                <?php foreach ($advance_status_finalData as $branchData) { ?>
                    <td style="color:<?= ($branchData['advance_status_counts']['Level 2'] > 0) ? '#f00606' : '' ?>;text-align:center">
                        <?= $branchData['advance_status_counts']['Level 2'] ?>
                    </td>
                <?php } ?>
            </tr>

            <tr>
                <td>Level 3</td>
                <?php foreach ($advance_status_finalData as $branchData) { ?>
                    <td style="color:<?= ($branchData['advance_status_counts']['Level 3'] > 0) ? '#f00606' : '' ?>;text-align:center">
                        <?= $branchData['advance_status_counts']['Level 3'] ?>
                    </td>
                <?php } ?>
            </tr>

            <tr>
                <td>Approved</td>
                <?php foreach ($advance_status_finalData as $branchData) { ?>
                    <td style="text-align:center"><?= $branchData['advance_status_counts']['Approved'] ?></td>
                <?php } ?>
            </tr>
        </table>
    </div>
</div>
 <?php } if ($model_module_flexitime->grant_access == 1 && $model_module_flexitime->isActive == 'Y') { ?>
<div class="col-lg-3">
<div class="cards-sal">
    <h3> Meeting / Flexi Time </h3>

    <table class="table table-hover table-bordered personal-task">
        <tr>
            <th>Status</th>    
            <?php foreach ($attendance_finalData as $branchData) { ?>
                <th class="text-center"><?= $branchData['branch_name'] ?></th>
            <?php } ?>
        </tr>

        <tr>
            <td>Applied</td>
            <?php foreach ($attendance_finalData as $branchData) { ?>
                <td style="color:<?= ($branchData['attendance_status_counts']['attendance_applied'] > 0) ? '#f00606' : '' ?>;text-align:center">
                    <?= $branchData['attendance_status_counts']['attendance_applied'] ?>
                </td>
            <?php } ?>
        </tr>

        <tr>
            <td>Level 1</td>
            <?php foreach ($attendance_finalData as $branchData) { ?>
                <td style="color:<?= ($branchData['attendance_status_counts']['attendance_level1'] > 0) ? '#f00606' : '' ?>;text-align:center">
                    <?= $branchData['attendance_status_counts']['attendance_level1'] ?>
                </td>
            <?php } ?>
        </tr>

        <tr>
            <td>Level 2</td>
            <?php foreach ($attendance_finalData as $branchData) { ?>
                <td style="color:<?= ($branchData['attendance_status_counts']['attendance_level2'] > 0) ? '#f00606' : '' ?>;text-align:center">
                    <?= $branchData['attendance_status_counts']['attendance_level2'] ?>
                </td>
            <?php } ?>
        </tr>

        <tr>
            <td>Level 3</td>
            <?php foreach ($attendance_finalData as $branchData) { ?>
                <td style="color:<?= ($branchData['attendance_status_counts']['attendance_level3'] > 0) ? '#f00606' : '' ?>;text-align:center">
                    <?= $branchData['attendance_status_counts']['attendance_level3'] ?>
                </td>
            <?php } ?>
        </tr>

        <tr>
            <td>Approved</td>
            <?php foreach ($attendance_finalData as $branchData) { ?>
                <td style="text-align:center"><?= $branchData['attendance_status_counts']['attendance_approved'] ?></td>
            <?php } ?>
        </tr>
    </table>
</div>
 <?php } ?>


        </div>
    </div>
</section> 

<style>
 .cards-sal{margin-top: 10px;}   
</style>