<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTableovertime", '
    var table;  // Declare a variable to hold the DataTable instance

    function filterDataTableovertime(expstatus)
    {
        var table_id = "#tbl_over_time_details";
        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();

        if (!$.fn.dataTable.isDataTable(table_id)) {
            // Initialize DataTable only if it has not been initialized yet
            table = $(table_id).DataTable({
                pageLength: 50,
                processing: true,
                ordering: false,
                searching: false,  // Hides the search box
                ajax: {
                    url: "' . Yii::app()->createUrl('hr/salarychecker/GetOverTimeList') . '",
                    type: "POST",
                    data: {"expstatus": expstatus, "branch_id": branch_id, "frmdate": frmdate, "todate": todate},
                    cache: false,
                },
                serverSide: true,
                fixedColumns: true,
                fixedHeader: {
                    headerOffset: $("header.main").outerHeight(),
                },
                autoWidth: false,
                "columnDefs": [
                    {
                        "targets": [4,5,6,7,8],  // Right-align these columns
                        "className":"dt-right"
                    }
                ]
            });
        } else {
            // If DataTable is already initialized, just reload the data
            table.ajax.reload();
        }

        $(".dataTables_scrollFoot").hide();
    }

    $(document).ready(function() {
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        filterDataTableovertime("",frmdate,todate);  // Initialize the table on page load
    });
', CClientScript::POS_HEAD);


$cs->registerScript("overtimeedetails", "function overtimeedetails(expstatus){  
    $('#tbl_over_time_details').DataTable().destroy();
    
    filterDataTableovertime(expstatus);
   
};", CClientScript::POS_HEAD);


?>




<!-- <div class="row"> -->
    <!-- <div class="col-sm-12">
<div id="chartdiv3"></div>
</div> -->
<div class="col-sm-12">
    <br/>
    <br/>
    <div id="content_tables" class="content_table10">
    
     <table class="table table-hover table-bordered personal-task" id="tbl_over_time_details" style="font-size:13px;">
                    <thead>
                        <tr>
                           <th>No</th>
                           <th>Branch</th>
                            <th>Employee Code</th>  
                            <th>Employee Name</th>  
                            <th>Normal Overtime </th>
                            <th>Holiday Overtime </th>
                            <th>Night Overtime </th>
                            <th>Weekend Overtime </th>
                            <th>Total Overtime </th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
<!-- </div> -->

<style>
.dt-right{text-align: right;}
</style>