<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTableloan", '
    function filterDataTableloan(loanstatus)
    {
        var table_id = "#tbl_employee_loan_details";
        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        var table = $(table_id).DataTable({
            pageLength: 50,
            processing: true,
            ordering: false,
            searching: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salarychecker/GetLoanDetailsChecker') . '",
                type: "POST",
                data: {"loanstatus": loanstatus, "branch_id": branch_id,"frmdate":frmdate,"todate":todate},
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight(),
            },
            autoWidth: false,
             "columnDefs": [
                    {
                        "targets": [4,5,6,9],  // Right-align these columns
                        "className":"dt-right"
                    }
                ]
        });
        $(".dataTables_scrollFoot").hide();
    }

    $(document).ready(function() {
       var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        filterDataTableloan("",frmdate,todate);
        $(".accordion-header").click(function() {
            $(this).toggleClass("active");
            $(this).next(".accordion-content").slideToggle();
        });
    });
', CClientScript::POS_HEAD);


$cs->registerScript("loandetails", "function loandetails(loanstatus){  
    $('#tbl_employee_loan_details').DataTable().destroy();
    
    filterDataTableloan(loanstatus);
   
};", CClientScript::POS_HEAD);
?>
<div class="row">
    <div class="col-md-12">
        <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="ch_staff_purchase">
                    <h4 class="panel-title">
                        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseTwo" aria-expanded="true" aria-controls="collapseTwo">
                            LOAN
                        </a>
                    </h4>
                </div>
                <div id="collapseTwo" class="panel-collapse collapse" role="tabpanel" aria-labelledby="ch_staff_purchase">
                    <div class="panel-body">
                        <div id="chartdiv1"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="col-sm-12">
    <div id="content_tables" class="content_table10">

        <table class="table table-hover table-bordered personal-task" id="tbl_employee_loan_details" style="font-size:13px;">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Branch</th>
                    <th>Employee Code</th>
                    <th>Employee Name</th>
                    <th>Loan Amount</th>  
                    <th>Monthly Payment</th>  
                    <th>No of Installment</th>
                    <th>Apply Date</th>
                    <th>Loan Date</th>
                    <th>Amount Paid</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
        </table>
    </div>
</div>
<!-- </div> -->

<?php
$model_loan_detail = new EmployeeLoanDetail();
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
if ($salary_branch_id) {

    // $loan_applied_condition = "loan_status= '1' AND employeedetail.branch_or_sponsor_id='".$salary_branch_id."' AND ((apply_date>= '".$from_date."' AND apply_date<= '".$to_date."') OR  (apply_date BETWEEN  '".$from_date."' AND  '".$from_date."' OR apply_date BETWEEN  '".$to_date."' AND  '".$to_date."'))";
    $loan_applied_condition = "loan_status= '1' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND apply_date <= '" . $to_date . "' AND apply_date >= '" . $from_date . "'";
} else {
    $loan_applied_condition = "loan_status= '1' AND apply_date <= '" . $to_date . "' AND apply_date >= '" . $from_date . "'";
}


if ($salary_branch_id) {
    $loan_level1_condition = "loan_status= '2' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND ((apply_date>= '" . $from_date . "' AND apply_date<= '" . $to_date . "') OR  (apply_date BETWEEN  '" . $from_date . "' AND  '" . $from_date . "' OR apply_date BETWEEN  '" . $to_date . "' AND  '" . $to_date . "'))";
} else {
    $loan_level1_condition = "loan_status= '2' AND ((apply_date>= '" . $from_date . "' AND apply_date<= '" . $to_date . "') OR  (apply_date BETWEEN  '" . $from_date . "' AND  '" . $from_date . "' OR apply_date BETWEEN  '" . $to_date . "' AND  '" . $to_date . "'))";
}

if ($salary_branch_id) {
    $loan_level2_condition = "loan_status= '4' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND ((apply_date>= '" . $from_date . "' AND apply_date<= '" . $to_date . "') OR  (apply_date BETWEEN  '" . $from_date . "' AND  '" . $from_date . "' OR apply_date BETWEEN  '" . $to_date . "' AND  '" . $to_date . "'))";
} else {
    $loan_level2_condition = "loan_status= '4' AND ((apply_date>= '" . $from_date . "' AND apply_date<= '" . $to_date . "') OR  (apply_date BETWEEN  '" . $from_date . "' AND  '" . $from_date . "' OR apply_date BETWEEN  '" . $to_date . "' AND  '" . $to_date . "'))";
}

if ($salary_branch_id) {
    $loan_level3_condition = "loan_status= '6' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND ((apply_date>= '" . $from_date . "' AND apply_date<= '" . $to_date . "') OR  (apply_date BETWEEN  '" . $from_date . "' AND  '" . $from_date . "' OR apply_date BETWEEN  '" . $to_date . "' AND  '" . $to_date . "'))";
} else {
    $loan_level3_condition = "loan_status= '6' AND ((apply_date>= '" . $from_date . "' AND apply_date<= '" . $to_date . "') OR  (apply_date BETWEEN  '" . $from_date . "' AND  '" . $from_date . "' OR apply_date BETWEEN  '" . $to_date . "' AND  '" . $to_date . "'))";
}

if ($salary_branch_id) {
    $loan_approved_condition = "loan_status= '12' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND ((apply_date>= '" . $from_date . "' AND apply_date<= '" . $to_date . "') OR  (apply_date BETWEEN  '" . $from_date . "' AND  '" . $from_date . "' OR apply_date BETWEEN  '" . $to_date . "' AND  '" . $to_date . "'))";
} else {
    $loan_approved_condition = "loan_status= '12'  AND ((apply_date>= '" . $from_date . "' AND apply_date<= '" . $to_date . "') OR  (apply_date BETWEEN  '" . $from_date . "' AND  '" . $from_date . "' OR apply_date BETWEEN  '" . $to_date . "' AND  '" . $to_date . "'))";
}


$loan_count_applied = $model_loan_detail->with('employeedetail')->count(array('condition' => $loan_applied_condition));
$loan_count_level1 = $model_loan_detail->with('employeedetail')->count(array('condition' => $loan_level1_condition));
$loan_count_level2 = $model_loan_detail->with('employeedetail')->count(array('condition' => $loan_level2_condition));
$loan_count_level3 = $model_loan_detail->with('employeedetail')->count(array('condition' => $loan_level3_condition));
$loan_count_approved = $model_loan_detail->with('employeedetail')->count(array('condition' => $loan_approved_condition));
?>

<!-- Chart code -->
<?php
$has_data = ($loan_count_applied > 0 || $loan_count_level1 > 0 || $loan_count_level2 > 0 || $loan_count_level3 > 0 || $loan_count_approved > 0);
?>
<?php if ($has_data): ?>
    <script>

        am4core.ready(function () {

            am4core.addLicense("ch-custom-attribution");

            // Themes begin
            am4core.useTheme(am4themes_animated);
            // Themes end

            // Create chart instance
            var chart = am4core.create("chartdiv1", am4charts.PieChart);

            // Add data
            chart.data = [{
                    "advancepaymentstatus": "Applied",
                    "litres": <?php echo $loan_count_applied; ?>
                }, {
                    "advancepaymentstatus": "Level 1",
                    "litres": <?php echo $loan_count_level1; ?>
                }, {
                    "advancepaymentstatus": "Level 2",
                    "litres": <?php echo $loan_count_level2; ?>
                }, {
                    "advancepaymentstatus": "Level 3",
                    "litres": <?php echo $loan_count_level3; ?>
                }, {
                    "advancepaymentstatus": "Approved",
                    "litres": <?php echo $loan_count_approved; ?>
                }];

            // Set inner radius
            chart.innerRadius = am4core.percent(50);
            chart.legend = new am4charts.Legend();
            // Set inner radius
            chart.innerRadius = am4core.percent(50);

            // Add and configure Series
            var pieSeries = chart.series.push(new am4charts.PieSeries());
            pieSeries.dataFields.value = "litres";
            pieSeries.dataFields.category = "advancepaymentstatus";
            pieSeries.slices.template.stroke = am4core.color("#fff");
            pieSeries.slices.template.strokeWidth = 2;
            pieSeries.slices.template.strokeOpacity = 1;





            pieSeries.slices.template.events.on("hit", function (ev) {
                var labelname2 = (ev.target.dataItem.category);
                //alert(labelname2);
                if (labelname2 == 'Applied') {
                    loandetails(1);

                } else if (labelname2 == 'Level 1') {

                    loandetails(2);
                } else if (labelname2 == 'Level 2') {

                    loandetails(4);
                } else if (labelname2 == 'Level 3') {

                    loandetails(6);
                } else if (labelname2 == 'Level 4') {

                    loandetails(8);
                } else if (labelname2 == 'Level 5') {

                    loandetails(10);
                } else if (labelname2 == 'Approved') {

                    loandetails(12);
                }

            });

            // This creates initial animation
            pieSeries.hiddenState.properties.opacity = 1;
            pieSeries.hiddenState.properties.endAngle = -90;
            pieSeries.hiddenState.properties.startAngle = -90;

        }); // end am4core.ready()
    </script>
    <style>
        #chartdiv1 {
            width: 90%;
            height: 400px;
        }
    </style>
<?php endif; ?>