<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTableleave", '
    function filterDataTableleave(leavestatus) {
        var table_id = "#tbl_employee_leave_details";
        var branch_id = "' . $salary_branch_id . '";
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        var table = $(table_id).DataTable({
             //scrollY: "100%",
            pageLength: 50,
            processing: true,
            ordering: false,
            searching: false,  // Hides the search box
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salarychecker/GetEmployeeLeaveChecker') . '",
                type: "POST",
                "data": {"status": leavestatus, "branch_id": branch_id,"frmdate":frmdate,"todate":todate},
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight(),
            },
           autoWidth: false,     
        });
        $(".dataTables_scrollFoot").hide();
    }

    $(document).ready(function() {
        // Load the data with a default status
        filterDataTableleave(""); // Default status (change as needed)
        $(".accordion-header").click(function() {
            $(this).toggleClass("active");
            $(this).next(".accordion-content").slideToggle();
        });
    });
', CClientScript::POS_HEAD);

$cs->registerScript("leavedetails", "function leavedetails(leavestatus){  
    $('#tbl_employee_leave_details').DataTable().destroy();
    filterDataTableleave(leavestatus);
};", CClientScript::POS_HEAD);
?>

<div class="row">
    <div class="col-md-12">
        <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingOne">
                    <h4 class="panel-title">
                        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            LEAVE DETAILS
                        </a>
                    </h4>
                </div>
                <div id="collapseOne" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
                    <div class="panel-body">
                        <div id="chartdiv2"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="col-sm-12">
    <div id="content_tables" class="content_table10">
        <table class="table table-hover table-bordered personal-task" id="tbl_employee_leave_details" style="font-size:13px;">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Branch</th>
                    <th>Employee Code</th>
                    <th>Employee Name</th>
                    <th>Apply Date</th>  
                    <th>Leave Type</th>  
                    <th>Start Date</th>
                    <th>End Date</th>
                    <th>No of Days</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
        </table>
    </div>
</div>
<!-- </div> -->

<?php
$model_leave_detail = new EmployeeLeaveDetail();
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
$leave_applied_condition = "leave_status =1 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_approved_condition = "leave_status =12 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_level1_condition = "leave_status =2 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_level2_condition = "leave_status =4 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_level3_condition = "leave_status =6 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_cancel_applied_condition = "leave_status =14 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_cancel_level1_condition = "leave_status =15 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_cancel_level2_condition = "leave_status =17 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_cancel_level3_condition = "leave_status =19 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_cancel_approved_condition = "leave_status =25 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
$leave_cancelled_condition = "leave_status =27 AND  ((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
if ($salary_branch_id > 0) {
    $leave_applied_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_approved_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_level1_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_level2_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_level3_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_cancel_applied_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_cancel_level1_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_cancel_level2_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_cancel_level3_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_cancel_approved_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
    $leave_cancelled_condition .= " AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "'";
}
$leave_count_applied = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_applied_condition));
$leave_count_approved = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_approved_condition));
$leave_count_level1 = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_level1_condition));
$leave_count_level2 = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_level2_condition));
$leave_count_level3 = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_level3_condition));
$leave_count_cancel_applied = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_cancel_applied_condition));
$leave_count_cancel_level1 = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_cancel_level1_condition));
$leave_count_cancel_level2 = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_cancel_level2_condition));
$leave_count_cancel_level3 = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_cancel_level3_condition));
$leave_count_cancel_approved = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_cancel_approved_condition));
$leave_count_cancelled = $model_leave_detail->with('employeedetail')->count(array('condition' => $leave_cancelled_condition));
$hasLeaveData = $leave_count_applied > 0 || $leave_count_level1 > 0 || $leave_count_level2 > 0 || $leave_count_level3 > 0 || $leave_count_approved > 0 || $leave_count_cancel_applied > 0 || $leave_count_cancel_level1 > 0 || $leave_count_cancel_level2 > 0 || $leave_count_cancel_level3 > 0 || $leave_count_cancel_approved > 0 || $leave_count_cancelled > 0;
?>
<!-- Chart code -->
<?php if ($hasLeaveData): ?>
    <script>

        am4core.ready(function () {
            am4core.addLicense("ch-custom-attribution");
            am4core.useTheme(am4themes_animated);
            var chart2 = am4core.create("chartdiv2", am4charts.PieChart);

            // Add data
            chart2.data = [{
                    "leavestatus": "Applied",
                    "leavecount": <?php echo $leave_count_applied; ?>
                }, {
                    "leavestatus": "Level 1",
                    "leavecount": <?php echo $leave_count_level1; ?>
                }, {
                    "leavestatus": "Level 2",
                    "leavecount": <?php echo $leave_count_level2; ?>
                }, {
                    "leavestatus": "Level 3",
                    "leavecount": <?php echo $leave_count_level3; ?>
                }, {
                    "leavestatus": "Approved",
                    "leavecount": <?php echo $leave_count_approved; ?>
                }, {
                    "leavestatus": "Cancel Request- Applied",
                    "leavecount": <?php echo $leave_count_cancel_applied; ?>
                }, {
                    "leavestatus": "Cancel Request -Level 1 Confirmed",
                    "leavecount": <?php echo $leave_count_cancel_level1; ?>
                }, {
                    "leavestatus": "Cancel Request -Level 2 Confirmed",
                    "leavecount": <?php echo $leave_count_cancel_level2; ?>
                }, {
                    "leavestatus": "Cancel Request -Level 3 Confirmed",
                    "leavecount": <?php echo $leave_count_cancel_level3; ?>
                }, {
                    "leavestatus": "Cancel Request -Approved",
                    "leavecount": <?php echo $leave_count_cancel_approved; ?>
                }, {
                    "leavestatus": "Cancelled",
                    "leavecount": <?php echo $leave_count_cancelled; ?>
                }

            ];

            // Set inner radius
            chart2.innerRadius = am4core.percent(50);
            chart2.legend = new am4charts.Legend();
            // Set inner radius
            chart2.innerRadius = am4core.percent(50);

            // Add and configure Series
            var pieSeries2 = chart2.series.push(new am4charts.PieSeries());
            pieSeries2.dataFields.value = "leavecount";
            pieSeries2.dataFields.category = "leavestatus";
            pieSeries2.slices.template.stroke = am4core.color("#fff");
            pieSeries2.slices.template.strokeWidth = 2;
            pieSeries2.slices.template.strokeOpacity = 1;
            pieSeries2.slices.template.events.on("hit", function (ev) {
                var labelname1 = (ev.target.dataItem.category);

                if (labelname1 == 'Applied') {
                    leavedetails(1);


                } else if (labelname1 == 'Level 1') {
                    leavedetails(2);
                } else if (labelname1 == 'Level 2') {
                    leavedetails(4);
                } else if (labelname1 == 'Level 3') {
                    leavedetails(6);
                } else if (labelname1 == 'Level 4') {
                    leavedetails(8);
                } else if (labelname1 == 'Level 5') {
                    leavedetails(10);
                } else if (labelname1 == 'Approved') {
                    leavedetails(12);
                }else if (labelname1 == 'Cancel Request- Applied') {
                    leavedetails(14);
                }else if (labelname1 == 'Cancel Request -Level 1 Confirmed') {
                    leavedetails(15);
                }else if (labelname1 == 'Cancel Request -Level 2 Confirmed') {
                    leavedetails(17);
                }else if (labelname1 == 'Cancel Request -Level 3 Confirmed') {
                    leavedetails(19);
                }else if (labelname1 == 'Cancel Request -Level 4 Confirmed') {
                    leavedetails(21);
                }else if (labelname1 == 'Cancel Request -Level 5 Confirmed') {
                    leavedetails(23);
                }else if (labelname1 == 'Cancel Request -Approved') {
                    leavedetails(25);
                }else if (labelname1 == 'Cancelled') {
                    leavedetails(27);
                }

            });

            // This creates initial animation
            pieSeries2.hiddenState.properties.opacity = 1;
            pieSeries2.hiddenState.properties.endAngle = -90;
            pieSeries2.hiddenState.properties.startAngle = -90;

        }); // end am4core.ready()
    </script>
<?php endif; ?>
<style>
    #chartdiv2 {
        width: 90%;
        height: 400px;
    }
</style>
