<?php

$cs = Yii::app()->getClientScript();

$cs->registerScript("filterDataTableiban", '

    var table;  // Declare a variable to hold the DataTable instance



    function filterDataTableiban(expstatus)

    {

        var table_id = "#tbl_iban_details";

        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here

        var frmdate=$("#from_date").val();

        var todate=$("#to_date").val();



        if (!$.fn.dataTable.isDataTable(table_id)) {

            // Initialize DataTable only if it has not been initialized yet

            table = $(table_id).DataTable({

                pageLength: 50,

                processing: true,

                ordering: false,

                searching: false,  // Hides the search box

                ajax: {

                    url: "' . Yii::app()->createUrl('hr/salarychecker/GetibanDetails') . '",

                    type: "POST",

                    data: {"expstatus": expstatus, "branch_id": branch_id, "frmdate": frmdate, "todate": todate},

                    cache: false,

                },

                serverSide: true,

                fixedColumns: true,

                fixedHeader: {

                    headerOffset: $("header.main").outerHeight(),

                },

                autoWidth: false,
               rowCallback: function(row, data, index) {
                    
                    if (data[4] !== "" && data[5] === true) {  
                        var currentContent = $(row).find("td").last().text(); 
                        var newContent = currentContent + " <span style=\'color: blue; font-weight: bold;\'>***</span>";
                        $(row).find("td").last().html(newContent); 
                    }
                
                 }
                

            });

        } else {

            // If DataTable is already initialized, just reload the data

            table.ajax.reload();

        }



        $(".dataTables_scrollFoot").hide();

    }



    $(document).ready(function() {

        var frmdate=$("#from_date").val();

        var todate=$("#to_date").val();

        filterDataTableiban("",frmdate,todate);  // Initialize the table on page load

    });

', CClientScript::POS_HEAD);





$cs->registerScript("ibandetails", "function ibanedetails(expstatus){  

    $('#tbl_iban_details').DataTable().destroy();

    

    filterDataTableiban(expstatus);

   

};", CClientScript::POS_HEAD);





?>

<div class="col-sm-12">

    

    <span style="font-weight: bold;">Note :- </span><span style="color: red; font-style: italic; font-weight: bold;"> ** Below data not based on filtered date </span> 
    <br>
    <br>
    <span style="color: red; font-weight: bold;"> IBAN NO with '***' indicates duplicate entires</span>
    <br>

    <br>

    <div id="content_tables" class="content_table10">

    

     <table class="table table-hover table-bordered personal-task" id="tbl_iban_details" style="font-size:13px;">

                    <thead>

                        <tr>

                           <th>No</th>

                           <th>Branch</th>

                            <th>Employee Code</th>  

                            <th>Employee Name</th>  

                             <th>IBAN No</th>

                        </tr>

                        </thead>

                    </table>

                </div>

            </div>

<!-- </div> -->



<style>

.dt-right{text-align: right;}

</style>