<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTableattendance", '
    function filterDataTableattendance(attstatus)
    {
        var table_id = "#tbl_employee_attendance_details";
        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        var table = $(table_id).DataTable({
            pageLength: 50,
            processing: true,
            ordering: false,
            searching: false,  // Hides the search box
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salarychecker/GetAttendanceDetailsChecker') . '",
                type: "POST",
                data: {"attstatus": attstatus, "branch_id": branch_id,"frmdate":frmdate,"todate":todate},
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight(),
            },
            autoWidth: false,
        });
        $(".dataTables_scrollFoot").hide();
    }

    $(document).ready(function() {
       var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        filterDataTableattendance("",frmdate,todate);
    });
', CClientScript::POS_HEAD);




?>




<!-- <div class="row"> -->
    <div class="col-sm-12">
<div id="chartdiv53"></div>
</div>
<div class="col-sm-12">
    <br/>
    <br/>
    <div id="content_tables" class="content_table10">
    
     <table class="table table-hover table-bordered personal-task" id="tbl_employee_attendance_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Employee Name</th>
                            <th>Absent Date</th> 
                            <th>Status</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
<!-- </div> -->

<?php
$model_attendance_detail = new EmployeeAttendance();
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
$absent_condition = "status= '2' AND employeedetail.branch_or_sponsor_id='".$salary_branch_id."' AND (attendance_date BETWEEN '".$from_date."' AND '".$to_date."')";
$leave_count_absent = $model_attendance_detail->with('employeedetail')->count(array('condition' => $absent_condition));
$leave_att_condition = "status= '3' AND employeedetail.branch_or_sponsor_id='".$salary_branch_id."' AND (attendance_date BETWEEN '".$from_date."' AND '".$to_date."')";
$leave_count_att = $model_attendance_detail->with('employeedetail')->count(array('condition' => $leave_att_condition));





?>
<!-- Chart code -->
<?php
$has_data = ($leave_count_absent > 0 || $leave_count_att > 0 );

?>
<?php if ($has_data): ?>

<script>

am4core.ready(function() {
am4core.addLicense("ch-custom-attribution");
am4core.useTheme(am4themes_animated);
var chart3 = am4core.create("chartdiv53", am4charts.PieChart);

// Add data
chart3.data = [ {
  "attendancestatus": "Absent",
  "litres":  <?php echo $leave_count_absent;?>
}, {
  "attendancestatus": "Leave",
  "litres": <?php echo $leave_count_att;?>
} ];

// Set inner radius
chart3.innerRadius = am4core.percent(50);
chart3.legend = new am4charts.Legend();
// Set inner radius
chart3.innerRadius = am4core.percent(50);

// Add and configure Series
var pieSeries3 = chart3.series.push(new am4charts.PieSeries());
pieSeries3.dataFields.value = "litres";
pieSeries3.dataFields.category = "attendancestatus";
pieSeries3.slices.template.stroke = am4core.color("#fff");
pieSeries3.slices.template.strokeWidth = 2;
pieSeries3.slices.template.strokeOpacity = 1;





pieSeries3.slices.template.events.on("hit", function(ev){
  var labelname1 = (ev.target.dataItem.category);
  
  if(labelname1 == 'Absent'){
    attendancedetails(2);
}

  else if(labelname1 == 'Leave'){
  
    attendancedetails(3);
  }

  

});

// This creates initial animation
pieSeries3.hiddenState.properties.opacity = 1;
pieSeries3.hiddenState.properties.endAngle = -90;
pieSeries3.hiddenState.properties.startAngle = -90;

}); // end am4core.ready()
</script>





<style>
#chartdiv3 {
  width: 60%;
  height: 200px;
}

</style>
<?php endif; ?>
