
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable() {
        var table_id ="#table_edit_salary";
        var id  = $("#slip_id").val();
        var emp_id  = $("#s_employee_id_value").val();
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salary/getmonthlylist') . '",
                type: "POST",
                "data" : {
                    "id" : id,"emp_id" : emp_id,        
                },
                cache : false,
            },
             columns: [            
                {className: "" },
                {className: ""},
                {className: "" },
                {className: "text-right"}, 
                {className: "text-right"}, 
                {className: "text-right"}, 
                {className: "text-right"},
                {className: "text-right"},
            ],
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            aaSorting: [[2, "asc"]],
//            order: [[ 2, "desc" ]],
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
               AddContextMenu(nRow, aData);
            }
        });
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	
      filterDataTable();
    })', CClientScript::POS_HEAD);
$cs->registerScript("salarydetails", "function salarydetails(){  
    $('#table_edit_salary').DataTable().destroy();
    filterDataTable();
};", CClientScript::POS_HEAD);
$cs->registerScript("rollbackemployeesalary", "function rollbackemployeesalary(id){
    var r = confirm('Confirm rollback of salary detail ?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType':'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/salary/rollbackemployeesalary',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#table_edit_salary');
                    t8.success('Successfully deleted payroll details');
                }else{
                    t8.error('Error in deleting payroll details');
                }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[8].edit_salary !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    window.location.href = $('#liveSite').val() + "/index.php?r=hr/salary/editemployeesalarydetail&id=" + datas[8].en_slip_id;
                }
            };
        }
        if (datas[8].rollback_salary !== 0) {
            items.Delete = {
                name: "Roll Back",
                icon: "fa-rotate-left",
                callback: function () {
                    rollbackemployeesalary(datas[8].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <div class="col-sm-4" style=" width:43%;">
            <input type="hidden" id="slip_id" name="slip_id" value="<?php echo $id; ?>"/>
            Edit <?php echo date('F', strtotime($model->payroll_enddate)) . '-' . date('Y', strtotime($model->payroll_enddate)) . '(' . $model->branch_sponsor->branch_or_sponsor_name . ')'; ?> Salary Details
        </div>
        <div class="pull-left col-sm-4" style=" width: 34%;padding: 0;">
            <?php echo CHtml::dropdownlist('p_employee_id_value', '', SalarySlip::getSalaryEmployee($model->id), array('empty' => 'Pending Employee List', 'class' => 'col-sm-3 form-control_1 btn-danger', 'title' => 'Please Select Employee', 'data-search' => true, 'style' => 'width:250px;')); ?>                                 
            <button class="btn btn-sm btn-warning" onclick="loadPopupModal('hr/salary/pendingsalary&id=<?php echo $model->id; ?>', 'Calculate Pending Salary', 'xl')"><i class="fa fa-money"></i> Calculate Pending List</button> 
        </div>

        <div class="pull-right col-sm-4" style="width: 23%;padding: 0; ">
            <?php echo CHtml::dropdownlist('s_employee_id_value', '', SalarySlip::getEmployee($model->id), array('empty' => 'All Employees', 'class' => 'col-sm-3 form-control_1', 'title' => 'Please Select Employee', 'onchange' => 'salarydetails();', 'data-search' => true, 'style' => 'width:250px;')); ?>                   
            <a href="<?php echo Yii::app()->baseUrl; ?>/index.php?r=hr/excel/PrintSalaryBeforeExcel&sponser_id=<?php echo $model->payroll_branch_or_sponsor_id; ?>&year=<?php echo date('Y', strtotime($model->payroll_enddate)); ?>&month=<?php echo date('m', strtotime($model->payroll_enddate)); ?>" class="btn btn-sm btn-theme pull-left" title="Download Payroll Details" style="margin-right: 10px;"><i class="fa fa-file-excel-o" style=" line-height: 20px;"></i></a> 
        </div> 
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="table_edit_salary">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Salary</th>
                        <th>Total Addition</th>
                        <th>Gross Salary</th>
                        <th>Total Deduction</th>
                        <th>Net Amount</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
