<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'salarydeduction-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="tbl_monthly_deduction">
        <tr>
            <th>No</th>
            <th>Employee Name</th>
            <th>Deduction %
                <?php
                echo CHtml::Textfield('deduct_percent','',array('class' => 'form-control','placeholder'=>'Enter Deduction Percentage(%)','onkeypress' => 'return isPositiveNumber(event)','onkeyup'=>'$(".deduct_percentage").val(this.value); calculatedeductionpercentage();'));
               ?>
            </th>
            <th>Other Deduction</th>
            <th>Total Deductions</th>
            <th>Net Salary</th>
        </tr>
        <?php 
        if (!empty($arr_employee)) {
            $i = 0;
            foreach ($arr_employee as $each) {
                $model_salary_slip_detail = SalarySlip::model()->find(array('condition' =>'salary_processing_id="'.$slip_id.'" AND employee_id="'.$each.'"'));
                ?>
                <tr>
                    <td><?php echo($i + 1); ?></td>
                    <td><?php echo $model_salary_slip_detail->employeedetail->employeefullname; ?>
                        <?php 
                            echo $form->hiddenField($model_salary_slip_detail, '['.$i.']id');
                            echo $form->hiddenField($model_salary_slip_detail, '['.$i.']employee_id');
                            echo $form->hiddenField($model_salary_slip_detail, '['.$i.']old_other_deduction', array('value' => $model_salary_slip_detail->other_deduction));
                            echo $form->hiddenField($model_salary_slip_detail, '['.$i.']old_total_deduction_amount', array('value' => $model_salary_slip_detail->total_deduction_amount));
                            echo $form->hiddenField($model_salary_slip_detail, '['.$i.']old_total_salary_amount', array('value' => $model_salary_slip_detail->total_salary_amount));
                        ?>
                    </td>
                    <td><?php echo $form->textField($model_salary_slip_detail, '['.$i.']deduction_percentage',array('class'=>'go text-right deduct_percentage','onkeypress' => 'return isPositiveNumber(event)','onkeyup'=>'calculatededuction(this.id);')); ?></td>
                    <td><?php echo $form->textField($model_salary_slip_detail, '['.$i.']other_deduction',array('class'=>'go text-right','readonly' =>true)); ?></td>
                    <td><?php echo $form->textField($model_salary_slip_detail, '['.$i.']total_deduction_amount',array('class'=>'go text-right','readonly'=>true));?></td>
                    <td><?php echo $form->textField($model_salary_slip_detail, '['.$i.']total_salary_amount',array('class'=>'go text-right','readonly'=>true)); ?></td>
                </tr>
                <?php
                $i++;
            }
        }
        ?>
    </table> 
</div>    
<div class="modal-footer"> 
    <button type="button" class="btn btn-default " id="adddeduction_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/salary/SaveDeductionAmount');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {  
                    if(data.status=="success"){  
                        $("#adddeduction_close").click();
                        t8.success("Saved Successfully!","Success");
                    } else {                        
                            $.each(data, function(key, val) {
                            t8.error(""+val+""); 
                        }); 
                    } 
                }',
        'beforeSend' => 'function(){
                     $(".toast8-error").hide();
                    $("#loader").show();
                    $("#salarydeduction-form .salarydeduction-save-btn").prop("disabled", true);
                    $("#salarydeduction-form .salarydeduction-save-btn").addClass("btn_loding").removeClass("btn btn-primary"); 
                    $(".errorMessage").hide(); 
                    }',
        'complete' => 'function(){
                    $("#loader").hide();
                    $("#salarydeduction-form .salarydeduction-save-btn").prop("disabled", false);
                    $("#salarydeduction-form .salarydeduction-save-btn").addClass("btn btn-primary").removeClass("btn_loding"); 
                }'
            ), array('id' => 'save' . rand(), 'class' => 'salarydeduction-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("calculatedeductionpercentage", "function calculatedeductionpercentage() {
    var table_length=$('#tbl_monthly_deduction').find('tr:gt(0)').length;  
    for(i=0;i<table_length;i++){
        var deduct_percent = $('#SalarySlip_'+i+'_deduction_percentage').val(); 
        var old_other_deduction = $('#SalarySlip_'+i+'_old_other_deduction').val();
        var old_total_deduction_amount = $('#SalarySlip_'+i+'_old_total_deduction_amount').val();
        var old_total_salary = $('#SalarySlip_'+i+'_old_total_salary_amount').val();
        var other_deduction=total_deduction_amount=total_salary=0.00;
        if(parseFloat(deduct_percent)>0){
            var deducted_amount=(old_total_salary*deduct_percent)/100; 
            if(parseFloat(deducted_amount)>0){
                other_deduction=parseFloat(old_other_deduction)+parseFloat(deducted_amount);
                total_deduction_amount=parseFloat(old_total_deduction_amount)+parseFloat(deducted_amount); 
                total_salary=parseFloat(old_total_salary)-parseFloat(deducted_amount);
                $('#SalarySlip_'+i+'_other_deduction').val(other_deduction.toFixed(2));
                $('#SalarySlip_'+i+'_total_deduction_amount').val(total_deduction_amount.toFixed(2));
                $('#SalarySlip_'+i+'_total_salary_amount').val(total_salary.toFixed(2));
            }
        }else{
            $('#SalarySlip_'+i+'_other_deduction').val(old_other_deduction);
            $('#SalarySlip_'+i+'_total_deduction_amount').val(old_total_deduction_amount);
            $('#SalarySlip_'+i+'_total_salary_amount').val(old_total_salary);
        }
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("calculatededuction", "function calculatededuction(field_id) {
    var arr_fields 		= field_id.split('_');
    var model_name 		= arr_fields[0];
    var i 			= arr_fields[1];
    var row_field_name 	= arr_fields[2];
    var deduct_percent = $('#SalarySlip_'+i+'_deduction_percentage').val(); 
    var old_other_deduction = $('#SalarySlip_'+i+'_old_other_deduction').val();
    var old_total_deduction_amount = $('#SalarySlip_'+i+'_old_total_deduction_amount').val();
    var old_total_salary = $('#SalarySlip_'+i+'_old_total_salary_amount').val();
    var other_deduction=total_deduction_amount=total_salary=0.00;
    if(parseFloat(deduct_percent)>0){
        var deducted_amount=(old_total_salary*deduct_percent)/100; 
        if(parseFloat(deducted_amount)>0){
            other_deduction=parseFloat(old_other_deduction)+parseFloat(deducted_amount);
            total_deduction_amount=parseFloat(old_total_deduction_amount)+parseFloat(deducted_amount); 
            total_salary=parseFloat(old_total_salary)-parseFloat(deducted_amount);
            $('#SalarySlip_'+i+'_other_deduction').val(other_deduction.toFixed(2));
            $('#SalarySlip_'+i+'_total_deduction_amount').val(total_deduction_amount.toFixed(2));
            $('#SalarySlip_'+i+'_total_salary_amount').val(total_salary.toFixed(2));
        }
    }else{
        $('#SalarySlip_'+i+'_other_deduction').val(old_other_deduction);
        $('#SalarySlip_'+i+'_total_deduction_amount').val(old_total_deduction_amount);
        $('#SalarySlip_'+i+'_total_salary_amount').val(old_total_salary);
    }
    
};", CClientScript::POS_HEAD);
?>
            


