<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddata", 'function filterDataTable(){
        var branch_id= $("#salary_cmp_branch_id").val();
        var month= $("#salary_cmp_month_id").val();	
        var year= $("#salary_cmp_year_id").val();	
        var table_id ="#table_salary_component";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
//            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 100,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salary/getcomponentlist') . '",
                type: "POST",
                "data" : {
                    "branch_id" : branch_id,"month" : month,"year" : year            
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,  
            order: [[ 2, "desc" ],[ 3, "desc" ]],
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        });
        $(".dataTables_scrollFoot").hide();
    }	
    $(document).ready(function() {  	 	
        filterDataTable();
         materializing(".material");
    });', CClientScript::POS_HEAD);
$cs->registerScript("salarydetails",  "function salarydetails(){  
    $('#table_salary_component').DataTable().destroy();
    filterDataTable(); 
};", CClientScript::POS_HEAD);
$cs->registerScript("deletesalarycomponentdetails", "function deletesalarycomponentdetails(id) {
    if( confirm('Are you sure want to delete the salary component list ?') ){
        jQuery.ajax({
            'dataType':'json',
            'data': { 'id':id }  ,
            'type':'post',
            'url'  : $('#liveSite').val()+'index.php?r=hr/salary/deletesalarycomponentdetails',
            'cache': false,
            'success': function(data) {
                if( data.status == 'success' ){
                    t8.success('Deleted Successfully');
                    reloadTable('#table_salary_component');
                }else
                    t8.success('Error in Deleting Data');
            },
            'beforeSend':function(){
               $('#loader').show();                      
            },
            'complete':function(){
                $('#loader').hide();   
            }
        });
    }
};", CClientScript::POS_HEAD);

  ?>
    <script>
         function AddContextMenu(row, datas) { 
                let items = {};
                if (datas[4].view_button !== 0) {
                    items.view = {
                        name: "View",
                        icon: "fa-eye",
                        callback: function () {
                             loadPopupModal("hr/salary/viewsalarycomponentdetails&id=" + datas[4].id, 'View Salary Component List', "lg");
                    }
                    };
                }
                if (datas[4].download_button !== 0) {
                    items.download = {
                        name: "Download",
                        icon: "fa-download",
                        callback: function () {
                            window.open($('#liveSite').val() + "/index.php?r=hr/salary/downloadsalarycomponentlist&id=" + datas[4].id, "_blank");
                    }
                    };
                }
                if (datas[4].delete_button !== 0) {
                    items.delete = {
                        name: "Delete",
                        icon: "fa-trash",
                        callback: function () {
                            deletesalarycomponentdetails(datas[4].id)
                    }
                    };
                }
                
                

               if (Object.keys(items).length > 0) {
                   $(row).contextMenu({
                       selector: 'td',
                       items: items
                   });
               }
           }

    </script>
  <style>
    #employeesalaryindexdropdown .material-select-label {
        display: none;
    }
    </style>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            Salary Details
            <div class="pull-right dis-flx">
                <div class="material col-sm-12 pd-zero" id="employeesalaryindexdropdown"> 
                <span class="col-sm-3 pull-right">
            <?php echo CHtml::dropdownlist('salary_cmp_year_id','',HrGenerelSettings::listYears(4, 0),  array('empty' => 'Year','title' => 'Please Select Year','data-search'=>true,'onchange'=>'salarydetails();','style'=>'width:100px;')); ?>                                                   
                </span>

                <span class="col-sm-3 pull-right">   
            <?php echo CHtml::dropdownlist('salary_cmp_month_id','',HrGenerelSettings::listMonths(),  array('empty' => 'Month','title' => 'Please Select Month','data-search'=>true,'onchange'=>'salarydetails();','style'=>'width:100px;')); ?>                                                   
                </span>
                <span class="col-sm-3 pull-right">      
            <?php echo CHtml::dropdownlist('salary_cmp_branch_id','',MasCompanyBranchSponsor::getSalaryBranches(),  array('empty' => 'All Branches','title' => 'Please Select Branch','data-search'=>true,'onchange'=>'salarydetails();','style'=>'width:150px;')); ?>                                                   
                </span>
        </div>
                 <?php
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_component_upload'])  || Yii::app()->user->authorised_user == 1) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/salary/uploadsalarycomponent','Upload Salary Component','xl')" title="Upload Salary Component Details"><i class="fa fa-money"></i> <i class="fa fa-upload"></i></button>  
                <?php } ?>

               </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="table_salary_component" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Branch</th>
                            <th>Month</th>
                            <th>Year</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
