<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddata", 'function filterDataTable(){
        var branch_id= $("#salary_branch_id").val();
        var month= $("#salary_month_id").val();	
        var year= $("#salary_year_id").val();	
        var table_id ="#table_salary_history";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
//            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 100,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salary/getsalaryhistory') . '",
                type: "POST",
                "data" : {
                    "branch_id" : branch_id,"month" : month,"year" : year            
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,  
            order: [[ 2, "desc" ]],
            "rowCallback": function (row, data){
                if (data[7] ==1){
                    $("td", row).css("background-color", "#ffcccb");
                }else{
                    $("td", row).css("background-color", "#CCFFD4");
                }
            },
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
               AddContextMenu(nRow, aData);
            }
        });
        $(".dataTables_scrollFoot").hide();
    }	
    $(document).ready(function() {  	 	
        filterDataTable();
         materializing(".material");
    });', CClientScript::POS_HEAD);
$cs->registerScript("salarydetails",  "function salarydetails(){  
    $('#table_salary_history').DataTable().destroy();
    filterDataTable(); 
};", CClientScript::POS_HEAD);
$cs->registerScript("connect_to_finance", "function connect_to_finance(id, flag) {
    if( confirm('Are you sure?') ){
        $('#loader').show();
        var url = ( flag == 'POST' ) ? '" . Yii::app()->createUrl('finance/hr/generatesalaryVoucher') . "' : '" . Yii::app()->createUrl('finance/hr/deletesalaryvoucher') . "';
        var msg = ( flag == 'POST' ) ? 'Voucher Posted' : 'Voucher Unposted';
        jQuery.ajax({
            'dataType':'json',
            'data': { 'id':id }  ,
            'type':'post',
            'url': url,
            'cache': false,
            'success': function(data) {
                $('#loader').hide();
                if( data.status == 'success' ){
                    t8.success(msg);
                    reloadTable('#table_salary_history');
                }else
                    t8.success(data.msg);
            },
        });
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("DisableSalarySlip",  "function DisableSalarySlip(id,status){
    var r = confirm((status == 'Y') ? 'Are you sure to Disable Salary Slip View?' : 'Are you sure to enable Salary Slip View?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType':'json',
              'data'  : 'id=' + id+'&status='+status,
              'url'  : $('#liveSite').val()+'index.php?r=hr/Salary/Disable',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#table_salary_history');
                    t8.success('Success');
                }else{
                    t8.error('Failed');
                }
               }
            });
        }
};", CClientScript::POS_HEAD);
$cs->registerScript("rollbacksalarydetails", "function rollbacksalarydetails(processing_id) {
    jConfirm('Rollback Salary?', 'Confirmation Dialog', function(r) {
        if (r == true) {
            jQuery.ajax({
                'dataType':'json',
                'data' : {'processing_id':processing_id},
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/salary/rollbacksalary') . "',
                'cache': false,
                'success': function(data) {
                    if(data.status=='success'){
                        reloadTable('#table_edit_salary');
                        reloadTable('#table_salary_history');
                        t8.success('Salary Rollbacked successfully');
                    }else{
                        t8.error('Error');
                    } 
                }, 
                'beforeSend':function(){
                  $('#loader').show();                      
                },
                'complete':function(){
                    $('#loader').hide();   
                }
            });    
        }
    }); 
    reloadTable('#table_edit_salary');
};", CClientScript::POS_HEAD);

$cs->registerScript("locksalarydetails", "function locksalarydetails(processing_id) {
    jConfirm('Lock Salary ?', 'Confirmation Dialog', function(r) {
        if (r == true) {
            jQuery.ajax({
                'dataType':'json',
                'data' : {'processing_id':processing_id},
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/salary/locksalary') . "',
                'cache': false,
                'success': function(data) {
                    if(data.status=='success'){
                        reloadTable('#table_edit_salary');
                        reloadTable('#table_salary_history');
                        t8.success('Salary Locked successfully');
                    }else{
                        t8.error('Error');
                    } 
                }, 
                'beforeSend':function(){
                  $('#loader').show();                      
                },
                'complete':function(){
                    $('#loader').hide();   
                }
            });
        }
    }); 
    reloadTable('#table_edit_salary');
};", CClientScript::POS_HEAD);
  ?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[6].salary_edit !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    window.location.href = $('#liveSite').val() + "/index.php?r=hr/salary/salaryeditindex&id=" + datas[6].en_id;
                }
            };
        }
        if (datas[6].salary_roll_back !== 0) {
            items.rollback = {
                name: "Roll Back",
                icon: "fa-rotate-left",
                callback: function () {
                    rollbacksalarydetails(datas[6].id);
                }
            };
        }
        if (datas[6].salary_lock !== 0) {
            items.lock = {
                name: "Lock",
                icon: "fa-lock",
                callback: function () {
                    locksalarydetails(datas[6].id);
                }
            };
        }
        if (datas[6].salary_view !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/salary/viewsalarydetails&id=" + datas[6].id, "SALARY DETAILS", "xl");
                }
            };
        }
        if (datas[6].salary_disable !== 0) {
            items.disable = {
                name: (datas[6].slip_status== "Y") ? "Disable Payslip" : "Enable Payslip",
                icon: (datas[6].slip_status == "Y") ? "fa-ban" : "fa-retweet",
                callback: function () {
                    DisableSalarySlip(datas[6].id,datas[6].slip_status);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
  <style>
    #salaryhistoryindexdropdown .material-select-label {
        display: none;
    }
    </style>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">Salary Details
            <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="salaryhistoryindexdropdown">    
            <span class="col-sm-3 pull-right"> 
            <?php echo CHtml::dropdownlist('salary_year_id','',HrGenerelSettings::listYears(4, 0),  array('empty' => 'Year','title' => 'Please Select Year','data-search'=>true,'onchange'=>'salarydetails();','style'=>'width:100px;')); ?>                                                   
           </span>
           <span class="col-sm-3 pull-right"> 
            <?php echo CHtml::dropdownlist('salary_month_id','',HrGenerelSettings::listMonths(),  array('empty' => 'Month','title' => 'Please Select Month','data-search'=>true,'onchange'=>'salarydetails();','style'=>'width:100px;')); ?>                                                   
             </span>
           <span class="col-sm-3 pull-right">    
            <?php echo CHtml::dropdownlist('salary_branch_id','',MasCompanyBranchSponsor::getSalaryBranches(),  array('empty' => 'All Branches','title' => 'Please Select Branch','data-search'=>true,'onchange'=>'salarydetails();','style'=>'width:150px;')); ?>                                                   
           </span>
          </div>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/salary/index', 'Salary Calculation', 'xl')" title="Salary Calculation"><i class="fa fa-calculator"></i></button>
        </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="table_salary_history" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Branch</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Month</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
