<script type="text/javascript" src="plugins/roster/roster.js"></script>
<link rel="stylesheet" type="text/css" href="plugins/roster/roster-style.css" />
<div>
    <div class="panel">
        <header class="panel-heading clearfix">
            <ul class="clearfix form-ul material">
                <li class="col-sm-3 roas-br">
                    <?php
                    $condition = 'isActive =  "Y" ';
                    if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
                        $condition .= ' AND id IN (' . Yii::app()->user->user_branch . ')';
                    }
                    $model_branch = MasCompanyBranchSponsor::model()->findall(array('condition' =>$condition));
                    $branch_id = 0;
                    if (!empty($model_branch)) {
                    //    $branch_id = $model_branch[0]->id;
                    }
                    $list = CHtml::listData($model_branch, 'id', 'branch_or_sponsor_name');
                    echo CHtml::dropdownlist('branch_id', $branch_id, $list, array('data-label' => 'Branch <span style="color:red">*</span>','data-search'=>'true', 'empty' => "All Branch", 'onchange' => 'getEmployeedetails();'));
                    ?>
                </li>
                <li class="col-sm-3 roas-br" id="li_emp_data">
                    <?php
                    $user_login_id = Yii::app()->user->id;
                    $model_user = User::model()->findbypk($user_login_id);
                    $condition_1 = 'isActive =  "Y" ';
                    $is_reporting_manger = Employee::model()->count(array('condition' => 'reporting_manager="' . $model_user->hr_connected_employee_id . '" AND t.isActive="Y"'));       
                    if($branch_id>0){
                      $condition_1 .= ' AND branch_or_sponsor_id IN (' . $branch_id . ')';  
                    }else if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
                         $condition_1 .= ' AND branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
                    }
                    if ($is_reporting_manger > 0) {
                        $condition_1 .= ' and t.reporting_manager="' . $model_user->hr_connected_employee_id . '"';
                    }
                    $model_employee = Employee::model()->findall(array('condition' => $condition_1, 'order' => 'de_first_name'));
                    $employee_list = CHtml::listData($model_employee, 'id', 'employeenamecode');
                    echo CHtml::dropdownlist('employee_id','' , $employee_list, array('data-label' => 'Employee', 'empty' => "All Employee", 'data-search'=>'true','onchange' => 'setRosterTable();'));
                    ?>
                </li>
                <li class="col-sm-3 dte-roast">
                    <?php
                    $start_date = date("d/m/Y");
                    $end_date = date("d/m/Y", strtotime("+7 day"));
                    echo CHtml::textField('start_date', $start_date, array('data-label' => 'Start Date <span style="color:red">*</span>', 'class' => 'datepicker', 'onblur' => 'setWeekRange();'));
                    ?>

                    <?php echo CHtml::hiddenField('end_date', $end_date, array('data-label' => 'To Date <span style="color:red">*</span>', 'class' => 'datepicker', 'onblur' => 'setWeekRange();')); ?>
                </li>

<!--                <li class="col-sm-1">
                    <?php
//                    $off_day = [
//                        "id" => 'OFF',
//                        "name" => 'OFF-DAY',
//                        "start_time" => ' ',
//                        "end_time" => ' ',
//                        "color_code" => 'green',
//                        "branch_id" => 0,
//                        "branch_name" => ' ',
//                    ];
                    ?>
                    <div style="background-color: lightgrey; width: 100%;height: 100%;padding: 10px;box-shadow: beige;box-shadow: 2px 2px #888;"
                         jdata="<?php echo htmlentities(json_encode($off_day)); ?>" id="shift_master_id_0_0" class="master-shift" draggable="true">
                        <i class="fa fa-power-off"></i>&nbsp;&nbsp;OFF DAY
                    </div>
                </li>-->
                <li class="col-sm-1">
                    <button class="btn btn-sm btn-theme" onclick="onprint(); return false;" title="Print">
                        <i class="fa fa-print fa-5x"></i>
                    </button>
                    <script>
                        function onprint() {
                            var url = "index.php?r=hr/roster/print&";
                            var data = {
                                start_date: $("#start_date").val(),
                                end_date: $("#end_date").val(),
                                branch_id: $("#branch_id").val(),
                                employee_id: $("#employee_id").val()
                            };
                            var param = $.param(data);
                            window.open(url + param);
                        }
                    </script>
                </li>
            </ul>
        </header>
        <div class="panel-body">
            <div class="col-sm-10">
                <table id="roster-table" class="table">
                    <thead>

                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
            <div class="col-sm-2">
                <div id="panel-shift" style=" width: 15%;position: fixed; bottom: 10px; right: 50px;">
                    <div class="brach-master-container">
                        <?php
                        $off_day = [
                            "id" => 'OFF',
                            "name" => 'OFF-DAY',
                            "start_time" => ' ',
                            "end_time" => ' ',
                            "color_code" => 'green',
                            "branch_id" => 0,
                            "branch_name" => ' ',
                        ];
                        ?>
                        <div style="background-color:  #73e446; width: 100%;height: 100%;padding: 10px;box-shadow: beige;box-shadow: 2px 2px #888; color: #000; font-weight: bold;"
                             jdata="<?php echo htmlentities(json_encode($off_day)); ?>" id="shift_master_id_0_0" class="master-shift" draggable="true">
                            <i class="fa fa-power-off"></i>&nbsp;&nbsp;OFF DAY
                        </div>
                    </div>
                    <?php
                    $model_shift = MasShift::model()->findall(array('condition' => 't.isActive="Y"'));
                    foreach ($model_branch as $valuebranch) {
                        ?>
                        <div class="brach-master-container">

                            <label style="display: block; padding: 6px" class="brach-master-label" onclick="toggleShift('<?php echo $valuebranch->id; ?>')">
                                <i class="fa fa-user"></i>&nbsp; Branch : <?php echo $valuebranch->branch_or_sponsor_name; ?>
                            </label>

                            <script>
                                function toggleShift(id) {
                                    var selectedDiv = "#shift-list-container-" + id;
                                    $(".shift-list-container:not(" + selectedDiv + ")").hide();
                                    $(selectedDiv).toggle().delay("slow");

                                }
                            </script>
                            <div class="shift-list-container"  style="margin-top: 10px;display: none" id="shift-list-container-<?= $valuebranch->id ?>">
                                <?php
                                foreach ($model_shift as $value) {
                                    $data = [
                                        "id" => $value->id,
                                        "name" => $value->shift_name,
                                        "start_time" => date("h:i A", strtotime($value->start_time)),
                                        "end_time" => date("h:i A", strtotime($value->end_time)),
                                        "color_code" => $value->color_code,
                                        "branch_id" => $valuebranch->id,
                                        "branch_name" => $valuebranch->branch_or_sponsor_name,
                                    ];
                                    $data_json = htmlentities(json_encode($data));
                                    ?>
                                    <div style="background-color: <?= $value->color_code ?>"  jdata="<?= $data_json ?>" id="shift_master_id_<?= $valuebranch->id ?>_<?= $value->id ?>"  class="master-shift" draggable="true">
                                        <i class="fa fa-dashboard"></i>&nbsp;
                                        <?php echo $value->shift_name . "  [" . date("h:i A", strtotime($value->start_time)) . " - " . date("h:i A", strtotime($value->end_time)) . "]"; ?>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <?php
                    }
                    ?>

                </div>

            </div>
        </div>


    </div>
</div>
<script>
    function getEmployeedetails(){  
     var branch_id= $('#branch_id').val();
        jQuery.ajax({
           'dataType':'json',
            'data' : {'branch_id':branch_id},
            'type':'post',
            'url': 'index.php?r=hr/roster/getbranchemployee',
            'success': function(data) {
                $('#li_emp_data').html(data.employee);
                setRosterTable();
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
        });
    }
    var empList = [];
    // on ready function
    $(document).ready(function () {
        setWeekRange();




    });
    function setRosterTable() {
        var branchID = $("#branch_id").val();
        var employeeID = $("#employee_id").val();
        var start_date = $("#start_date").val();
        var end_date = $("#end_date").val();

        /// getting days difference of start date and end date
        /// getTime-> gives in milli sec so
        if (getDateFromDisplay(start_date).getTime() > getDateFromDisplay(end_date).getTime()) {
            $("#end_date").val(start_date);
            return;
        }
        var datediff = Math.abs(getDateFromDisplay(start_date).getTime() - getDateFromDisplay(end_date).getTime()) / (60 * 1000 * 60 * 24);
        if (datediff <= MAX_DAYS) {
            var config = {
                start_date: start_date,
                end_date: end_date,
            };
            jQuery.ajax({
                dataType: 'json',
                type: 'POST',
                url: 'index.php?r=hr/roster/getEmployeeList&branch_id=' + branchID+'&employee_id=' + employeeID,
                cache: false,
                success: function (data) {
                    empList = data.data;
                    initRoster('roster-table', config, empList);
                    _prev_start_date = start_date;
                    _prev_end_date = end_date;
                    loadDatatoTable();
                },
                complete: function () {
                    $("#loader").hide();
                },
                beforeSend: function () {
                    $("#loader").show();
                }
            });
        } else {
            alert("Max date range is " + MAX_DAYS + " days.");
            $("#start_date").val(_prev_start_date);
            $("#end_date").val(_prev_end_date);
        }
    }
    function loadDatatoTable() {
        var branchID = $("#branch_id").val();
        var employeeID = $("#employee_id").val();
        var start_date = $("#start_date").val();
        var end_date = $("#end_date").val();

        /// getting days difference of start date and end date
        /// getTime-> gives in milli sec so
        if (getDateFromDisplay(start_date).getTime() > getDateFromDisplay(end_date).getTime()) {
            // $("#end_date").val(start_date);
            $("#start_date").val(_prev_start_date);
            $("#end_date").val(_prev_end_date);
            return;
        }
        jQuery.ajax({
            dataType: 'json',
            type: 'POST',
            url: 'index.php?r=hr/roster/getlist&branch_id=' + branchID + '&start_date=' + start_date + "&end_date=" + end_date+ "&employee_id=" + employeeID,
            cache: false,
            data: {branch_id: branchID},
            success: function (d) {
                var rosterList = d.data;
                for (var i = 0; i < rosterList.length; i++) {
                    var target = getTargetTDby(rosterList[i].date, rosterList[i].emp_id);
                    var data = rosterList[i];
                    var config = {
                        id: data.id,
                        shift_id: data.shift_id,
                        shift_name: data.shift_name,
                        date: data.date,
                        emp_id: data.emp_id,
                        emp_name: data.emp_name,
                        color_code: data.color_code,
                        branch_id: data.branch_id,
                        branch_name: data.branch_name,
                        start_time: data.start_time,
                        end_time: data.end_time
                    };
                    console.log(config);
                    if (target === null || target === undefined) {
                        console.log("Target not found. with " + config.date);
                    } else {
                        console.log("Yes, Target found. with " + config.date);
                        createshift(target, config);
                    }

                }
            },
        }
        );
    }

</script>