<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'roomsetting-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'building_name', array('data-label' => 'Building Name/Floor Name')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropDownList($model, 'country_id',MasCountry::getCountry(), array('data-label' => 'Country','empty'=>'Select','data-search'=>true)); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'location_name', array('data-label' => 'Location')); ?>
            </li>
            <li class="col-sm-8">
                <?php echo $form->textArea($model, 'address', array('data-label' => 'Address')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'no_rooms', array('data-label' => 'Total Rooms','onkeypress' => 'return isNumberKey(event)','onkeyup'=>'showtable(this.value);')); ?>
            </li>
        </ul>
    </div>
    <?php
    $style='display: none;';
    if($model->id>0){
        $style='display: block;';
    }
    ?>
    <div class="table-responsive" id="div_room" style="<?php echo $style; ?>">
        <table class="table table-hover table-bordered personal-task" id="rm_table">
            <tr>
                <th>No</th> 
                <th>Room Name</th>
                <th>Bed Space</th>
                <th class="text-center">
                    <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addroomdetail();"><i class="fa fa-plus"></i></a></th>
            </tr>
            <?php           
                foreach ($model_details as $i => $detail):                  
            ?>
            <tr>
                <td><label><?php echo ($i+1); ?></label></td>                  
                <td>
                    <?php  echo $form->textField($detail, "[" . $i . "]room_name", array('class'=>'go', 'title' => 'Room Name')); ?>
                    <?php echo $form->hiddenField($detail, "[" . $i . "]id"); ?>
                </td>
                <td>
                    <?php  echo $form->textField($detail, "[" . $i . "]room_bedspace", array('class'=>'go', 'title' => 'Bed Space','onkeypress' => 'return isNumberKey(event)')); ?>                           
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="roomsetting_close" data-dismiss="modal">Close</button>
<?php
$url = Yii::app()->createUrl('hr/roomsettings/Saveroomsettings');
echo CHtml::ajaxSubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        $("#loader").hide();
        if(data.status=="success"){  
            t8.success("Saved Successfully!");
            $("#roomsetting_close").click();
            reloadTable("#tbl_roomsettings_details");
        } else { 
            $("#roomsetting-form .roomsetting-save-btn").prop("disabled", false);                      
            $("#roomsetting-form .roomsetting-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
            $.each(data, function(key, val) {
                t8.error(""+val+""); 
            }); 
        } 
    }',
    'beforeSend' => 'function(){
        $(".toast8-error").hide(); 
        var table_length=$("#rm_table").find("tr:gt(0)").length; 
        var rooms=$("#RoomSetting_no_rooms").val(); 
        if(table_length==rooms){
            for(i=0;i<table_length;i++){
                var room_bedspace = $("#RoomSettingDetails_"+i+"_room_bedspace").val(); 
                if(Number(room_bedspace)==0 || room_bedspace==""){
                    var row_num=Number(i)+1;
                    jAlert("Enter Bed Space in row "+row_num,"Alert");
                    return false;
                }
            }
            $("#loader").show();
            $("#roomsetting-form .roomsetting-save-btn").prop("disabled", true);                      
            $("#roomsetting-form .roomsetting-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
            $(".toast8-error").hide(); 
        }else{
            jAlert("Enter all room details ","Alert");
            return false;
        }
    }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'roomsetting-save-btn btn btn-theme'));
?>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("showtable", "function showtable(rooms) {
    if(Number(rooms)>0){
        $('#div_room').show();
    }else{
        $('#div_room').hide();
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("addroomdetail", "function addroomdetail() {
    var rooms=$('#RoomSetting_no_rooms').val(); 
    var table_length=$('#rm_table').find('tr:gt(0)').length; 
    if(Number(rooms)!=Number(table_length)){
        addTableRow($('#rm_table'));
    }else{
        jAlert('Maximum room is '+rooms,'Alert');
    }
};", CClientScript::POS_HEAD);
?>