<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'bedspace-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo CHtml::dropDownList('building_floor_id',$model_details[0]['building_floor_id'],RoomSetting::getfloordetail(), array('data-label' => 'Building/Floor','empty'=>'Select','onchange'=>'getroomdetail(this.value);',)); ?>
            </li>
            <li class="col-sm-4" id="li_room_detail">
                <?php echo CHtml::dropDownList('room_id',$model_details[0]['room_id'],RoomSettingDetails::getroomdetails($model_details[0]['building_floor_id']), array('data-label' => 'Room Name','empty'=>'Select','onchange'=>'getroomcount(this.value);',)); ?>
            </li>
            <li class="col-sm-4" id="li_bedspace_detail">
                <?php
                if($model_details[0]['room_id']>0){
                    $model_room_sp = RoomSettingDetails::model()->findByPk($model_details[0]['room_id']);
                    echo '<span>Bed Space-'.$model_room_sp->room_bedspace.'</span>'; 
                    echo CHtml::hiddenField('bedspace_count',$model_room_sp->room_bedspace); 
                }
                ?>
            </li>
        </ul>
    </div>
    <?php
    $style='display: none;';
    if(!empty($model_details)){
        $style='display: block;';
    }
    ?>
    <div class="table-responsive" id="div_bedspace" style="<?php echo $style; ?>">
        <table class="table table-hover table-bordered personal-task" id="bedspacedetail_table">
            <tr>
                <th>No</th> 
                <th>BedSpace Name</th>
                <th class="text-center">
                    <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addbedspacedetail();"><i class="fa fa-plus"></i></a></th>
            </tr>
             <?php           
                foreach ($model_details as $i => $detail):                  
            ?>
            <tr>
                <td><label><?php echo ($i+1); ?></label></td>                  
                <td>
                    <?php echo $form->hiddenField($detail, "[" . $i . "]id"); ?>
                    <?php  echo $form->textField($detail, "[" . $i . "]bed_space_name", array('class'=>'go', 'title' => 'Bed Space Name')); ?>                           
                </td>
                <td class="text-center nw" width="1%" >
                       <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'removeTRow($(\'#bedspacedetail_table\'),this,this.id)', 'title' => 'Remove this item','id'=>'bedspacedelete_'.$i));
                    ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="bedspace_close" data-dismiss="modal">Close</button>
<?php
$url = Yii::app()->createUrl('hr/roomsettings/Savebedspacedetails');
echo CHtml::ajaxSubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        $("#loader").hide();
        if(data.status=="success"){  
            t8.success("Saved Successfully!");
            $("#bedspace_close").click();
            reloadTable("#tbl_bedspace_details");
        } else { 
            $("#bedspace-form .bedspace-save-btn").prop("disabled", false);                      
            $("#bedspace-form .bedspace-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
            $.each(data, function(key, val) {
                t8.error(""+val+""); 
            }); 
        } 
    }',
    'beforeSend' => 'function(){
        $(".toast8-error").hide(); 
        var table_length=$("#bedspacedetail_table").find("tr:gt(0)").length; 
        var rooms=$("#bedspace_count").val(); 
        if(table_length==rooms){
            for(i=0;i<table_length;i++){
                var room_bedspace = $("#RoomBedspace_"+i+"_bed_space_name").val(); 
                if(room_bedspace==""){
                    var row_num=Number(i)+1;
                    jAlert("Enter Bed Space Name in row "+row_num,"Alert");
                    return false;
                }
            }
            $("#loader").show();
            $("#bedspace-form .bedspace-save-btn").prop("disabled", true);                      
            $("#bedspace-form .bedspace-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
            $(".toast8-error").hide(); 
        }else{
            jAlert("Enter all bedspace details ","Alert");
            return false;
        }
    }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'bedspace-save-btn btn btn-theme'));
?>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("getroomdetail", " function getroomdetail(floor_id) {
    jQuery.ajax({
        'dataType':'json', 
        'type': 'post',
        'url': '" . Yii::app()->createUrl('hr/roomsettings/getroomdetail') . "',
        'data': {'floor_id':floor_id},
        'cache': false,
        'success': function(data) {
            $('#li_room_detail').html(data.roomdetail);
        }
    });

}", CClientScript::POS_HEAD);
$cs->registerScript("getroomcount", " function getroomcount(room_id) {
    jQuery.ajax({
        'dataType':'json', 
        'type': 'post',
        'url': '" . Yii::app()->createUrl('hr/roomsettings/getbedspacedetail') . "',
        'data': {'room_id':room_id},
        'cache': false,
        'success': function(data) {
            $('#li_bedspace_detail').html(data.bedspacedetail);
             $('#div_bedspace').show();
        }
    });

}", CClientScript::POS_HEAD);
$cs->registerScript("addbedspacedetail", "function addbedspacedetail() {
    var rooms=$('#bedspace_count').val(); 
    var table_length=$('#bedspacedetail_table').find('tr:gt(0)').length; 
    if(Number(rooms)!=Number(table_length)){
        addTableRow($('#bedspacedetail_table'));
    }else{
        jAlert('Maximum bedspace available is '+rooms,'Alert');
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("removeTRow", " function removeTRow(jQtable,evt,field_id) {
            var arr_fields= field_id.split('_');
            var row_field=arr_fields[1];
            var id=$('#RoomBedspace_'+row_field+'_id').val();
            formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
            var num_rows    =   jQtable.find('tr:gt(0)').length;
            if(num_rows>1){
            var tr  =   $(evt).parent().parent();
            if(isRowEmpty(tr)) {
                if(id!=''){
                    jQuery.ajax({
                        'type': 'post',
                        'dataType': 'json',
                        'url': '" . Yii::app()->createUrl('hr/roomsettings/deletebedspace') . "',
                        'data': {'id':id} ,
                        'cache': false,
                        'success': function(data) {
                            if(data.status=='success'){
                                $(evt).parents('tr').remove();
                                var i=0;
                                jQtable.find('tr:gt(0)').each(function() {
                                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                    {
                                        old_id = $(this).attr('id');
                                        if(old_id!==undefined) {
                                            new_id = old_id.replace(/\d+/,i);
                                            $(this).attr('id',new_id);
                                        }
                                        old_name = $(this).attr('name');
                                        if(old_name!==undefined) {
                                            new_name = old_name.replace(/\d+/,i);
                                            $(this).attr('name',new_name);
                                        }
                                    });
                                    $(this).find('td:first label').html(++i);
                                });
                                t8.success('Deleted');
                            }else{
                                t8.error('Deletion Not Possible, History Exist');
                            }
                        }
                    });
                }else{
                    $(evt).parents('tr').remove();
                    var i=0;
                    jQtable.find('tr:gt(0)').each(function() {
                        $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                        {
                            old_id = $(this).attr('id');
                            if(old_id!==undefined) {
                                new_id = old_id.replace(/\d+/,i);
                                $(this).attr('id',new_id);
                            }
                            old_name = $(this).attr('name');
                            if(old_name!==undefined) {
                                new_name = old_name.replace(/\d+/,i);
                                $(this).attr('name',new_name);
                            }
                        });
                        $(this).find('td:first label').html(++i);
                    });
                }
            }
        }else {
            alert('Atleast one item needed here');
        }
    }", CClientScript::POS_HEAD);
?>