<div class="popup_inner_element">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'recruitment-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
    ?>
    <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
        <li class="active"><a href="#recruit_tab1" data-toggle="tab">General</a></li> 
        <li><a href="#recruit_tab6" data-toggle="tab">Interview</a></li>
        <li><a href="#recruit_tab2" data-toggle="tab">Analysis</a></li> 
        <li><a href="#recruit_tab3" data-toggle="tab">Evaluation</a></li> 
        <li><a href="#recruit_tab7" data-toggle="tab">Offer</a></li> 
        <?php
        if ($model->offer_letter_date != '0000-00-00' && $model->offer_letter_date != '') {
        ?>
        <li><a href="#recruit_tab8" data-toggle="tab">Onboarding</a></li>
        <?php } ?>
        <li><a href="#recruit_tab4" data-toggle="tab">Documents</a></li>
        <li><a href="#recruit_tab5" data-toggle="tab" onclick="reloadTable('#tbl_recruit_notes_details');">Notes</a></li>
    </ul>
    <div class="tab-content">
        <input type="hidden" value="<?php echo date('d/m/Y');?>" id="current_date" name="current_date"/>
        <input type="hidden"  id="recruitment_id" value="<?php echo $model->id; ?>">
        <input type="hidden"  id="company_name" value="<?php echo Yii::app()->user->master_company_name; ?>">
        <div class="tab-pane active" id="recruit_tab1">
            <?php $this->renderPartial('general_details', array('model' => $model, 'form' => $form)); ?>                
        </div>
        <div class="tab-pane" id="recruit_tab6">
            <?php $this->renderPartial('recruit_interview', array('model' => $model, 'form' => $form)); ?>                
        </div>
        <div class="tab-pane" id="recruit_tab2">
            <?php $this->renderPartial('recruit_analysis', array('model' => $model,'model_analysis' => $model_analysis, 'form' => $form,'model_settings'=>$model_settings)); ?>                
        </div>
        <div class="tab-pane" id="recruit_tab3">
            <?php $this->renderPartial('recruit_evaluation', array('question_count'=>$question_count,'model' => $model, 'form' => $form,'model_settings'=>$model_settings,'model_mark' => $model_mark)); ?>                
        </div>
        <div class="tab-pane" id="recruit_tab7">
            <?php $this->renderPartial('recruit_offer_new', array('model' => $model,'model_salary' => $model_salary, 'form' => $form)); ?>                
        </div>
        <div class="tab-pane" id="recruit_tab8">
            <?php $this->renderPartial('on_board', array('model' => $model,'model_onboard_details' => $model_onboard_details,'model_onboard' => $model_onboard, 'form' => $form)); ?>                
        </div>
        <div class="tab-pane" id="recruit_tab4">
            <?php $this->renderPartial('recruit_documents', array('model' => $model, 'form' => $form,'model_documents' => $model_documents)); ?>                
        </div>
        <div class="tab-pane" id="recruit_tab5">
            <?php $this->renderPartial('recruitment_notes', array('model_note'=>$model_note ,'form' => $form, 'id' => $id)); ?>                
        </div>
    </div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="recruit_close">Close</button>
    <?php
    $url = Yii::app()->createUrl('/hr/recruitment/SaveRecruitment');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'data'=>'js:$("#recruitment-form").serialize()+"&interview_letter="+encodeURIComponent(CKEDITOR.instances.HrRecruitment_interview_letter.getData())+"&offer_letter="',
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                t8.success("Saved Successfully!");
//                $("#recruit_close").click();
                reloadTable("#tbl_employee_recruit_details");
                loadPopupModal("hr/recruitment/create&id="+data.id,"Edit Recruitment Detail","xl");
            } else { 
                $.each(data, function(key, val) {
                    t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $("#recruitment-form .recruitment-save-btn").prop("disabled", true);                      
            $("#recruitment-form .recruitment-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
            $(".toast8-error").hide(); 
        }',
        'complete' => 'function(){
            $("#loader").hide();
            $("#recruitment-form .recruitment-save-btn").prop("disabled", false);                      
            $("#recruitment-form .recruitment-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'recruitment-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable()
    {
         var id = $("#recruitment_id").val();
        var table_id ="#tbl_recruit_notes_details";
        var table = $(table_id).DataTable({
             scrollY         : "100px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
             
            ajax: {
                url: "' . Yii::app()->createUrl('hr/recruitment/getNotesList') . '",
                   
                 data:{"id":id},
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        });
        $(".dataTables_scrollFoot").hide();
    }	
		
    $(document).ready(function() {  
        filterDataTable();
        interviewmindate();
        var editor = CKEDITOR.instances["HrRecruitment_interview_letter"];
        if (editor) { editor.destroy(true); }
        CKEDITOR.replace("HrRecruitment_interview_letter",
        {
             filebrowserImageUploadUrl: "js/ckeditor/filemanager/connectors/php/upload.php?Type=Image",
        });
        
    });', CClientScript::POS_HEAD);
$cs->registerScript("calculateage", "function interviewmindate() {  
        var current_date = $('#current_date').val().split('/'); 
        var min_date = current_date[2]+'/'+ current_date[1]+'/'+current_date[0]; 
        $('#HrRecruitment_interview_date').datetimepicker({format: 'DD/MM/YYYY HH:mm',minDate : min_date});
};", CClientScript::POS_HEAD);
$cs->registerScript("interviewdate", "
    $('#HrRecruitment_interview_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.hide', function (e) {
        var interview_date=$('#HrRecruitment_interview_date').val(); 
        var position=$('#HrRecruitment_post_applied').val(); 
        var company_name=$('#company_name').val(); 
        var candidate=$('#HrRecruitment_first_name').val()+' '+$('#HrRecruitment_middle_name').val()+' '+$('#HrRecruitment_last_name').val();
        var first_name=$('#HrRecruitment_first_name').val()
        if(first_name==''){
            candidate='Applicant';
        }
        if(interview_date!=''){
            $('#li_letter').show(); 
            CKEDITOR.instances['HrRecruitment_interview_letter'].setData('<b>Subject:</b> Invitation to Interview<br/><br/> Dear '+candidate+', <br/><br/>Thank you for applying for the position of '+position+' with '+company_name+'.<br/><br/>We would like to invite you to come to our office to interview for the position.Your interview has been scheduled for '+interview_date+'.<br/><br/>Please call me at <span style=color:red>[Mobile No]</span> or email me at <span style=color:red>[Email ID]</span>,if you have any questions or need to reschedule.<br/><br/><br/>Sincerely,<br/><br/><span style=color:red>[HR Department]</span>');
        }else{
            $('#li_letter').hide(); 
        }
    });", CClientScript::POS_HEAD);
/*$cs->registerScript("offerletterdate", "
    $('#HrRecruitment_offer_letter_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.hide', function (e) {
        var offer_letter_date=$('#HrRecruitment_offer_letter_date').val(); 
        var candidate=$('#HrRecruitment_first_name').val()+' '+$('#HrRecruitment_middle_name').val()+' '+$('#HrRecruitment_last_name').val(); 
        var first_name=$('#HrRecruitment_first_name').val()
        if(first_name==''){
            candidate='Applicant';
        }
        var position=$('#HrRecruitment_post_applied').val(); 
        var company_name=$('#company_name').val(); 
        if(offer_letter_date!=''){
            $('#li_offer').show(); 
            CKEDITOR.instances['HrRecruitment_offer_letter'].setData(
            '<b>Dear '+candidate+', <br/><br/> We are pleased to offer you appointment in '+company_name+' and its related group of Companies in the capacity of <span style=color:red>[Designation]</span><br>The terms and conditions are attached to this a letter. Please note that your employment is subject to the following conditions:<br> a)	You are medically assessed for the position under offer.<br>b)	Submission of all attested certificates and testimonials in support of educational qualifications and experience. <br>c)	Submission of your reference letters from two of the last previous employer including their contact details. <br>d)	If employment visa is rejected by the immigration authority or labour department due to health, lack of previous work clearance, all expense incurred shall be payable by you.<br>    e)	Submission of your cancellation copy/ visit and/or tourist visa page along with other visa related documentation within ten (10) days of employment. – If Applicable<br>f)	The candidate must take note of below:<br> a.	Until visa processing and stamping is done no salary will be paid by the company. Once the visa is issued, then the actual payroll will start. During this period, an amount of AED 800/- will be paid as a commission towards each card booked and activated.<br>    b.	Amount of AED 620/- will be deducted towards visa status change. This amount shall be deducted on the payroll month.<br> c.	Any overstay fines will be borne by the employee.<br>    d.	<br>We look forward to a long and mutually beneficial association.<br>Yours sincerely,'+' ');
        }else{
            $('#li_offer').hide(); 
        }
    });", CClientScript::POS_HEAD);*/
?>






