<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable(status)
    {
        var table_id ="#tbl_product_history_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,         
            searching: false,
           // bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/productpurchase/GetList') . '",
                type: "POST",
                "data" : {
                    "status":status               
                },
                cache : false,
            },
            columns: [
                {className:"text-center"},
                {className:"text-center"},
                {className:"text-center"},
                {className:"text-right"},
                {className:"text-center"},
            ],
            order: [[ 1, "asc" ]],	
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
            
        });
        $(".dataTables_scrollFoot").hide();
    }		
    $(document).ready(function() {  	 		
        var status = $("#purchase_status").val();
        filterDataTable(status);
    });', CClientScript::POS_HEAD);
$cs->registerScript('purchasehistorydetails', 'function purchasehistorydetails(){  
        $("#tbl_product_history_details").DataTable().destroy();
        var status = $("#purchase_status").val();
        filterDataTable(status); 
};', CClientScript::POS_HEAD);
$cs->registerScript("deletepurchase", "function deletepurchase(id){
    var r = confirm('Are you sure to delete this purchase?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType'  : 'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/productpurchase/deletepurchase',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#tbl_product_history_details');
                    t8.success('Deleted Successfully!');
                }else {
                   t8.error('Error');
                }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) { 
           let items = {};
           if (datas[5].edit_button !== 0) {
               items.edit = {
                   name: "Edit",
                   icon: "fa-edit",
                   callback: function () {
                       loadPopupModal("hr/productpurchase/request&id="+datas[5].id, 'Edit Purchase Request', "lg");
               }
               };
            }
            if (datas[5].delete_button !== 0) {
               items.delete = {
                   name: "Delete",
                   icon: "fa-trash-o",
                   callback: function () {
                       deletepurchase(datas[5].id);
               }
               };
            }
            if (datas[5].view_button !== 0) {
               items.view = {
                   name: "View",
                   icon: "fa-eye",
                   callback: function () {
                       loadPopupModal("hr/productpurchase/viewrequest&id="+datas[5].id, 'View Purchase Request', "lg");
               }
               };
            }
          if (Object.keys(items).length > 0) {
              $(row).contextMenu({
                  selector: 'td',
                  items: items
              });
          }
      }

</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-shopping-basket"></i>  -->
        Purchase History
        <div class="pull-right" style="display: flex; margin-bottom: -15px">
            <a class="ad-btn"  onclick="loadPopupModal('hr/productpurchase/request', 'Add New Purchase Request', 'lg')" style="height: 30px" title="Purchase Request"title='Add'>
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>         
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_product_history_details" style="width: 100%;font-size:12px; height: auto">
                <thead>
                    <tr>
                        <th class="text-center">No</th>
                        <th class="text-center">Apply Date</th>
                        <th class="text-center">Payment Mode</th>
                        <th class="text-center">Total Amount</th>
                        <th class="text-center">Status</th>
                    </tr>
                </thead>
                </tfoot>
            </table>
        </div>
    </div>
</section>
