<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable(status)
    {
        var table_id ="#tbl_purchase_approval_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,           
           // bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/productpurchase/GetApprovalList') . '",
                type: "POST",
                cache : false,
            },
            columns: [
                {className:"text-center"},
                {className:"text-center"},
                {className:"text-center"},
                {className:"text-center"},
                {className:"text-right"},
                {className:"text-center"},
            ],
            order: [[ 1, "asc" ]],	
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
            
        });
        $(".dataTables_scrollFoot").hide();
    }		
    $(document).ready(function() {  	 
        filterDataTable();
    });', CClientScript::POS_HEAD);
$cs->registerScript('purchasehistorydetails', 'function purchasehistorydetails(){  
        $("#tbl_purchase_approval_details").DataTable().destroy();
        filterDataTable(); 
};', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) { 
           let items = {};
           if (datas[6].approve_reject !== 0) {
               items.approve = {
                   name: "Approve",
                   icon: "fa-thumbs-up",
                   callback: function () {
                        loadPopupModal("hr/productpurchase/requestintermediateapproval&final_level="+datas[6].final_level+'&level='+datas[6].level_no+'&id='+ datas[6].id, 'Approve/Reject Purchase Request', "lg");
               }
               };
            }
            if (datas[5].view_button !== 0) {
               items.view = {
                   name: "View",
                   icon: "fa-eye",
                   callback: function () {
                       loadPopupModal("hr/productpurchase/viewrequest&id="+datas[6].id, 'View Purchase Request', "lg");
               }
               };
            }
          if (Object.keys(items).length > 0) {
              $(row).contextMenu({
                  selector: 'td',
                  items: items
              });
          }
      }

</script>

<section class="panel">
    <header class="panel-heading clearfix panel-theame">
       Purchase Approval
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_purchase_approval_details" style="width: 100%;font-size:12px; height: auto">
                <thead>
                    <tr>
                        <th class="text-center">No</th>
                        <th class="text-center">Apply Date</th>
                        <th class="text-center">Employee Name</th> 
                        <th class="text-center">Payment Mode</th>
                        <th class="text-center">Total Amount</th>
                        <th class="text-center">Status</th>
                    </tr>
                </thead>
                </tfoot>
            </table>
        </div>
    </div>
</section>
