<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'mas-pension-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'scheme_name', array('data-label' => 'Scheme Name <span style="color : red;"> * </span>')); ?>
                <?php echo $form->error($model, 'scheme_name'); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'company_percent', array('data-label' => 'Company Percent <span style="color : red;"> * </span>', 'onkeypress' => 'return isNumberKey(event)')); ?>
                <?php echo $form->error($model, 'company_percent'); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'employee_percent', array('data-label' => 'Employee Percent <span style="color : red;"> * </span>', 'onkeypress' => 'return isNumberKey(event)')); ?>
                <?php echo $form->error($model, 'employee_percent'); ?>
            </li>
            <li class="col-sm-6"> 
                    <?php
                        $arr_salarytype  =  array();
                       
                        if(!empty($model->salary_type)){
                            $salarytype      = explode(",", $model->salary_type);
                            foreach ($salarytype as $eachValue){
                            $arr_salarytype[$eachValue] = array('selected' => 'selected');
                        } 
                        }
                         
                    ?>
                                   
                    <?php echo $form->dropDownList($model, 'salary_type',MasSalarytype::getSalarytypefixed(), array('options' => $arr_salarytype,'data-label'=>'Salary Type <span style="color : red;"> * </span>','empty'=>'Select','class' => 'tooltipster multiselect', 'multiple' => true)); ?>
                    <?php echo $form->error($model, 'salary_type'); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="pension_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/pensionsettings/SavePensionSetting');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data)
            {
                $("#loader").hide();
                if(data.status=="success"){  
                    t8.success("Saved Successfully!");
                    $("#pension_close").click();
                    reloadTable("#tbl_pension_settings_details");
                } else { 
                    $("#mas-pension-form .pension-save-btn").prop("disabled", false);
                    $("#mas-pension-form .pension-save-btn").addClass("btn-theme").removeClass("btn_loding");
                    $.each(data, function(key, val) {
                            $("#mas-pension-form #"+key+"_em_").text(val).show(); 
                            t8.error(""+val+""); 
                    }); 
                } 
        }',
        'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#mas-pension-form .pension-save-btn").prop("disabled", true);
                                $("#mas-pension-form .pension-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'pension-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>










