<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadnotification", '
    function filterDataTable() {
        var table_id ="#tbl_c_notification";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/notification/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
	  $(document).ready(function() {  	
  	  		
      filterDataTable();
    })
	
', CClientScript::POS_HEAD);
$cs->registerScript("deletenotification", "function deletenotification(id){
    var r = confirm('Are you sure want to delete?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType'  : 'json',
              'data'  : 'id='+id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/notification/Deletenotification',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    t8.success('Deleted');
                    reloadTable('#tbl_c_notification'); 
                }else {
                    t8.error('Error in Deletion');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) { 
        let items = {};
        if (datas[4].edit_button !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/notification/create&id="+datas[4].id, "Edit Notification ", "lg");
                }
            };
        }
        if (datas[4].delete_button !== 0) {
            items.Delete = {
                name: "Delete",
                icon: "fa-trash-o",
                callback: function () {
                     deletenotification(datas[4].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            Notification
            <div class="pull-right">	
                <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_notification_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn"  onclick="loadPopupModal('hr/notification/create','Add Notification','lg')",title="Add">                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_c_notification" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>  
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                   
                </table>
            </div>
        </div>
    </section>
