<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'hr_module_settings-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<section class="panel">
    <div class="panel-body">
        <div class="col-sm-12">
            <!--<div class="col-12 text-bold text-center" style="font-size: 25px">GENERAL SETTINGS</div>-->
            <div class="personal_dett clearfix form-ul material">
                <div class="title text-center text-bold">YOUR CURRENT PACKAGE - <?= strtoupper($model->packagedetail->package_name); ?></div>
            </div>
            <div class="tab-content">
                <div class="tab-pane active">
                    <ul class="clearfix form-ul material">
                        <li class="col-sm-2">              
                            <?php echo $form->hiddenField($model, 'id'); ?> 
                            <?php echo $form->hiddenField($model, 'old_package_id',['value'=>$model->package_id]); ?> 
                            <?php echo $form->dropDownList($model, 'package_id', HrSoftwarePackage::getpackagename(), array('data-label' => 'Package Name<span style="color:red">*</span>')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'general_calendar', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'General Calendar')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'hrcalendar', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'HR Calendar')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'use_hr_code_increment_employee_code', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'HR Code in EMP')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'auto_increment_employee_code', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'Auto Inc Emp')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'employee_document_upload', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'ESS Document Upload', 'prompt' => 'Select')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'calculate_overtime', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'OT From Attendance', 'prompt' => 'Select')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'start_time_normal_ot', array('C' => 'Company Time', 'P' => 'Punch Time'), array('data-label' => 'Normal OT Start')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'start_time_weekend_ot', array('C' => 'Company Time', 'P' => 'Punch Time'), array('data-label' => 'Weekend OT Start')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'start_time_night_ot', array('C' => 'Company Time', 'P' => 'Punch Time'), array('data-label' => 'Night OT Start')); ?>
                        </li>
                         <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'start_time_holiday_ot', array('C' => 'Company Time', 'P' => 'Punch Time'), array('data-label' => 'Holiday OT Start')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'consider_threshold_salary', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'Threshold Salary')); ?>
                        </li>
                        <li class="col-sm-2">        
                            <?php echo $form->dropDownList($model, 'enable_mail', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'Mail')); ?>
                        </li>
                        <li class="col-sm-3">                
                            <?php echo $form->textField($model, 'from_mail_id', array('data-label' => 'From Mail ID')); ?>
                        </li>
                        <li class="col-sm-3">                
                            <?php echo $form->textField($model, 'from_mail_name', array('data-label' => 'From Mail Name')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'enable_sms', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'SMS')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->dropDownList($model, 'consider_advance_leave', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'Include Advance Leave')); ?>
                        </li>
                        <li class="col-sm-3"> 
                            <?php echo $form->dropDownList($model, 'pending_leave_view',Employee::getEmployee(), array('data-label' => 'Applied Leave View in Employee Portal','title'=>'Applied Leave View in Employee Portal','multiple'=>true,'datat-search'=>true)); ?>
                        </li>
                        <li class="col-sm-3">                
                            <?php echo $form->dropDownList($model, 'lock_attendance_leave', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'Lock Attendance & Leave after Salary Cal')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->textField($model, 'app_version', array('data-label' => 'App Version')); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php echo $form->textField($model, 'review_app_version', array('data-label' => 'Review App Version')); ?>
                        </li>
                        <li class="col-sm-2">        
                            <?php echo $form->dropDownList($model, 'app_force_update', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'App Force Update')); ?>
                        </li>
                        <li class="col-sm-3">                
                            <?php echo $form->textField($model, 'app_android_link', array('data-label' => 'App Android Link')); ?>
                        </li>
                        <li class="col-sm-3">                
                            <?php echo $form->textField($model, 'app_ios_link', array('data-label' => 'App IOS Link')); ?>
                        </li>
                        <li class="col-sm-2">        
                            <?php 
                            echo CHtml::hiddenField("max_admin_users_allowed", $user_count);
                            echo $form->numberField($model, 'max_admin_users_allowed', array('data-label' => 'Admin Users Allowed','min' => $model->max_admin_users_allowed)); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php 
                            echo $form->hiddenField($model_company, 'id');
                            echo CHtml::hiddenField("total_branches_allowed", $branch_count);
                            echo $form->numberField($model_company, 'total_branches_allowed', array('data-label' => 'Branches Allowed','min' => $model_company->total_branches_allowed)); ?>
                        </li>
                        <li class="col-sm-2">                
                            <?php 
                            echo CHtml::hiddenField("total_employees_allowed", $employee_count);
                            echo $form->numberField($model_company, 'total_employees_allowed', array('data-label' => 'Employees Count','min' => $model_company->total_employees_allowed)); ?>
                        </li>
                        
                        <li class="col-sm-12">
                            <div class="title text-center"> App Update Details</div>
<!--                            <label for="app_notes">App Update Details</label>-->
                            <?php echo $form->textArea($model, 'app_update_details', array( 'title' => 'App Update details ','data-label' => 'App Update details', 'class' => 'ckeditor go', 'id' => 'app_notes')); ?>
                        </li>
                    </ul>
                    <button type="button" class="btn btn-success pull-right" onclick="savesettings(1)">Save Settings & Package Details</button>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("savesettings", "function savesettings(frm) {
    $('.toast8-error').hide(); 
    var ckeditorContent = CKEDITOR.instances.app_notes.getData();
    var formData = $('#hr_module_settings-form').serialize() + '&HrGenerelSettings[app_update_details]=' + encodeURIComponent(ckeditorContent);
   jQuery.ajax({
      'dataType':'json',
      'data' : formData,
      'type':'post',
      'url': '" . Yii::app()->createUrl('hr/mastersettings/savesettings') . "',
      'cache': false,
      'success': function(data) {
            if(data.status=='success'){
                if(frm==1){
                    t8.success('Details Saved Successfully!');
                    location.reload();
                }
            }else{
                t8.error('Error');
            }
        },
        'beforeSend':function(){
            var exist_max_admin_users_allowed=$('#max_admin_users_allowed').val();
            var exist_total_branches_allowed=$('#total_branches_allowed').val();
            var exist_total_employees_allowed=$('#total_employees_allowed').val();
            var new_max_admin_users_allowed=$('#HrGenerelSettings_max_admin_users_allowed').val();
            var new_total_branches_allowed=$('#MasCompany_total_branches_allowed').val();
            var new_total_employees_allowed=$('#MasCompany_total_employees_allowed').val();
            if(parseInt(new_max_admin_users_allowed)<parseInt(exist_max_admin_users_allowed)){
                t8.error('Admin Users count must be greater than or equal to '+exist_max_admin_users_allowed);
                return false;
            }
            if(parseInt(new_total_branches_allowed)<parseInt(exist_total_branches_allowed)){
                t8.error('Branch count must be greater than or equal to '+exist_total_branches_allowed);
                return false;
            }
            if(parseInt(new_total_employees_allowed)<parseInt(exist_total_employees_allowed)){
                t8.error('Employee count must be greater than or equal to '+exist_total_employees_allowed);
                return false;
            }
            $('#loader').show();        
        },
        'complete':function(){
            $('#loader').hide();                                                                
        }
    });
};", CClientScript::POS_HEAD);
?>