<script>
    $(document).ready(function () {
        var table_id = "#tbl_teamname_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            "order": [[1, "asc"]],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('hr/masteamname/GetList') ?>",
                type: "POST",
                cache: false
            },
            serverSide: true,
            fixedColumns: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
                if (aData[2].status == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
            }
        });
    });

   function AddContextMenu(row, datas) {
        let items = {};
        if (datas[2].edit_button !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/masteamname/create&id=" + datas[2].id, datas[2].code, "lg");
                }
            };
        }
        if (datas[2].disable_button !== 0) {
            items.block = {
                name: (datas[2].status== "Y") ? "Disable" : "Enable",
                icon: (datas[2].status == "Y") ? "fa-toggle-off" : "fa-toggle-on",
                callback: function () {
                       Disable(datas[2].id, datas[2].status);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }

</script>
<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true)
        {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=hr/masteamname/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_teamname_details').DataTable().ajax.reload()
                        t8.success(' Success!');
                    }
                }
            });
        }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
         Team Name  
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_teamname_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <!-- <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/masteamname/create', 'Add New Team Name', 'lg')"><i class="fa fa-plus"></i></button> -->

                 <a class="ad-btn"  onclick="loadPopupModal('hr/masteamname/create','Add New Team Name','lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>


            <?php } ?></div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_teamname_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Sl No</th>
                        <th>Team Name</th>
                       
                    </tr>
                </thead>

            </table>
        </div>
    </div>
</section>
