<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("loadBank", '
        $(document).ready(function() {

        var table_id ="#tbl_projectwork_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
                        "order": [[ 1, "asc" ]],
            ajax: {
                url: "' . Yii::app()->createUrl('hr/masprojectwork/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
             "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            
              if ( aData[3].status == "N" )  {  
                    $("td", nRow).addClass("bg-danger");
                }      
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
                var mas_edit = 0;
        var mas_disable = 0;
<?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_depatmnt_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit = 1;
<?php } ?>
<?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_depatmnt_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable = 1;
<?php } ?>
        $(row).contextMenu({
            selector: 'td',
            items: {
                "edit": {
                    name: "Edit",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("hr/masprojectwork/create&id=" + datas[3].id, datas[1], "lg");
                    },
                    disabled: function(key, opt) { 
                        // this references the trigger element
                        if(mas_edit=='0'){
                            return !this.data('editDisabled'); 
                        }
                    }
                },
                "Disable_Enable": {
                    name: (datas[3].status == "Y") ? "Disable" : "Enable",
                    icon: "edit",
                    accesskey: "d",
                    callback: function () {
                        Disable(datas[3].id, datas[3].status);
                    },
                    disabled: function(key, opt) { 
                            // this references the trigger element
                            if(mas_disable=='0'){
                                return !this.data('Disable_EnableDisabled'); 
                            }
                    }
                }
            }
        });
    }
</script>
<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true)
        {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=hr/masprojectwork/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_projectwork_details').DataTable().ajax.reload()
                        t8.success('Disabled/Enabled SuccessFully!');
                    }
                }
            });
        }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-tasks"></i> Project Work
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_depatmnt_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/masprojectwork/create', 'Add New Project Work', 'lg')"><i class="fa fa-plus"></i> ADD</button>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_projectwork_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Project Code</th>
                        <th>Project Code</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
