<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'project-work-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>

<div class="tab-content">

    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <input type="hidden" name="from" id="from" value="<?php echo $from; ?>">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'project_code', array('data-label' => 'Project Code <span style="color:red">*</span>', 'data-validation' => 'required')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'project_name', array('data-label' => 'Project Name <span style="color:red">*</span>')); ?>
            </li>
           
        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="projectwork_close" data-dismiss="modal">Close</button>

<?php
$url = Yii::app()->createUrl('/hr/masprojectwork/SaveProjectWork');

echo CHtml::ajaxSubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        $("#loader").hide();
        if(data.status=="success"){  
            t8.success("Saved Successfully!");
            $("#projectwork_close").click();
            reloadTable("#tbl_projectwork_details");
        } else { 
            $("#project-work-form .project-work-save-btn").prop("disabled", false);                      
            $("#project-work-form .project-work-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
            $.each(data, function(key, val) {
                t8.error(""+val+""); 
            }); 
        } 
    }',
    'beforeSend' => 'function(){
        $("#loader").show();
        $("#project-work-form .project-work-save-btn").prop("disabled", true);                      
        $("#project-work-form .project-work-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
        $(".toast8-error").hide(); 
    }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'project-work-save-btn btn btn-theme'));
?>
</div>
    <?php $this->endWidget(); ?>