<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadGratuity", '
        $(document).ready(function() {

        var table_id ="#tbl_masgratuity_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/masgratuity/GetGratuityList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
             "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            
              if ( aData[2].status == "N" )  {  
                    $("td", nRow).addClass("bg-danger");
                }      
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>

<script>
  
     function AddContextMenu(row, datas) { 
            let items = {};
            if (datas[2].edit_button !== 0) {
                items.edit = {
                    name: "Edit",
                    icon: "fa-edit",
                    callback: function () {
                        loadPopupModal("hr/masgratuity/create&rtype=" + datas[2].rtype, datas[1], "xl");
                    }
                };
            }
            if (datas[2].disable_button !== 0) {
                items.Disable_Enable = {
                    name: "Delete",
                    icon: "fa-trash",
                    callback: function () {
                      Disable(datas[2].ctype, datas[2].rtype);
                    }
                };
            }
            if (datas[2].view_button !== 0) {
                items.view = {
                    name: "view",
                    icon: "fa-eye",
                    callback: function () {
                      loadPopupModal("hr/masgratuity/view&rtype=" + datas[2].rtype, datas[1], "xl");
                    }
                };
            }
            if (Object.keys(items).length > 0) {
                $(row).contextMenu({
                    selector: 'td',
                    items: items
                });
            }
        }

</script>
<script>
    function Disable(ctype, rtype) {
        var r = confirm('Are you sure to delete this?');
        if (r == true)
        {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'ctype=' + ctype + "&rtype=" + rtype,
                'url': $('#liveSite').val() + 'index.php?r=hr/masgratuity/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_masgratuity_details').DataTable().ajax.reload()
                        t8.success(' Success!');
                    }
                }
            });
        }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        Gratuity
        <div class="pull-right">
            <a href="https://u.ae/en/information-and-services/jobs/end-of-service-benefits-for-employees-in-the-private-sector" class="btn btn-sm btn-theme" target="_blank"><i class="fa fa-registered"></i> RULE</a>
            <a href="https://dda.gov.ae/en/gratuity-calculator/" class="btn btn-sm btn-theme" target="_blank"><i class="fa fa-calculator"></i> CALCULATOR</a>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_eos_gratuity_add']) || Yii::app()->user->authorised_user == 1) { ?>
                        <!--<button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/masgratuity/create','Add Gratuity','xl')"><i class="fa fa-plus"></i> ADD</button>-->
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_masgratuity_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Rule Type</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
