<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'masgratuity-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo CHtml::dropDownList('contract_type',$model[0]->contract_type,HrMasJobContract::getContract(), array('data-label' => 'Contract Type<span style="color : red;">*</span>')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::dropDownList('releaving_type',$model[0]->releaving_type,array('1'=>'Termination','2'=>'Resignation'), array('data-label' => 'Releaving Type','empty'=>'Select')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="gratuity_item_table">
        <tr>
            <th>No</th> 
            <th>Type</th>
            <th>Salary Type</th>
            <th>Period From</th>
            <th>Period To</th> 
            <th>Gratuity Provision Days</th>
            <th class="text-center">
                <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRowDoc($('#gratuity_item_table'));"><i class="fa fa-plus"></i></a></th>
        </tr>
        <?php           
            foreach ($model as $i => $detail):                   
        ?>
        <tr>
            <td><label><?php echo ($i+1); ?></label></td> 
            <td>
                <?php echo $form->hiddenField($detail, "[" . $i . "]id"); ?>
                <?php echo $form->hiddenField($detail, "[" . $i . "]salary_type",array('value'=>1)); ?>
                <?php echo $form->hiddenField($detail, "[" . $i . "]pay_cal",  array('value'=>2)); ?>
                <?php echo $form->hiddenField($detail, "[" . $i . "]max_year",  array('value'=>2)); ?>
                <?php  echo $form->textField($detail, "[" . $i . "]gratuity_type",array('class'=>'tooltipster go', 'placeholder' => 'Type *', 'title' => 'Type *')); ?>                           
            </td>
            <td>
                <?php  echo $form->textField($detail, "[" . $i . "]salary_type_name",array('class'=>'tooltipster go', 'placeholder' => 'Salary Type *', 'title' => 'Salary Type *','readonly'=>true,'value'=>'Basic')); ?>                           
            </td>
            <td>
                <?php echo $form->dropdownlist($detail, "[" . $i . "]gratuity_period_from",MasGratuity::listYears(0,30),array('class'=>'form-control','placeholder'=>'Period From *')); ?>                          
            </td>
            <td>
                <?php echo $form->dropdownlist($detail, "[" . $i . "]gratuity_period_to",MasGratuity::listYears(0,30),array('class'=>'form-control','placeholder'=>'Period To *')); ?>                         
            </td>
            <td>
                <?php echo $form->textField($detail, "[" . $i . "]gratuity_provision_days",array('class'=>'tooltipster go','placeholder'=>'Gratuity Provision Days *')); ?>                       
            </td>
            <td class="text-center nw" width="1%">
               <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','id'=>$i,'onclick' => 'removeitemRow($(\'#gratuity_item_table\'),this,this.id)
                                   ', 'title' => 'Remove this item')); ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="masgratuity_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/masgratuity/saveGratuity');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                 t8.success("Details Saved Successfully!");
                 $("#masgratuity_close").click();
                reloadTable("#tbl_masgratuity_details");

            } else { 
                $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            var contract_type=$("#contract_type").val();
            var releaving_type=$("#releaving_type").val();
            if(parseFloat(contract_type)==2 && releaving_type==""){
                t8.error("Select Releaving Type");
                return false;
            }else{
                $("#loader").show();
                $(".toast8-error").hide(); 
                $("#masgratuity-form .masgratuity-save-btn").prop("disabled", true);
                $("#masgratuity-form .masgratuity-save-btn").addClass("btn_loding").removeClass("btn-theme");
                return true;
            }
        }',
        'complete' => 'function(){
            $("#loader").hide();
            $("#masgratuity-form .masgratuity-save-btn").prop("disabled", false);
            $("#masgratuity-form .masgratuity-save-btn").addClass("btn-theme").removeClass("btn_loding");
        }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'masgratuity-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript("addTableRowDoc", "function addTableRowDoc(jQtable) {
    var newrow= jQtable.find('tr:last').clone();
    var lastId = jQtable.find('tr:last td>input').attr('id');
    var thenum = lastId.match(/\d+/g);
    var newId = Number(thenum) + 1;
    var newrow= jQtable.find('tr:last').clone();
    newrow.find('label').html(newId+1);
    newrow.find('.hasDatepicker').removeClass('hasDatepicker');
    newrow.find('.datetimepicker').siblings().remove();
    newrow.find('.datetimepicker').datetimepicker( 'destroy' );
    newrow.find('a,input,textarea,label,checkbox,select,div,.errorMessage').each(function() { 
                    this.id= this.id.replace(/\d+/,newId); 
                   if(!$(this).is(':checkbox'))
                        this.value  = ''; 
                    else
                        $(this).prop('checked', false);
                    (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : '';
    });
    jQtable.append(newrow);
    $('#MasGratuity_'+newId+'_salary_type').val(1);
    $('#MasGratuity_'+newId+'_pay_cal').val(2);
    $('#MasGratuity_'+newId+'_max_year').val(20);
    $('#MasGratuity_'+newId+'_salary_type_name').val('Basic');
  }", CClientScript::POS_HEAD);
$cs->registerScript("removeitemRow", "function removeitemRow(jQtable,evt,field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var id=$('#MasGratuity_'+arr_fields+'_id').val();
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var num_rows    =   jQtable.find('tr:gt(0)').length;
    if(num_rows>1){
        var tr  =   $(evt).parent().parent();
        if(isRowEmpty(tr)) {
            if(id!=''){
                jQuery.ajax({
                    'type': 'post',
                    'dataType': 'json',
                    'url': '" . Yii::app()->createUrl('hr/masgratuity/deletelevel') . "',
                    'data': {'id':id}  ,
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            $(evt).parents('tr').remove();
                            var i=0;
                            jQtable.find('tr:gt(0)').each(function() {
                                $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                {
                                    old_id   =   $(this).attr('id');
                                    if(old_id!==undefined) {
                                        new_id   =   old_id.replace(/\d+/,i);
                                        $(this).attr('id',new_id);
                                    }
                                    old_name =   $(this).attr('name');
                                    if(old_name!==undefined) {
                                        new_name =   old_name.replace(/\d+/,i);
                                        $(this).attr('name',new_name);
                                    }
                                });
                                $(this).find('td:first label').html(++i);
                            });
                            t8.success('Deleted');
                            reloadTable('#tbl_masgratuity_details');
                        }else{
                            t8.error('Deletion Not Possible, History Exist');
                        }
                    }
                });
            }else{
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() {
                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        if(old_id!==undefined) {
                            new_id   =   old_id.replace(/\d+/,i);
                            $(this).attr('id',new_id);
                        }
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        }
                    });
                    $(this).find('td:first label').html(++i);
                });
            }
        }
    }else {
        alert('Atleast one item needed here');
    }
};", CClientScript::POS_HEAD);










