<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable()
    {
        var table_id ="#tbl_masbusinessunit_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,           
           // bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/masbusinessunit/GetList') . '",
                type: "POST",
                cache : false,
            },
            columns: [
                {className:"nw sl col-max-1 text-center"},
                {className:"nw sl col-max-5 "},
                {className:"nw sl col-max-5 "},
                {className:"nw sl col-max-1"},
            ],
            order: [[ 2, "asc" ]],	
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            
        });
        $(".dataTables_scrollFoot").hide();
    }		
    $(document).ready(function() {  	 	
        filterDataTable();
    });', CClientScript::POS_HEAD);
$cs->registerScript('itemdetails', 'function itemdetails(){  
        $("#tbl_masbusinessunit_details").DataTable().destroy();
        filterDataTable(); 
};', CClientScript::POS_HEAD);
$cs->registerScript("blockunit", "function blockunit(id,frm){
    var frm_form='';
    if(frm==1){
        frm_form='Block';
    }else if(frm==2){
        frm_form='Unblock';
    }
    var r = confirm('Are you sure to '+frm_form+' this business unit?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType'  : 'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/masbusinessunit/blockunit',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#tbl_masbusinessunit_details');
                    t8.success('Updated Successfully!');
                }else {
                   t8.error('Error');
                }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-building"></i> Business Unit
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_business_add']) || Yii::app()->user->authorised_user == 1) { ?>
            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/masbusinessunit/create', 'Add Business Unit', 'lg')"><i class="fa fa-plus"></i></button>  &nbsp;
            <?php } 
            ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_masbusinessunit_details" style="font-size:13px;width: 100%;">
                <thead>
                    <tr>
                        <th class="text-center">No</th>
                        <th class="text-center">Business Unit</th>
                        <th class="text-center">Document Name</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                </tfoot>
            </table>
        </div>
    </div>
</section>
