<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'businessunit-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'business_unit_name', array('data-label' => 'Business Unit Name <span style="color:red;">*</span>')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo $form->textField($model, 'document_name', array('data-label' => 'Document Name <span style="color:red;">*</span>')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="businessunit_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/masbusinessunit/SaveUnit');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                 t8.success("Details Saved Successfully!");
                 $("#businessunit_close").click();
                reloadTable("#tbl_masbusinessunit_details");
            } else { 

                $.each(data, function(key, val) {
                    t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $(".toast8-error").hide(); 
            $("#businessunit-form .businessunit-save-btn").prop("disabled", true);
            $("#businessunit-form .businessunit-save-btn").addClass("btn_loding").removeClass("btn-theme");
        }',
        'complete'=>'function(data) {
            $("#businessunit-form .businessunit-save-btn").prop("disabled", false);
            $("#businessunit-form .businessunit-save-btn").addClass("btn-theme").removeClass("btn_loding");
            $("#loader").hide();
        }',
    ), array('id' => 'mybtn' . rand(), 'class' => 'businessunit-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>










