<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadData", 'function filterDataTable(type) {
        var table_id ="#tbl_mail_settings";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            aoColumnDefs: [
              { "bSortable": false, "aTargets": [ 7 ] },
            ],
            ajax: {
                url: "' . Yii::app()->createUrl('hr/mail/GetList') . '",
                type: "POST",
                "data" : {
                    "type" : type                  
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	  
        var type = $("#functionality_type").val();		
      filterDataTable(type);
       materializing(".material");
    })	
', CClientScript::POS_HEAD);
$cs->registerScript("loadlist", "function loadlist(){  
    $('#tbl_mail_settings').DataTable().destroy();
        var type       = $('#functionality_type').val();
        filterDataTable(type);
   
};", CClientScript::POS_HEAD);
$cs->registerScript("disablemail",  "function disablemail(id){
    var type=1;
    var r = confirm('Disable mail?');
    if(r==true)
    {
        jQuery.ajax({
          'type'  : 'post',
          'data'  : 'id=' + id+'&type=' + type,
          'url'  : $('#liveSite').val()+'index.php?r=hr/mail/changestatus',
          'cache': false,
          'success':function(data){
            if(data=='fail'){
                t8.error('Error');
            }else {                   
                reloadTable('#tbl_mail_settings');
                t8.success('Mail Blocked!');
            }
           }
        });
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("enablemail",  "function enablemail(id){
    var type=2;
    var r = confirm('Enable mail?');
    if(r==true)
    {
        jQuery.ajax({
          'type'  : 'post',

          'data'  : 'id=' + id+'&type=' + type,
          'url'  : $('#liveSite').val()+'index.php?r=hr/mail/changestatus',
          'cache': false,
          'success':function(data){
            if(data=='fail'){
                t8.error('Error');
            }else {                   
                reloadTable('#tbl_mail_settings');
                t8.success('Mail Unblocked!');
            }
           }
        });
    }
};", CClientScript::POS_HEAD);
?>
<style>
    #mailsettingindexdropdown .material-select-label {
        display: none;
    }
    </style>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[8].edit_mail !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/mail/create&id="+datas[8].id, "Edit Mail Settings ", "lg");
                }
            };
        }
        if (datas[8].disable_mail !== 0) {
            items.disable = {
                name: "Disable Mail",
                icon: "fa-ban",
                callback: function () {
                     disablemail(datas[8].id);

                }
            };
        }
        if (datas[8].enable_mail !== 0) {
            items.enable = {
                name: "Enable Mail",
                icon: "fa-check-square-o",
                callback: function () {
                     enablemail(datas[8].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame"> Mail Settings
        <div class="pull-right dis-flx">
        <div class="material col-sm-12 pd-zero" id="mailsettingindexdropdown"> 
        <span class="col-sm-3 pull-right">    
            <?php echo CHtml::dropdownlist('functionality_type', '', MasterMailDetail::getMailfunctionality(), array('prompt' => 'All', 'title' => 'Mail Functions','data-search'=>true, 'onchange' => 'loadlist();')); ?>		
          </span>
        </div>
           <?php
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_mail_setting_add'])  || Yii::app()->user->authorised_user == 1) {
            ?>
             <a class="ad-btn" title="Add" onclick="loadPopupModal('hr/mail/create', 'Add Mail Settings', 'lg')">                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_mail_settings" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Functionality</th>
                        <th>Mail From</th>
                        <th>Applicant</th>                            
                        <th>Reporting Manager</th>
                        <th>Notifying Employees</th>
                        <th>Custom Mail</th>
                        <th>Status</th>
                    </tr>
                </thead>
               
            </table>
        </div>
    </div>
</section>